/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonList;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonString;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ReadOnlyValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.IonReaderTreeSystem;
import software.amazon.ion.impl.LocalSymbolTableImports;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SubstituteSymbolTable;
import software.amazon.ion.impl.SymbolTableReader;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.util.IonTextUtils;

final class LocalSymbolTable
implements SymbolTable {
    private static final int DEFAULT_CAPACITY = 16;
    private final LocalSymbolTableImports myImportsList;
    private final ValueFactory myImageFactory;
    private final Map<String, Integer> mySymbolsMap;
    private boolean isReadOnly;
    private IonStruct myImage;
    private String[] mySymbolNames;
    private int mySymbolsCount;
    private final int myFirstLocalSid;

    private void buildSymbolsMap() {
        int n = this.myFirstLocalSid;
        int n2 = 0;
        while (n2 < this.mySymbolNames.length) {
            String string = this.mySymbolNames[n2];
            if (string != null) {
                LocalSymbolTable.putToMapIfNotThere(this.mySymbolsMap, string, n);
            }
            ++n2;
            ++n;
        }
    }

    private LocalSymbolTable(ValueFactory valueFactory, LocalSymbolTableImports localSymbolTableImports, List<String> list) {
        if (list == null || list.isEmpty()) {
            this.mySymbolsCount = 0;
            this.mySymbolNames = PrivateUtils.EMPTY_STRING_ARRAY;
        } else {
            this.mySymbolsCount = list.size();
            this.mySymbolNames = list.toArray(new String[this.mySymbolsCount]);
        }
        this.myImageFactory = valueFactory;
        this.myImportsList = localSymbolTableImports;
        this.myFirstLocalSid = this.myImportsList.getMaxId() + 1;
        this.mySymbolsMap = new HashMap<String, Integer>();
        this.buildSymbolsMap();
    }

    private LocalSymbolTable(LocalSymbolTable localSymbolTable, int n) {
        this.isReadOnly = false;
        this.myFirstLocalSid = localSymbolTable.myFirstLocalSid;
        this.myImage = null;
        this.myImageFactory = localSymbolTable.myImageFactory;
        this.myImportsList = localSymbolTable.myImportsList;
        this.mySymbolsCount = n - this.myImportsList.getMaxId();
        this.mySymbolNames = PrivateUtils.copyOf(localSymbolTable.mySymbolNames, this.mySymbolsCount);
        if (n == localSymbolTable.getMaxId()) {
            this.mySymbolsMap = new HashMap<String, Integer>(localSymbolTable.mySymbolsMap);
        } else {
            this.mySymbolsMap = new HashMap<String, Integer>(this.mySymbolsCount);
            this.buildSymbolsMap();
        }
    }

    static LocalSymbolTable makeNewLocalSymbolTable(ValueFactory valueFactory, SymbolTable symbolTable, List<String> list, SymbolTable ... symbolTableArray) {
        LocalSymbolTableImports localSymbolTableImports = new LocalSymbolTableImports(symbolTable, symbolTableArray);
        return new LocalSymbolTable(valueFactory, localSymbolTableImports, list);
    }

    static LocalSymbolTable makeNewLocalSymbolTable(SymbolTable symbolTable, IonCatalog ionCatalog, IonStruct ionStruct) {
        IonSystem ionSystem = ionStruct.getSystem();
        IonReaderTreeSystem ionReaderTreeSystem = new IonReaderTreeSystem(ionStruct);
        LocalSymbolTable localSymbolTable = LocalSymbolTable.makeNewLocalSymbolTable((ValueFactory)ionSystem, symbolTable, ionCatalog, ionReaderTreeSystem, false);
        localSymbolTable.myImage = ionStruct;
        return localSymbolTable;
    }

    static LocalSymbolTable makeNewLocalSymbolTable(ValueFactory valueFactory, SymbolTable symbolTable, IonCatalog ionCatalog, IonReader ionReader, boolean bl) {
        Object object;
        IonType ionType;
        if (!bl) {
            ionReader.next();
        }
        assert (ionReader.getType() == IonType.STRUCT) : "invalid symbol table image passed in reader " + (Object)((Object)ionReader.getType()) + " encountered when a struct was expected";
        assert ("$ion_symbol_table".equals(ionReader.getTypeAnnotations()[0])) : "local symbol tables must be annotated by $ion_symbol_table";
        ionReader.stepIn();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<SymbolTable> arrayList2 = new ArrayList<SymbolTable>();
        arrayList2.add(symbolTable);
        while ((ionType = ionReader.next()) != null) {
            Object object2;
            if (ionReader.isNullValue()) continue;
            object = ionReader.getFieldNameSymbol();
            int n = object.getSid();
            if (n == -1) {
                object2 = ionReader.getFieldName();
                n = PrivateUtils.getSidForSymbolTableField(object2);
            }
            switch (n) {
                case 7: {
                    if (ionType != IonType.LIST) break;
                    ionReader.stepIn();
                    while ((object2 = ionReader.next()) != null) {
                        String string = null;
                        if (object2 == IonType.STRING && (string = ionReader.stringValue()) != null && string.length() == 0) {
                            string = null;
                        }
                        arrayList.add(string);
                    }
                    ionReader.stepOut();
                    break;
                }
                case 6: {
                    if (ionType != IonType.LIST) break;
                    LocalSymbolTable.prepImportsList(arrayList2, ionReader, ionCatalog);
                    break;
                }
            }
        }
        ionReader.stepOut();
        object = new LocalSymbolTableImports(arrayList2);
        return new LocalSymbolTable(valueFactory, (LocalSymbolTableImports)object, arrayList);
    }

    synchronized LocalSymbolTable makeCopy() {
        return new LocalSymbolTable(this, this.getMaxId());
    }

    synchronized LocalSymbolTable makeCopy(int n) {
        return new LocalSymbolTable(this, n);
    }

    @Override
    public boolean isLocalTable() {
        return true;
    }

    @Override
    public boolean isSharedTable() {
        return false;
    }

    @Override
    public boolean isSystemTable() {
        return false;
    }

    @Override
    public boolean isSubstitute() {
        return false;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public synchronized void makeReadOnly() {
        this.isReadOnly = true;
    }

    @Override
    public int getImportedMaxId() {
        return this.myImportsList.getMaxId();
    }

    @Override
    public synchronized int getMaxId() {
        int n = this.mySymbolsCount + this.myImportsList.getMaxId();
        return n;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getIonVersionId() {
        SymbolTable symbolTable = this.myImportsList.getSystemSymbolTable();
        return symbolTable.getIonVersionId();
    }

    @Override
    public synchronized Iterator<String> iterateDeclaredSymbolNames() {
        return new SymbolIterator(this.mySymbolNames, this.mySymbolsCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findKnownSymbol(int n) {
        String string = null;
        if (n < 1) {
            String string2 = "symbol IDs must be greater than 0";
            throw new IllegalArgumentException(string2);
        }
        if (n < this.myFirstLocalSid) {
            string = this.myImportsList.findKnownSymbol(n);
        } else {
            String[] stringArray;
            int n2 = n - this.myFirstLocalSid;
            LocalSymbolTable localSymbolTable = this;
            synchronized (localSymbolTable) {
                stringArray = this.mySymbolNames;
            }
            if (n2 < stringArray.length) {
                string = stringArray[n2];
            }
        }
        return string;
    }

    @Override
    public int findSymbol(String string) {
        if (string.length() < 1) {
            throw new EmptySymbolException();
        }
        int n = this.myImportsList.findSymbol(string);
        if (n == -1) {
            n = this.findLocalSymbol(string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLocalSymbol(String string) {
        Integer n;
        assert (string.length() > 0);
        LocalSymbolTable localSymbolTable = this;
        synchronized (localSymbolTable) {
            n = this.mySymbolsMap.get(string);
        }
        if (n != null) {
            assert (n != -1);
            return n;
        }
        return -1;
    }

    @Override
    public synchronized SymbolToken intern(String string) {
        SymbolToken symbolToken = this.find(string);
        if (symbolToken == null) {
            LocalSymbolTable.validateSymbol(string);
            int n = this.putSymbol(string);
            symbolToken = new SymbolTokenImpl(string, n);
        }
        return symbolToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolToken find(String string) {
        if (string.length() < 1) {
            throw new EmptySymbolException();
        }
        SymbolToken symbolToken = this.myImportsList.find(string);
        if (symbolToken == null) {
            String[] stringArray;
            Integer n;
            LocalSymbolTable localSymbolTable = this;
            synchronized (localSymbolTable) {
                n = this.mySymbolsMap.get(string);
                stringArray = this.mySymbolNames;
            }
            if (n != null) {
                int n2 = n - this.myFirstLocalSid;
                String string2 = stringArray[n2];
                assert (string2 != null);
                symbolToken = new SymbolTokenImpl(string2, n);
            }
        }
        return symbolToken;
    }

    private static final void validateSymbol(String string) {
        if (string == null || string.length() < 1) {
            String string2 = "symbols must contain 1 or more characters";
            throw new IllegalArgumentException(string2);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\ud800' || c > '\udfff') continue;
            if (c >= '\udc00') {
                String string3 = "unpaired trailing surrogate in symbol name at position " + i;
                throw new IllegalArgumentException(string3);
            }
            if (++i == string.length()) {
                String string4 = "unmatched leading surrogate in symbol name at position " + i;
                throw new IllegalArgumentException(string4);
            }
            c = string.charAt(i);
            if (c >= '\udc00' && c <= '\udfff') continue;
            String string5 = "unmatched leading surrogate in symbol name at position " + i;
            throw new IllegalArgumentException(string5);
        }
    }

    private int putSymbol(String string) {
        int n;
        assert (string.length() != 0);
        if (this.isReadOnly) {
            throw new ReadOnlyValueException(SymbolTable.class);
        }
        if (this.mySymbolsCount == this.mySymbolNames.length) {
            n = this.mySymbolsCount * 2;
            if (n < 16) {
                n = 16;
            }
            String[] stringArray = new String[n];
            System.arraycopy(this.mySymbolNames, 0, stringArray, 0, this.mySymbolsCount);
            this.mySymbolNames = stringArray;
        }
        n = this.mySymbolsCount + this.myFirstLocalSid;
        assert (n == this.getMaxId() + 1);
        LocalSymbolTable.putToMapIfNotThere(this.mySymbolsMap, string, n);
        this.mySymbolNames[this.mySymbolsCount] = string;
        ++this.mySymbolsCount;
        if (this.myImage != null) {
            this.recordLocalSymbolInIonRep(this.myImage, string, n);
        }
        return n;
    }

    private static void putToMapIfNotThere(Map<String, Integer> map, String string, int n) {
        Integer n2 = map.put(string, n);
        if (n2 != null) {
            assert (n2 < n);
            map.put(string, n2);
        }
    }

    @Override
    public SymbolTable getSystemSymbolTable() {
        return this.myImportsList.getSystemSymbolTable();
    }

    @Override
    public SymbolTable[] getImportedTables() {
        return this.myImportsList.getImportedTables();
    }

    SymbolTable[] getImportedTablesNoCopy() {
        return this.myImportsList.getImportedTablesNoCopy();
    }

    @Override
    public void writeTo(IonWriter ionWriter) throws IOException {
        SymbolTableReader symbolTableReader = new SymbolTableReader(this);
        ionWriter.writeValues(symbolTableReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IonStruct getIonRepresentation(ValueFactory valueFactory) {
        IonStruct ionStruct;
        if (valueFactory == null) {
            throw new IonExceptionNoSystem("can't create representation without a system");
        }
        if (valueFactory != this.myImageFactory) {
            throw new IonException("wrong system");
        }
        LocalSymbolTable localSymbolTable = this;
        synchronized (localSymbolTable) {
            ionStruct = this.myImage;
            if (ionStruct == null) {
                this.myImage = ionStruct = this.makeIonRepresentation(this.myImageFactory);
            }
        }
        return ionStruct;
    }

    private IonStruct makeIonRepresentation(ValueFactory valueFactory) {
        Object object;
        int n;
        IonStruct ionStruct = valueFactory.newEmptyStruct();
        ionStruct.addTypeAnnotation("$ion_symbol_table");
        SymbolTable[] symbolTableArray = this.getImportedTablesNoCopy();
        if (symbolTableArray.length > 1) {
            IonList ionList = valueFactory.newEmptyList();
            for (n = 1; n < symbolTableArray.length; ++n) {
                object = symbolTableArray[n];
                IonStruct ionStruct2 = valueFactory.newEmptyStruct();
                ionStruct2.add("name", (IonValue)valueFactory.newString(object.getName()));
                ionStruct2.add("version", (IonValue)valueFactory.newInt(object.getVersion()));
                ionStruct2.add("max_id", (IonValue)valueFactory.newInt(object.getMaxId()));
                ionList.add(ionStruct2);
            }
            ionStruct.add("imports", (IonValue)ionList);
        }
        if (this.mySymbolsCount > 0) {
            int n2 = this.myFirstLocalSid;
            n = 0;
            while (n < this.mySymbolsCount) {
                object = this.mySymbolNames[n];
                this.recordLocalSymbolInIonRep(ionStruct, (String)object, n2);
                ++n;
                ++n2;
            }
        }
        return ionStruct;
    }

    private void recordLocalSymbolInIonRep(IonStruct ionStruct, String string, int n) {
        assert (n >= this.myFirstLocalSid);
        IonSystem ionSystem = ionStruct.getSystem();
        IonValue ionValue = ionStruct.get("symbols");
        while (ionValue != null && ionValue.getType() != IonType.LIST) {
            ionStruct.remove(ionValue);
            ionValue = ionStruct.get("symbols");
        }
        if (ionValue == null) {
            ionValue = ionSystem.newEmptyList();
            ionStruct.put("symbols", ionValue);
        }
        int n2 = n - this.myFirstLocalSid;
        IonString ionString = ionSystem.newString(string);
        ((IonList)ionValue).add(n2, ionString);
    }

    private static void prepImportsList(List<SymbolTable> list, IonReader ionReader, IonCatalog ionCatalog) {
        IonType ionType;
        assert ("imports".equals(ionReader.getFieldName()));
        ionReader.stepIn();
        while ((ionType = ionReader.next()) != null) {
            SymbolTable symbolTable;
            if (ionReader.isNullValue() || ionType != IonType.STRUCT || (symbolTable = LocalSymbolTable.readOneImport(ionReader, ionCatalog)) == null) continue;
            list.add(symbolTable);
        }
        ionReader.stepOut();
    }

    private static SymbolTable readOneImport(IonReader ionReader, IonCatalog ionCatalog) {
        Object object;
        IonType ionType;
        assert (ionReader.getType() == IonType.STRUCT);
        String string = null;
        int n = -1;
        int n2 = -1;
        ionReader.stepIn();
        while ((ionType = ionReader.next()) != null) {
            if (ionReader.isNullValue()) continue;
            object = ionReader.getFieldNameSymbol();
            int n3 = object.getSid();
            if (n3 == -1) {
                String string2 = ionReader.getFieldName();
                n3 = PrivateUtils.getSidForSymbolTableField(string2);
            }
            switch (n3) {
                case 4: {
                    if (ionType != IonType.STRING) break;
                    string = ionReader.stringValue();
                    break;
                }
                case 5: {
                    if (ionType != IonType.INT) break;
                    n = ionReader.intValue();
                    break;
                }
                case 8: {
                    if (ionType != IonType.INT) break;
                    n2 = ionReader.intValue();
                    break;
                }
            }
        }
        ionReader.stepOut();
        if (string == null || string.length() == 0 || string.equals("$ion")) {
            return null;
        }
        if (n < 1) {
            n = 1;
        }
        object = null;
        if (ionCatalog != null) {
            object = ionCatalog.getTable(string, n);
        }
        if (n2 < 0) {
            if (object == null || n != object.getVersion()) {
                String string3 = "Import of shared table " + IonTextUtils.printString(string) + " lacks a valid max_id field, but an exact match was not" + " found in the catalog";
                if (object != null) {
                    string3 = string3 + " (found version " + object.getVersion() + ")";
                }
                throw new IonException(string3);
            }
            n2 = object.getMaxId();
        }
        if (object == null) {
            assert (n2 >= 0);
            object = new SubstituteSymbolTable(string, n, n2);
        } else if (object.getVersion() != n || object.getMaxId() != n2) {
            object = new SubstituteSymbolTable((SymbolTable)object, n, n2);
        }
        return object;
    }

    public static String unknownSymbolName(int n) {
        assert (n > 0);
        return "$" + n;
    }

    public String toString() {
        return "(LocalSymbolTable max_id:" + this.getMaxId() + ')';
    }

    boolean symtabExtends(SymbolTable symbolTable) {
        LocalSymbolTable localSymbolTable = (LocalSymbolTable)symbolTable;
        if (this.getMaxId() < localSymbolTable.getMaxId()) {
            return false;
        }
        if (!this.myImportsList.equalImports(localSymbolTable.myImportsList)) {
            return false;
        }
        int n = localSymbolTable.mySymbolsCount;
        if (n == 0) {
            return true;
        }
        if (this.mySymbolsCount < n) {
            return false;
        }
        String[] stringArray = localSymbolTable.mySymbolNames;
        if (!PrivateUtils.safeEquals(this.mySymbolNames[n - 1], stringArray[n - 1])) {
            return false;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (PrivateUtils.safeEquals(this.mySymbolNames[i], stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static final class SymbolIterator
    implements Iterator<String> {
        private final String[] mySymbolNames;
        private final int mySymbolsCount;
        private int _idx = 0;

        SymbolIterator(String[] stringArray, int n) {
            this.mySymbolNames = stringArray;
            this.mySymbolsCount = n;
        }

        @Override
        public boolean hasNext() {
            return this._idx < this.mySymbolsCount;
        }

        @Override
        public String next() {
            if (this._idx < this.mySymbolsCount) {
                return this.mySymbolNames[this._idx++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class IonExceptionNoSystem
    extends IonException {
        private static final long serialVersionUID = 1L;

        IonExceptionNoSystem(String string) {
            super(string);
        }
    }
}

