/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.ion.IonBlob;
import software.amazon.ion.IonBool;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonClob;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonDecimal;
import software.amazon.ion.IonException;
import software.amazon.ion.IonFloat;
import software.amazon.ion.IonInt;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonString;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSymbol;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.IonWriterSystem;
import software.amazon.ion.impl.PrivateIonDatagram;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.system.IonWriterBuilder;

final class IonWriterSystemTree
extends IonWriterSystem {
    private final ValueFactory _factory;
    private final IonCatalog _catalog;
    private final int _initialDepth;
    private boolean _in_struct;
    private IonContainer _current_parent;
    private int _parent_stack_top = 0;
    private IonContainer[] _parent_stack = new IonContainer[10];

    protected IonWriterSystemTree(SymbolTable symbolTable, IonCatalog ionCatalog, IonContainer ionContainer, IonWriterBuilder.InitialIvmHandling initialIvmHandling) {
        super(symbolTable, initialIvmHandling, IonWriterBuilder.IvmMinimizing.ADJACENT);
        if (ionContainer == null) {
            throw new NullPointerException();
        }
        this._factory = ionContainer.getSystem();
        this._catalog = ionCatalog;
        this._current_parent = ionContainer;
        this._in_struct = this._current_parent instanceof IonStruct;
        int n = 0;
        if (!(ionContainer instanceof IonDatagram)) {
            IonContainer ionContainer2 = ionContainer;
            do {
                ++n;
            } while ((ionContainer2 = ionContainer2.getContainer()) != null);
        }
        this._initialDepth = n;
    }

    @Override
    public int getDepth() {
        return this._parent_stack_top + this._initialDepth;
    }

    protected IonType getContainer() {
        IonType ionType = this._parent_stack_top > 0 ? this._parent_stack[this._parent_stack_top - 1].getType() : IonType.DATAGRAM;
        return ionType;
    }

    @Override
    public boolean isInStruct() {
        return this._in_struct;
    }

    protected IonValue get_root() {
        IonContainer ionContainer = this._parent_stack_top > 0 ? this._parent_stack[0] : this._current_parent;
        return ionContainer;
    }

    private void pushParent(IonContainer ionContainer) {
        int n = this._parent_stack.length;
        if (this._parent_stack_top >= n) {
            int n2 = n * 2;
            IonContainer[] ionContainerArray = new IonContainer[n2];
            System.arraycopy(this._parent_stack, 0, ionContainerArray, 0, n);
            this._parent_stack = ionContainerArray;
        }
        this._parent_stack[this._parent_stack_top++] = this._current_parent;
        this._current_parent = ionContainer;
        this._in_struct = this._current_parent instanceof IonStruct;
    }

    private void popParent() {
        if (this._parent_stack_top < 1) {
            throw new IllegalStateException("Cannot stepOut any further, already at top level.");
        }
        --this._parent_stack_top;
        this._current_parent = this._parent_stack[this._parent_stack_top];
        this._in_struct = this._current_parent instanceof IonStruct;
    }

    private void append(IonValue ionValue) {
        Object object;
        try {
            super.startValue();
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        if (this.hasAnnotations()) {
            object = this.getTypeAnnotationSymbols();
            ((PrivateIonValue)ionValue).setTypeAnnotationSymbols((SymbolToken)object);
            this.clearAnnotations();
        }
        if (this._in_struct) {
            object = this.assumeFieldNameSymbol();
            IonStruct ionStruct = (IonStruct)this._current_parent;
            ionStruct.add((SymbolToken)object, ionValue);
            this.clearFieldName();
        } else {
            ((IonSequence)this._current_parent).add(ionValue);
        }
    }

    @Override
    public void stepIn(IonType ionType) throws IOException {
        IonContainer ionContainer;
        switch (ionType) {
            case LIST: {
                ionContainer = this._factory.newEmptyList();
                break;
            }
            case SEXP: {
                ionContainer = this._factory.newEmptySexp();
                break;
            }
            case STRUCT: {
                ionContainer = this._factory.newEmptyStruct();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.append(ionContainer);
        this.pushParent(ionContainer);
    }

    @Override
    public void stepOut() throws IOException {
        IonContainer ionContainer = this._current_parent;
        this.popParent();
        if (this._current_parent instanceof IonDatagram && PrivateUtils.valueIsLocalSymbolTable(ionContainer)) {
            SymbolTable symbolTable = PrivateUtils.newLocalSymtab(this._default_system_symbol_table, this._catalog, (IonStruct)ionContainer);
            this.setSymbolTable(symbolTable);
        }
    }

    @Override
    void writeIonVersionMarkerAsIs(SymbolTable symbolTable) throws IOException {
        this.startValue();
        IonValue ionValue = this.get_root();
        ((PrivateIonDatagram)ionValue).appendTrailingSymbolTable(symbolTable);
        this.endValue();
    }

    @Override
    void writeLocalSymtab(SymbolTable symbolTable) throws IOException {
        IonValue ionValue = this.get_root();
        ((PrivateIonDatagram)ionValue).appendTrailingSymbolTable(symbolTable);
        super.writeLocalSymtab(symbolTable);
    }

    @Override
    final SymbolTable inject_local_symbol_table() throws IOException {
        return PrivateUtils.newLocalSymtab(this._factory, this.getSymbolTable(), new SymbolTable[0]);
    }

    @Override
    public void writeNull(IonType ionType) throws IOException {
        IonValue ionValue = this._factory.newNull(ionType);
        this.append(ionValue);
    }

    @Override
    public void writeBool(boolean bl) throws IOException {
        IonBool ionBool = this._factory.newBool(bl);
        this.append(ionBool);
    }

    public void writeInt(int n) throws IOException {
        IonInt ionInt = this._factory.newInt(n);
        this.append(ionInt);
    }

    @Override
    public void writeInt(long l) throws IOException {
        IonInt ionInt = this._factory.newInt(l);
        this.append(ionInt);
    }

    @Override
    public void writeInt(BigInteger bigInteger) throws IOException {
        IonInt ionInt = this._factory.newInt(bigInteger);
        this.append(ionInt);
    }

    @Override
    public void writeFloat(double d) throws IOException {
        IonFloat ionFloat = this._factory.newNullFloat();
        ionFloat.setValue(d);
        this.append(ionFloat);
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        IonDecimal ionDecimal = this._factory.newNullDecimal();
        ionDecimal.setValue(bigDecimal);
        this.append(ionDecimal);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws IOException {
        IonTimestamp ionTimestamp = this._factory.newTimestamp(timestamp);
        this.append(ionTimestamp);
    }

    @Override
    public void writeString(String string) throws IOException {
        IonString ionString = this._factory.newString(string);
        this.append(ionString);
    }

    @Override
    void writeSymbolAsIs(int n) {
        String string = this.getSymbolTable().findKnownSymbol(n);
        SymbolTokenImpl symbolTokenImpl = new SymbolTokenImpl(string, n);
        IonSymbol ionSymbol = this._factory.newSymbol(symbolTokenImpl);
        this.append(ionSymbol);
    }

    @Override
    public void writeSymbolAsIs(String string) {
        IonSymbol ionSymbol = this._factory.newSymbol(string);
        this.append(ionSymbol);
    }

    @Override
    public void writeClob(byte[] byArray, int n, int n2) throws IOException {
        IonClob ionClob = this._factory.newClob(byArray, n, n2);
        this.append(ionClob);
    }

    @Override
    public void writeBlob(byte[] byArray, int n, int n2) throws IOException {
        IonBlob ionBlob = this._factory.newBlob(byArray, n, n2);
        this.append(ionBlob);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

