/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.impl.PrivateIonWriterBase;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.system.IonWriterBuilder;

abstract class IonWriterSystem
extends PrivateIonWriterBase {
    final SymbolTable _default_system_symbol_table;
    private IonWriterBuilder.InitialIvmHandling _initial_ivm_handling;
    private final IonWriterBuilder.IvmMinimizing _ivm_minimizing;
    private boolean _previous_value_was_ivm;
    private boolean _anything_written;
    private SymbolTable _symbol_table;
    private IonType _field_name_type;
    private String _field_name;
    private int _field_name_sid = -1;
    private static final int DEFAULT_ANNOTATION_COUNT = 4;
    private int _annotation_count;
    private SymbolToken[] _annotations = new SymbolToken[4];

    IonWriterSystem(SymbolTable symbolTable, IonWriterBuilder.InitialIvmHandling initialIvmHandling, IonWriterBuilder.IvmMinimizing ivmMinimizing) {
        symbolTable.getClass();
        this._default_system_symbol_table = symbolTable;
        this._symbol_table = symbolTable;
        this._initial_ivm_handling = initialIvmHandling;
        this._ivm_minimizing = ivmMinimizing;
    }

    final SymbolTable getDefaultSystemSymtab() {
        return this._default_system_symbol_table;
    }

    @Override
    public final SymbolTable getSymbolTable() {
        return this._symbol_table;
    }

    @Override
    public final void setSymbolTable(SymbolTable symbolTable) throws IOException {
        if (symbolTable == null || PrivateUtils.symtabIsSharedNotSystem(symbolTable)) {
            throw new IllegalArgumentException("symbol table must be local or system to be set, or reset");
        }
        if (this.getDepth() > 0) {
            throw new IllegalStateException("the symbol table cannot be set, or reset, while a container is open");
        }
        this._symbol_table = symbolTable;
    }

    boolean shouldWriteIvm() {
        if (this._initial_ivm_handling == IonWriterBuilder.InitialIvmHandling.ENSURE) {
            return true;
        }
        if (this._initial_ivm_handling == IonWriterBuilder.InitialIvmHandling.SUPPRESS) {
            return false;
        }
        if (this._ivm_minimizing == IonWriterBuilder.IvmMinimizing.ADJACENT) {
            return !this._previous_value_was_ivm;
        }
        if (this._ivm_minimizing == IonWriterBuilder.IvmMinimizing.DISTANT) {
            return !this._anything_written;
        }
        return true;
    }

    final void writeIonVersionMarker(SymbolTable symbolTable) throws IOException {
        if (this.getDepth() != 0) {
            String string = "Ion Version Markers are only valid at the top level of a data stream";
            throw new IllegalStateException(string);
        }
        assert (symbolTable.isSystemTable());
        if (!"$ion_1_0".equals(symbolTable.getIonVersionId())) {
            String string = "This library only supports Ion 1.0";
            throw new UnsupportedOperationException(string);
        }
        if (this.shouldWriteIvm()) {
            this._initial_ivm_handling = null;
            this.writeIonVersionMarkerAsIs(symbolTable);
            this._previous_value_was_ivm = true;
        }
        this._symbol_table = symbolTable;
    }

    abstract void writeIonVersionMarkerAsIs(SymbolTable var1) throws IOException;

    @Override
    public final void writeIonVersionMarker() throws IOException {
        this.writeIonVersionMarker(this._default_system_symbol_table);
    }

    void writeLocalSymtab(SymbolTable symbolTable) throws IOException {
        assert (symbolTable.isLocalTable());
        this._symbol_table = symbolTable;
    }

    SymbolTable inject_local_symbol_table() throws IOException {
        assert (this._symbol_table.isSystemTable());
        return PrivateUtils.newLocalSymtab(null, this._symbol_table, new SymbolTable[0]);
    }

    @Override
    final String assumeKnownSymbol(int n) {
        String string = this._symbol_table.findKnownSymbol(n);
        if (string == null) {
            throw new UnknownSymbolException(n);
        }
        return string;
    }

    final int add_symbol(String string) throws IOException {
        int n;
        if (this._symbol_table.isSystemTable()) {
            n = this._symbol_table.findSymbol(string);
            if (n != -1) {
                return n;
            }
            this._symbol_table = this.inject_local_symbol_table();
        }
        assert (this._symbol_table.isLocalTable());
        n = this._symbol_table.intern(string).getSid();
        return n;
    }

    void startValue() throws IOException {
        if (this._initial_ivm_handling == IonWriterBuilder.InitialIvmHandling.ENSURE) {
            this.writeIonVersionMarker(this._default_system_symbol_table);
        }
    }

    void endValue() {
        this._initial_ivm_handling = null;
        this._previous_value_was_ivm = false;
        this._anything_written = true;
    }

    abstract void writeSymbolAsIs(int var1) throws IOException;

    abstract void writeSymbolAsIs(String var1) throws IOException;

    @Override
    final void writeSymbol(int n) throws IOException {
        if (n < 1) {
            throw new IllegalArgumentException("symbol IDs are greater than 0");
        }
        if (n == 2 && this.getDepth() == 0 && this._annotation_count == 0) {
            this.writeIonVersionMarker();
        } else {
            this.writeSymbolAsIs(n);
        }
    }

    @Override
    public final void writeSymbol(String string) throws IOException {
        if ("$ion_1_0".equals(string) && this.getDepth() == 0 && this._annotation_count == 0) {
            this.writeIonVersionMarker();
        } else {
            this.writeSymbolAsIs(string);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.getDepth() != 0) {
            throw new IllegalStateException("IonWriter.finish() can only be called at top-level.");
        }
        this.flush();
        this._previous_value_was_ivm = false;
        this._initial_ivm_handling = IonWriterBuilder.InitialIvmHandling.ENSURE;
        this._symbol_table = this._default_system_symbol_table;
    }

    @Override
    public final boolean isFieldNameSet() {
        if (this._field_name_type != null) {
            switch (this._field_name_type) {
                case STRING: {
                    return this._field_name != null && this._field_name.length() > 0;
                }
                case INT: {
                    return this._field_name_sid > 0;
                }
            }
        }
        return false;
    }

    final void clearFieldName() {
        this._field_name_type = null;
        this._field_name = null;
        this._field_name_sid = -1;
    }

    @Override
    public final void setFieldName(String string) {
        if (!this.isInStruct()) {
            throw new IllegalStateException();
        }
        if (string.length() == 0) {
            throw new EmptySymbolException();
        }
        this._field_name_type = IonType.STRING;
        this._field_name = string;
        this._field_name_sid = -1;
    }

    @Override
    public final void setFieldNameSymbol(SymbolToken symbolToken) {
        if (!this.isInStruct()) {
            throw new IllegalStateException();
        }
        String string = symbolToken.getText();
        if (string != null) {
            if (string.length() == 0) {
                throw new EmptySymbolException();
            }
            this._field_name_type = IonType.STRING;
            this._field_name = string;
            this._field_name_sid = -1;
        } else {
            int n = symbolToken.getSid();
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            this._field_name_type = IonType.INT;
            this._field_name_sid = n;
            this._field_name = null;
        }
    }

    final SymbolToken assumeFieldNameSymbol() {
        if (this._field_name_type == null) {
            throw new IllegalStateException("IonWriter.setFieldName() must be called before writing a value into a struct.");
        }
        assert (this._field_name != null ^ this._field_name_sid >= 0);
        return new SymbolTokenImpl(this._field_name, this._field_name_sid);
    }

    final void ensureAnnotationCapacity(int n) {
        int n2;
        int n3;
        int n4 = n3 = this._annotations == null ? 0 : this._annotations.length;
        if (n < n3) {
            return;
        }
        int n5 = n2 = this._annotations == null ? 10 : this._annotations.length * 2;
        if (n > n2) {
            n2 = n;
        }
        SymbolToken[] symbolTokenArray = new SymbolToken[n2];
        if (n3 > 0) {
            System.arraycopy(this._annotations, 0, symbolTokenArray, 0, n3);
        }
        this._annotations = symbolTokenArray;
    }

    final int[] internAnnotationsAndGetSids() throws IOException {
        int n = this._annotation_count;
        if (n == 0) {
            return PrivateUtils.EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            SymbolToken symbolToken = this._annotations[i];
            int n2 = symbolToken.getSid();
            if (n2 == -1) {
                String string = symbolToken.getText();
                n2 = this.add_symbol(string);
                this._annotations[i] = new SymbolTokenImpl(string, n2);
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    final boolean hasAnnotations() {
        return this._annotation_count != 0;
    }

    final int annotationCount() {
        return this._annotation_count;
    }

    final void clearAnnotations() {
        this._annotation_count = 0;
    }

    @Override
    final boolean has_annotation(String string, int n) {
        assert (this._symbol_table.findKnownSymbol(n).equals(string));
        if (this._annotation_count < 1) {
            return false;
        }
        for (int i = 0; i < this._annotation_count; ++i) {
            if (!string.equals(this._annotations[i].getText())) continue;
            return true;
        }
        return false;
    }

    final SymbolToken[] getTypeAnnotationSymbols() {
        int n = this._annotation_count;
        if (n == 0) {
            return SymbolToken.EMPTY_ARRAY;
        }
        SymbolToken[] symbolTokenArray = new SymbolToken[n];
        System.arraycopy(this._annotations, 0, symbolTokenArray, 0, n);
        return symbolTokenArray;
    }

    @Override
    public final void setTypeAnnotationSymbols(SymbolToken ... symbolTokenArray) {
        if (symbolTokenArray == null || symbolTokenArray.length == 0) {
            this._annotation_count = 0;
        } else {
            int n = symbolTokenArray.length;
            this.ensureAnnotationCapacity(n);
            SymbolTable symbolTable = this.getSymbolTable();
            for (int i = 0; i < n; ++i) {
                SymbolToken symbolToken = symbolTokenArray[i];
                this._annotations[i] = symbolToken = PrivateUtils.localize(symbolTable, symbolToken);
            }
            this._annotation_count = n;
        }
    }

    @Override
    final String[] getTypeAnnotations() {
        return PrivateUtils.toStrings(this._annotations, this._annotation_count);
    }

    @Override
    public final void setTypeAnnotations(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._annotation_count = 0;
        } else {
            SymbolToken[] symbolTokenArray = PrivateUtils.newSymbolTokens(this.getSymbolTable(), stringArray);
            int n = symbolTokenArray.length;
            this.ensureAnnotationCapacity(n);
            System.arraycopy(symbolTokenArray, 0, this._annotations, 0, n);
            this._annotation_count = n;
        }
    }

    @Override
    public final void addTypeAnnotation(String string) {
        SymbolToken symbolToken = PrivateUtils.newSymbolToken(this.getSymbolTable(), string);
        this.ensureAnnotationCapacity(this._annotation_count + 1);
        this._annotations[this._annotation_count++] = symbolToken;
    }

    @Override
    final int[] getTypeAnnotationIds() {
        return PrivateUtils.toSids(this._annotations, this._annotation_count);
    }
}

