/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.UnexpectedEofException;
import software.amazon.ion.impl.Base64Encoder;
import software.amazon.ion.impl.IonTokenConstsX;
import software.amazon.ion.impl.IonUTF8;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.impl.UnifiedSavePointManagerX;
import software.amazon.ion.util.IonTextUtils;

final class IonReaderTextRawTokensX {
    static final boolean _debug = false;
    private static final Appendable NULL_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence charSequence) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            return this;
        }
    };
    static final int BASE64_EOF = 128;
    static final int[] BASE64_CHAR_TO_BIN = Base64Encoder.Base64EncodingCharToInt;
    static final int BASE64_TERMINATOR_CHAR = Base64Encoder.Base64EncodingTerminator;
    private UnifiedInputStreamX _stream = null;
    private int _token = -1;
    private boolean _unfinished_token;
    private long _line_count;
    private long _line_starting_position;
    private boolean _line_count_has_cached = false;
    private long _line_count_cached;
    private long _line_offset_cached;
    private int _base64_prefetch_count;
    private int _base64_prefetch_stack;

    public IonReaderTextRawTokensX(UnifiedInputStreamX unifiedInputStreamX) {
        this(unifiedInputStreamX, 1L, 1L);
    }

    public IonReaderTextRawTokensX(UnifiedInputStreamX unifiedInputStreamX, long l, long l2) {
        this._stream = unifiedInputStreamX;
        this._line_count = l;
        this._line_starting_position = this._stream.getPosition() - l2;
    }

    public void close() throws IOException {
        this._stream.close();
    }

    public int getToken() {
        return this._token;
    }

    public long getLineNumber() {
        return this._line_count;
    }

    public long getLineOffset() {
        long l = this._stream.getPosition();
        long l2 = l - this._line_starting_position;
        return l2;
    }

    UnifiedInputStreamX getSourceStream() {
        return this._stream;
    }

    public final boolean isBufferedInput() {
        boolean bl = !this._stream._is_stream;
        return bl;
    }

    protected String input_position() {
        String string = " at line " + this.getLineNumber() + " offset " + this.getLineOffset();
        return string;
    }

    public final boolean isUnfinishedToken() {
        return this._unfinished_token;
    }

    public final void tokenIsFinished() {
        this._unfinished_token = false;
        this._base64_prefetch_count = 0;
    }

    protected final int read_char() throws IOException {
        int n = this._stream.read();
        if (n == 13 || n == 10) {
            n = this.line_count(n);
        }
        return n;
    }

    protected final int read_string_char(ProhibitedCharacters prohibitedCharacters) throws IOException {
        int n = this._stream.read();
        if (prohibitedCharacters.includes(n)) {
            this.error("invalid character [" + IonTextUtils.printCodePointAsString(n) + "]");
        }
        if (n == 13 || n == 10 || n == 92) {
            n = this.line_count(n);
        }
        return n;
    }

    private final void unread_char(int n) {
        block11: {
            block10: {
                if (n >= 0) break block10;
                switch (n) {
                    case -4: {
                        this.line_count_unread(n);
                        this._stream.unread(10);
                        break block11;
                    }
                    case -5: {
                        this.line_count_unread(n);
                        this._stream.unread(13);
                        break block11;
                    }
                    case -6: {
                        this.line_count_unread(n);
                        this._stream.unread(10);
                        this._stream.unread(13);
                        break block11;
                    }
                    case -7: {
                        this._stream.unread(10);
                        this._stream.unread(92);
                        break block11;
                    }
                    case -8: {
                        this._stream.unread(13);
                        this._stream.unread(92);
                        break block11;
                    }
                    case -9: {
                        this._stream.unread(10);
                        this._stream.unread(13);
                        this._stream.unread(92);
                        break block11;
                    }
                    case -1: {
                        this._stream.unread(-1);
                        break block11;
                    }
                    default: {
                        assert (false) : "INVALID SPECIAL CHARACTER ENCOUNTERED: " + n;
                        break block11;
                    }
                }
            }
            this._stream.unread(n);
        }
    }

    private final int line_count_unread(int n) {
        assert (n == -4 || n == -5 || n == -6 || n == -7 || n == -8 || n == -9);
        if (this._line_count_has_cached) {
            this._line_count = this._line_count_cached;
            this._line_starting_position = this._line_offset_cached;
            this._line_count_has_cached = false;
        }
        return n;
    }

    private final int line_count(int n) throws IOException {
        block0 : switch (n) {
            case 92: {
                int n2 = this._stream.read();
                switch (n2) {
                    case 13: {
                        int n3 = this._stream.read();
                        if (n3 != 10) {
                            this.unread_char(n3);
                            n = -8;
                            break block0;
                        }
                        n = -9;
                        break block0;
                    }
                    case 10: {
                        n = -7;
                        break block0;
                    }
                }
                this.unread_char(n2);
                return n;
            }
            case 13: {
                int n4 = this._stream.read();
                if (n4 == 10) {
                    n = -6;
                    break;
                }
                this.unread_char(n4);
                n = -5;
                break;
            }
            case 10: {
                n = -4;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this._line_count_cached = this._line_count++;
        this._line_offset_cached = this._line_starting_position;
        this._line_count_has_cached = true;
        this._line_starting_position = this._stream.getPosition() - 1L;
        return n;
    }

    public final boolean skipDoubleColon() throws IOException {
        int n = this.skip_over_whitespace();
        if (n != 58) {
            this.unread_char(n);
            return false;
        }
        n = this.read_char();
        if (n != 58) {
            this.unread_char(n);
            this.unread_char(58);
            return false;
        }
        return true;
    }

    public final int peekNullTypeSymbol() throws IOException {
        int n;
        int n2 = this.read_char();
        if (n2 != 46) {
            this.unread_char(n2);
            return 0;
        }
        int[] nArray = new int[IonTokenConstsX.TN_MAX_NAME_LENGTH + 1];
        int n3 = 0;
        int n4 = 8191;
        while (n3 < IonTokenConstsX.TN_MAX_NAME_LENGTH + 1) {
            n2 = this.read_char();
            nArray[n3++] = n2;
            n = IonTokenConstsX.typeNameLetterIdx(n2);
            if (n < 1) {
                if (IonTokenConstsX.isValidTerminatingCharForInf(n2)) break;
                return this.peekNullTypeSymbolUndo(nArray, n3);
            }
            int n5 = IonTokenConstsX.typeNamePossibilityMask(n3 - 1, n);
            if ((n4 &= n5) != 0) continue;
            return this.peekNullTypeSymbolUndo(nArray, n3);
        }
        if ((n = IonTokenConstsX.typeNameKeyWordFromMask(n4, n3 - 1)) == -1) {
            this.peekNullTypeSymbolUndo(nArray, n3);
        } else {
            this.unread_char(n2);
        }
        return n;
    }

    private final int peekNullTypeSymbolUndo(int[] nArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + (char)nArray[i];
        }
        String string2 = "invalid type name on a typed null value";
        this.error(string2);
        return -1;
    }

    public final int peekLobStartPunctuation() throws IOException {
        int n = this.skip_over_lob_whitespace();
        if (n == 34) {
            return 12;
        }
        if (n != 39) {
            this.unread_char(n);
            return -1;
        }
        n = this.read_char();
        if (n != 39) {
            this.unread_char(n);
            this.unread_char(39);
            return -1;
        }
        n = this.read_char();
        if (n != 39) {
            this.unread_char(n);
            this.unread_char(39);
            this.unread_char(39);
            return -1;
        }
        return 13;
    }

    protected final void skip_clob_close_punctuation() throws IOException {
        int n = this.skip_over_clob_whitespace();
        if (n == 125) {
            n = this.read_char();
            if (n == 125) {
                return;
            }
            this.unread_char(n);
            n = 125;
        }
        this.unread_char(n);
        this.error("invalid closing puctuation for CLOB");
    }

    protected final void finish_token(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        if (this._unfinished_token) {
            int n = this.skip_to_end(savePoint);
            this.unread_char(n);
            this._unfinished_token = false;
        }
    }

    private final int skip_to_end(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n;
        switch (this._token) {
            case 1: {
                n = this.skip_over_number(savePoint);
                break;
            }
            case 2: {
                n = this.skip_over_int(savePoint);
                break;
            }
            case 3: {
                n = this.skipOverRadix(savePoint, Radix.HEX);
                break;
            }
            case 26: {
                n = this.skipOverRadix(savePoint, Radix.BINARY);
                break;
            }
            case 4: {
                n = this.skip_over_decimal(savePoint);
                break;
            }
            case 5: {
                n = this.skip_over_float(savePoint);
                break;
            }
            case 8: {
                n = this.skip_over_timestamp(savePoint);
                break;
            }
            case 9: {
                n = this.skip_over_symbol_identifier(savePoint);
                break;
            }
            case 10: {
                assert (!this.is_2_single_quotes_helper());
                n = this.skip_single_quoted_string(savePoint);
                break;
            }
            case 11: {
                n = this.skip_over_symbol_operator(savePoint);
                break;
            }
            case 12: {
                this.skip_double_quoted_string_helper();
                n = this.skip_over_whitespace();
                break;
            }
            case 13: {
                this.skip_triple_quoted_string(savePoint);
                n = this.skip_over_whitespace();
                break;
            }
            case 24: {
                this.skip_over_blob(savePoint);
                n = this.read_char();
                break;
            }
            case 20: {
                assert (savePoint == null);
                this.skip_over_struct();
                n = this.read_char();
                break;
            }
            case 18: {
                this.skip_over_sexp();
                n = this.read_char();
                break;
            }
            case 22: {
                this.skip_over_list();
                n = this.read_char();
                break;
            }
            default: {
                n = -1;
                this.error("token " + IonTokenConstsX.getTokenName(this._token) + " unexpectedly encounterd as \"unfinished\"");
            }
        }
        if (IonTokenConstsX.isWhitespace(n)) {
            n = this.skip_over_whitespace();
        }
        this._unfinished_token = false;
        return n;
    }

    public final long getStartingOffset() throws IOException {
        int n = this._unfinished_token ? this.skip_to_end(null) : this.skip_over_whitespace();
        this.unread_char(n);
        long l = this._stream.getPosition();
        return l;
    }

    public final int nextToken() throws IOException {
        int n = -1;
        int n2 = this._unfinished_token ? this.skip_to_end(null) : this.skip_over_whitespace();
        this._unfinished_token = true;
        switch (n2) {
            case -1: {
                return this.next_token_finish(0, true);
            }
            case 47: {
                this.unread_char(n2);
                return this.next_token_finish(11, true);
            }
            case 58: {
                int n3 = this.read_char();
                if (n3 != 58) {
                    this.unread_char(n3);
                    return this.next_token_finish(16, true);
                }
                return this.next_token_finish(17, true);
            }
            case 123: {
                int n4 = this.read_char();
                if (n4 != 123) {
                    this.unread_char(n4);
                    return this.next_token_finish(20, true);
                }
                return this.next_token_finish(24, true);
            }
            case 125: {
                return this.next_token_finish(21, false);
            }
            case 91: {
                return this.next_token_finish(22, true);
            }
            case 93: {
                return this.next_token_finish(23, false);
            }
            case 40: {
                return this.next_token_finish(18, true);
            }
            case 41: {
                return this.next_token_finish(19, false);
            }
            case 44: {
                return this.next_token_finish(15, false);
            }
            case 46: {
                int n5 = this.read_char();
                this.unread_char(n5);
                if (IonTokenConstsX.isValidExtendedSymbolCharacter(n5)) {
                    this.unread_char(46);
                    return this.next_token_finish(11, true);
                }
                return this.next_token_finish(14, false);
            }
            case 39: {
                if (this.is_2_single_quotes_helper()) {
                    return this.next_token_finish(13, true);
                }
                return this.next_token_finish(10, true);
            }
            case 43: {
                if (this.peek_inf_helper(n2)) {
                    return this.next_token_finish(6, false);
                }
                this.unread_char(n2);
                return this.next_token_finish(11, true);
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 94: 
            case 96: 
            case 124: 
            case 126: {
                this.unread_char(n2);
                return this.next_token_finish(11, true);
            }
            case 34: {
                return this.next_token_finish(12, true);
            }
            case 36: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                this.unread_char(n2);
                return this.next_token_finish(9, true);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n = this.scan_for_numeric_type(n2);
                this.unread_char(n2);
                return this.next_token_finish(n, true);
            }
            case 45: {
                int n6 = this.read_char();
                this.unread_char(n6);
                if (IonTokenConstsX.isDigit(n6)) {
                    n = this.scan_negative_for_numeric_type(n2);
                    this.unread_char(n2);
                    return this.next_token_finish(n, true);
                }
                if (this.peek_inf_helper(n2)) {
                    return this.next_token_finish(7, false);
                }
                this.unread_char(n2);
                return this.next_token_finish(11, true);
            }
        }
        this.bad_token_start(n2);
        throw new IonException("invalid state: next token switch shouldn't exit");
    }

    private final int next_token_finish(int n, boolean bl) {
        this._token = n;
        this._unfinished_token = bl;
        return this._token;
    }

    private final int skip_over_whitespace() throws IOException {
        return this.skip_over_whitespace(CommentStrategy.IGNORE);
    }

    private final int skip_over_whitespace(CommentStrategy commentStrategy) throws IOException {
        this.skip_whitespace(commentStrategy);
        return this.read_char();
    }

    private final int skip_over_lob_whitespace() throws IOException {
        return this.skip_over_blob_whitespace();
    }

    private final int skip_over_blob_whitespace() throws IOException {
        return this.skip_over_whitespace(CommentStrategy.BREAK);
    }

    private final int skip_over_clob_whitespace() throws IOException {
        return this.skip_over_whitespace(CommentStrategy.ERROR);
    }

    protected final boolean skip_whitespace() throws IOException {
        return this.skip_whitespace(CommentStrategy.IGNORE);
    }

    private final boolean skip_whitespace(CommentStrategy commentStrategy) throws IOException {
        int n;
        boolean bl = false;
        block5: while (true) {
            n = this.read_char();
            switch (n) {
                case -1: {
                    break block5;
                }
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case 9: 
                case 32: {
                    bl = true;
                    continue block5;
                }
                case 47: {
                    if (!commentStrategy.onComment(this)) break block5;
                    bl = true;
                    continue block5;
                }
            }
            break;
        }
        this.unread_char(n);
        return bl;
    }

    private final void skip_single_line_comment() throws IOException {
        while (true) {
            int n = this.read_char();
            switch (n) {
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: {
                    return;
                }
                case -1: {
                    return;
                }
            }
        }
    }

    private final void skip_block_comment() throws IOException {
        while (true) {
            int n = this.read_char();
            switch (n) {
                case 42: {
                    do {
                        if ((n = this.read_char()) != 47) continue;
                        return;
                    } while (n == 42);
                    break;
                }
                case -1: {
                    this.bad_token_start(n);
                }
            }
        }
    }

    private final boolean is_2_single_quotes_helper() throws IOException {
        int n = this.read_char();
        if (n != 39) {
            this.unread_char(n);
            return false;
        }
        n = this.read_char();
        if (n != 39) {
            this.unread_char(n);
            this.unread_char(39);
            return false;
        }
        return true;
    }

    private final boolean peek_inf_helper(int n) throws IOException {
        if (n != 43 && n != 45) {
            return false;
        }
        n = this.read_char();
        if (n == 105) {
            n = this.read_char();
            if (n == 110) {
                n = this.read_char();
                if (n == 102) {
                    n = this.read_char();
                    if (this.is_value_terminating_character(n)) {
                        this.unread_char(n);
                        return true;
                    }
                    this.unread_char(n);
                    n = 102;
                }
                this.unread_char(n);
                n = 110;
            }
            this.unread_char(n);
            n = 105;
        }
        this.unread_char(n);
        return false;
    }

    private final int scan_for_numeric_type(int n) throws IOException {
        int n2 = 1;
        int[] nArray = new int[6];
        int n3 = 0;
        if (!IonTokenConstsX.isDigit(n)) {
            this.error(String.format("Expected digit, got U+%04X", n));
        }
        int n4 = this.read_char();
        nArray[n3++] = n4;
        if (n == 48) {
            switch (n4) {
                case 88: 
                case 120: {
                    n2 = 3;
                    break;
                }
                case 68: 
                case 100: {
                    n2 = 4;
                    break;
                }
                case 69: 
                case 101: {
                    n2 = 5;
                    break;
                }
                case 66: 
                case 98: {
                    n2 = 26;
                    break;
                }
                case 46: {
                    break;
                }
                default: {
                    if (!this.is_value_terminating_character(n4)) break;
                    n2 = 2;
                }
            }
        }
        if (n2 == 1 && IonTokenConstsX.isDigit(n4)) {
            n4 = this.read_char();
            nArray[n3++] = n4;
            if (IonTokenConstsX.isDigit(n4)) {
                n4 = this.read_char();
                nArray[n3++] = n4;
                if (IonTokenConstsX.isDigit(n4)) {
                    n4 = this.read_char();
                    nArray[n3++] = n4;
                    if (n4 == 45 || n4 == 84) {
                        n2 = 8;
                    }
                }
            }
        }
        do {
            n4 = nArray[--n3];
            this.unread_char(n4);
        } while (n3 > 0);
        return n2;
    }

    private final boolean is_value_terminating_character(int n) throws IOException {
        boolean bl;
        switch (n) {
            case 47: {
                n = this.read_char();
                this.unread_char(n);
                bl = n == 47 || n == 42;
                break;
            }
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                bl = true;
                break;
            }
            default: {
                bl = IonTextUtils.isNumericStop(n);
            }
        }
        return bl;
    }

    private final int scan_negative_for_numeric_type(int n) throws IOException {
        assert (n == 45);
        n = this.read_char();
        int n2 = this.scan_for_numeric_type(n);
        if (n2 == 8) {
            this.bad_token(n);
        }
        this.unread_char(n);
        return n2;
    }

    protected void load_raw_characters(StringBuilder stringBuilder) throws IOException {
        int n = this.read_char();
        block4: while (true) {
            n = this.read_char();
            switch (n) {
                case -9: 
                case -8: 
                case -7: {
                    continue block4;
                }
                case -1: {
                    return;
                }
            }
            if (!IonTokenConstsX.is7bitValue(n)) {
                n = this.read_large_char_sequence(n);
            }
            if (IonUTF8.needsSurrogateEncoding(n)) {
                stringBuilder.append(IonUTF8.highSurrogate(n));
                n = IonUTF8.lowSurrogate(n);
            }
            stringBuilder.append((char)n);
        }
    }

    protected void skip_over_struct() throws IOException {
        this.skip_over_container(125);
    }

    protected void skip_over_list() throws IOException {
        this.skip_over_container(93);
    }

    protected void skip_over_sexp() throws IOException {
        this.skip_over_container(41);
    }

    private void skip_over_container(int n) throws IOException {
        assert (n == 125 || n == 93 || n == 41);
        block9: while (true) {
            int n2 = this.skip_over_whitespace();
            switch (n2) {
                case -1: {
                    this.unexpected_eof();
                }
                case 41: 
                case 93: 
                case 125: {
                    if (n2 != n) continue block9;
                    return;
                }
                case 34: {
                    this.skip_double_quoted_string_helper();
                    continue block9;
                }
                case 39: {
                    if (this.is_2_single_quotes_helper()) {
                        this.skip_triple_quoted_string(null);
                        continue block9;
                    }
                    n2 = this.skip_single_quoted_string(null);
                    this.unread_char(n2);
                    continue block9;
                }
                case 40: {
                    this.skip_over_container(41);
                    continue block9;
                }
                case 91: {
                    this.skip_over_container(93);
                    continue block9;
                }
                case 123: {
                    n2 = this.read_char();
                    if (n2 == 123) {
                        int n3;
                        n2 = this.skip_over_lob_whitespace();
                        if (n2 == 34) {
                            n3 = 12;
                        } else if (n2 == 39) {
                            if (!this.is_2_single_quotes_helper()) {
                                this.error("invalid single quote in lob content");
                            }
                            n3 = 13;
                        } else {
                            this.unread_char(n2);
                            n3 = 24;
                        }
                        this.skip_over_lob(n3, null);
                        continue block9;
                    }
                    if (n2 == 125) continue block9;
                    this.unread_char(n2);
                    this.skip_over_container(125);
                    continue block9;
                }
            }
        }
    }

    private int skip_over_number(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.read_char();
        if (n == 45) {
            n = this.read_char();
        }
        if ((n = this.skip_over_digits(n)) == 46) {
            n = this.read_char();
            n = this.skip_over_digits(n);
        }
        if (n == 100 || n == 68 || n == 101 || n == 69) {
            n = this.read_char();
            if (n == 45 || n == 43) {
                n = this.read_char();
            }
            n = this.skip_over_digits(n);
        }
        if (!this.is_value_terminating_character(n)) {
            this.bad_token(n);
        }
        if (savePoint != null) {
            savePoint.markEnd(-1);
        }
        return n;
    }

    private int skip_over_int(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.read_char();
        if (n == 45) {
            n = this.read_char();
        }
        if (!this.is_value_terminating_character(n = this.skip_over_digits(n))) {
            this.bad_token(n);
        }
        if (savePoint != null) {
            savePoint.markEnd(-1);
        }
        return n;
    }

    private int skip_over_digits(int n) throws IOException {
        while (IonTokenConstsX.isDigit(n)) {
            n = this.read_char();
        }
        return n;
    }

    private int skipOverRadix(UnifiedSavePointManagerX.SavePoint savePoint, Radix radix) throws IOException {
        int n = this.read_char();
        if (n == 45) {
            n = this.read_char();
        }
        assert (n == 48);
        n = this.read_char();
        radix.assertPrefix(n);
        n = this.readNumeric(NULL_APPENDABLE, radix);
        if (!this.is_value_terminating_character(n)) {
            this.bad_token(n);
        }
        if (savePoint != null) {
            savePoint.markEnd(-1);
        }
        return n;
    }

    private int skip_over_decimal(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.skip_over_number(savePoint);
        return n;
    }

    private int skip_over_float(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.skip_over_number(savePoint);
        return n;
    }

    private int skip_over_timestamp(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.skip_timestamp_past_digits(4);
        if (n == 84) {
            if (savePoint != null) {
                savePoint.markEnd(0);
            }
            return this.skip_over_whitespace();
        }
        if (n != 45) {
            this.error("invalid timestamp encountered");
        }
        if ((n = this.skip_timestamp_past_digits(2)) == 84) {
            if (savePoint != null) {
                savePoint.markEnd(0);
            }
            return this.skip_over_whitespace();
        }
        this.skip_timestamp_validate(n, 45);
        n = this.skip_timestamp_past_digits(2);
        if (n != 84) {
            return this.skip_timestamp_finish(n, savePoint);
        }
        n = this.read_char();
        if (!IonTokenConstsX.isDigit(n)) {
            return this.skip_timestamp_finish(this.skip_optional_timestamp_offset(n), savePoint);
        }
        n = this.skip_timestamp_past_digits(1);
        if (n != 58) {
            this.bad_token(n);
        }
        if ((n = this.skip_timestamp_past_digits(2)) != 58) {
            return this.skip_timestamp_offset_or_z(n, savePoint);
        }
        n = this.skip_timestamp_past_digits(2);
        if (n != 46) {
            return this.skip_timestamp_offset_or_z(n, savePoint);
        }
        n = this.read_char();
        if (IonTokenConstsX.isDigit(n)) {
            n = this.skip_over_digits(n);
        }
        return this.skip_timestamp_offset_or_z(n, savePoint);
    }

    private int skip_timestamp_finish(int n, UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        if (!this.is_value_terminating_character(n)) {
            this.bad_token(n);
        }
        if (savePoint != null) {
            savePoint.markEnd(-1);
        }
        return n;
    }

    private int skip_optional_timestamp_offset(int n) throws IOException {
        if (n == 45 || n == 43) {
            n = this.skip_timestamp_past_digits(2);
            if (n != 58) {
                this.bad_token(n);
            }
            n = this.skip_timestamp_past_digits(2);
        }
        return n;
    }

    private int skip_timestamp_offset_or_z(int n, UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        if (n == 45 || n == 43) {
            n = this.skip_timestamp_past_digits(2);
            if (n != 58) {
                this.bad_token(n);
            }
            n = this.skip_timestamp_past_digits(2);
        } else if (n == 90 || n == 122) {
            n = this.read_char();
        } else {
            this.bad_token(n);
        }
        return this.skip_timestamp_finish(n, savePoint);
    }

    private final void skip_timestamp_validate(int n, int n2) {
        if (n != n2) {
            this.error("invalid character '" + (char)n + "' encountered in timestamp (when '" + (char)n2 + "' was expected");
        }
    }

    private final int skip_timestamp_past_digits(int n) throws IOException {
        return this.skip_timestamp_past_digits(n, n);
    }

    private final int skip_timestamp_past_digits(int n, int n2) throws IOException {
        int n3;
        while (n > 0) {
            n3 = this.read_char();
            if (!IonTokenConstsX.isDigit(n3)) {
                this.error("invalid character '" + (char)n3 + "' encountered in timestamp");
            }
            --n;
            --n2;
        }
        while (n2 > 0) {
            n3 = this.read_char();
            if (!IonTokenConstsX.isDigit(n3)) {
                return n3;
            }
            --n2;
        }
        return this.read_char();
    }

    protected IonType load_number(StringBuilder stringBuilder) throws IOException {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = false;
        int n3 = this.read_char();
        boolean bl3 = bl2 = n3 == 45 || n3 == 43;
        if (bl2) {
            stringBuilder.append((char)n3);
            n3 = this.read_char();
        }
        if (!IonTokenConstsX.isDigit(n3)) {
            this.bad_token(n3);
        }
        boolean bl4 = bl = n3 == 48;
        if (bl) {
            n2 = this.read_char();
            if (Radix.HEX.isPrefix(n2)) {
                stringBuilder.append((char)n3);
                n3 = this.loadRadixValue(stringBuilder, bl2, n2, Radix.HEX);
                return this.load_finish_number(stringBuilder, n3, 3);
            }
            if (Radix.BINARY.isPrefix(n2)) {
                stringBuilder.append((char)n3);
                n3 = this.loadRadixValue(stringBuilder, bl2, n2, Radix.BINARY);
                return this.load_finish_number(stringBuilder, n3, 26);
            }
            this.unread_char(n2);
        }
        if ((n3 = this.load_digits(stringBuilder, n3)) == 45 || n3 == 84) {
            if (bl2) {
                this.error("Numeric value followed by invalid character: " + stringBuilder + (char)n3);
            }
            if ((n2 = stringBuilder.length()) != 4) {
                this.error("Numeric value followed by invalid character: " + stringBuilder + (char)n3);
            }
            IonType ionType = this.load_timestamp(stringBuilder, n3);
            return ionType;
        }
        if (bl) {
            n2 = stringBuilder.length();
            if (bl2) {
                --n2;
            }
            if (n2 != 1) {
                this.error("Invalid leading zero in number: " + stringBuilder);
            }
        }
        if (n3 == 46) {
            stringBuilder.append((char)n3);
            n3 = this.read_char();
            n3 = this.load_digits(stringBuilder, n3);
            n = 4;
        } else {
            n = 2;
        }
        if (n3 == 101 || n3 == 69) {
            n = 5;
            stringBuilder.append((char)n3);
            n3 = this.load_exponent(stringBuilder);
        } else if (n3 == 100 || n3 == 68) {
            n = 4;
            stringBuilder.append((char)n3);
            n3 = this.load_exponent(stringBuilder);
        }
        return this.load_finish_number(stringBuilder, n3, n);
    }

    private final IonType load_finish_number(CharSequence charSequence, int n, int n2) throws IOException {
        if (!this.is_value_terminating_character(n)) {
            this.error("Numeric value followed by invalid character: " + charSequence + (char)n);
        }
        this.unread_char(n);
        IonType ionType = IonTokenConstsX.ion_type_of_scalar(n2);
        return ionType;
    }

    private final int load_exponent(StringBuilder stringBuilder) throws IOException {
        int n = this.read_char();
        if (n == 45 || n == 43) {
            stringBuilder.append((char)n);
            n = this.read_char();
        }
        if ((n = this.load_digits(stringBuilder, n)) == 46) {
            stringBuilder.append((char)n);
            n = this.read_char();
            n = this.load_digits(stringBuilder, n);
        }
        return n;
    }

    private final int load_digits(StringBuilder stringBuilder, int n) throws IOException {
        if (!IonTokenConstsX.isDigit(n)) {
            return n;
        }
        stringBuilder.append((char)n);
        return this.readNumeric(stringBuilder, Radix.DECIMAL, NumericState.DIGIT);
    }

    private final void load_fixed_digits(StringBuilder stringBuilder, int n) throws IOException {
        int n2;
        switch (n) {
            default: {
                while (n > 4) {
                    n2 = this.read_char();
                    if (!IonTokenConstsX.isDigit(n2)) {
                        this.bad_token(n2);
                    }
                    stringBuilder.append((char)n2);
                    --n;
                }
            }
            case 4: {
                n2 = this.read_char();
                if (!IonTokenConstsX.isDigit(n2)) {
                    this.bad_token(n2);
                }
                stringBuilder.append((char)n2);
            }
            case 3: {
                n2 = this.read_char();
                if (!IonTokenConstsX.isDigit(n2)) {
                    this.bad_token(n2);
                }
                stringBuilder.append((char)n2);
            }
            case 2: {
                n2 = this.read_char();
                if (!IonTokenConstsX.isDigit(n2)) {
                    this.bad_token(n2);
                }
                stringBuilder.append((char)n2);
            }
            case 1: 
        }
        n2 = this.read_char();
        if (!IonTokenConstsX.isDigit(n2)) {
            this.bad_token(n2);
        }
        stringBuilder.append((char)n2);
    }

    private final IonType load_timestamp(StringBuilder stringBuilder, int n) throws IOException {
        assert (n == 45 || n == 84);
        stringBuilder.append((char)n);
        if (n == 84) {
            n = this.read_char();
            return this.load_finish_number(stringBuilder, n, 8);
        }
        this.load_fixed_digits(stringBuilder, 2);
        n = this.read_char();
        if (n == 84) {
            stringBuilder.append((char)n);
            n = this.read_char();
            return this.load_finish_number(stringBuilder, n, 8);
        }
        if (n != 45) {
            this.bad_token(n);
        }
        stringBuilder.append((char)n);
        this.load_fixed_digits(stringBuilder, 2);
        n = this.read_char();
        if (n != 84) {
            return this.load_finish_number(stringBuilder, n, 8);
        }
        stringBuilder.append((char)n);
        n = this.read_char();
        if (!IonTokenConstsX.isDigit(n)) {
            return this.load_finish_number(stringBuilder, n, 8);
        }
        stringBuilder.append((char)n);
        this.load_fixed_digits(stringBuilder, 1);
        n = this.read_char();
        if (n != 58) {
            this.bad_token(n);
        }
        stringBuilder.append((char)n);
        this.load_fixed_digits(stringBuilder, 2);
        n = this.read_char();
        if (n == 58) {
            stringBuilder.append((char)n);
            this.load_fixed_digits(stringBuilder, 2);
            n = this.read_char();
            if (n == 46) {
                stringBuilder.append((char)n);
                n = this.read_char();
                if (!IonTokenConstsX.isDigit(n)) {
                    this.expected_but_found("at least one digit after timestamp's decimal point", n);
                }
                n = this.load_digits(stringBuilder, n);
            }
        }
        if (n == 122 || n == 90) {
            stringBuilder.append((char)n);
            n = this.read_char();
        } else if (n == 43 || n == 45) {
            stringBuilder.append((char)n);
            this.load_fixed_digits(stringBuilder, 2);
            n = this.read_char();
            if (n != 58) {
                this.bad_token(n);
            }
            stringBuilder.append((char)n);
            this.load_fixed_digits(stringBuilder, 2);
            n = this.read_char();
        } else {
            this.bad_token(n);
        }
        return this.load_finish_number(stringBuilder, n, 8);
    }

    private final int loadRadixValue(StringBuilder stringBuilder, boolean bl, int n, Radix radix) throws IOException {
        radix.assertPrefix(n);
        stringBuilder.append((char)n);
        return this.readNumeric(stringBuilder, radix);
    }

    private final int skip_over_symbol_identifier(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.read_char();
        while (IonTokenConstsX.isValidSymbolCharacter(n)) {
            n = this.read_char();
        }
        if (savePoint != null) {
            savePoint.markEnd(0);
        }
        return n;
    }

    protected void load_symbol_identifier(StringBuilder stringBuilder) throws IOException {
        int n = this.read_char();
        while (IonTokenConstsX.isValidSymbolCharacter(n)) {
            stringBuilder.append((char)n);
            n = this.read_char();
        }
        this.unread_char(n);
    }

    private int skip_over_symbol_operator(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.read_char();
        if (this.peek_inf_helper(n)) {
            n = this.read_char();
        } else {
            assert (IonTokenConstsX.isValidExtendedSymbolCharacter(n));
            while (IonTokenConstsX.isValidExtendedSymbolCharacter(n)) {
                n = this.read_char();
            }
        }
        if (savePoint != null) {
            savePoint.markEnd(0);
        }
        return n;
    }

    protected void load_symbol_operator(StringBuilder stringBuilder) throws IOException {
        int n = this.read_char();
        if ((n == 43 || n == 45) && this.peek_inf_helper(n)) {
            stringBuilder.append((char)n);
            stringBuilder.append("inf");
        } else {
            assert (IonTokenConstsX.isValidExtendedSymbolCharacter(n));
            while (IonTokenConstsX.isValidExtendedSymbolCharacter(n)) {
                stringBuilder.append((char)n);
                n = this.read_char();
            }
            this.unread_char(n);
        }
    }

    private final int skip_single_quoted_string(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        while (true) {
            int n = this.read_string_char(ProhibitedCharacters.NONE);
            switch (n) {
                case -1: {
                    this.unexpected_eof();
                }
                case 39: {
                    if (savePoint != null) {
                        savePoint.markEnd(-1);
                    }
                    return this.read_char();
                }
                case 92: {
                    n = this.read_char();
                }
            }
        }
    }

    protected int load_single_quoted_string(StringBuilder stringBuilder, boolean bl) throws IOException {
        block6: while (true) {
            int n = this.read_string_char(ProhibitedCharacters.NONE);
            switch (n) {
                case -9: 
                case -8: 
                case -7: {
                    continue block6;
                }
                case -1: 
                case 39: {
                    return n;
                }
                case -6: 
                case -5: 
                case -4: {
                    this.bad_token(n);
                }
                case 92: {
                    n = this.read_char();
                    n = this.read_escaped_char_content_helper(n, bl);
                    break;
                }
                default: {
                    if (bl || IonTokenConstsX.is7bitValue(n)) break;
                    n = this.read_large_char_sequence(n);
                }
            }
            if (!bl) {
                if (IonUTF8.needsSurrogateEncoding(n)) {
                    stringBuilder.append(IonUTF8.highSurrogate(n));
                    n = IonUTF8.lowSurrogate(n);
                }
            } else if (IonTokenConstsX.is8bitValue(n)) {
                this.bad_token(n);
            }
            stringBuilder.append((char)n);
        }
    }

    private void skip_double_quoted_string(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        this.skip_double_quoted_string_helper();
        if (savePoint != null) {
            savePoint.markEnd(-1);
        }
    }

    private final void skip_double_quoted_string_helper() throws IOException {
        while (true) {
            int n = this.read_string_char(ProhibitedCharacters.NONE);
            switch (n) {
                case -1: {
                    this.unexpected_eof();
                }
                case -6: 
                case -5: 
                case -4: {
                    this.bad_token(n);
                }
                case 34: {
                    return;
                }
                case 92: {
                    n = this.read_char();
                }
            }
        }
    }

    protected int load_double_quoted_string(StringBuilder stringBuilder, boolean bl) throws IOException {
        block6: while (true) {
            int n = this.read_string_char(ProhibitedCharacters.SHORT_CHAR);
            switch (n) {
                case -9: 
                case -8: 
                case -7: {
                    continue block6;
                }
                case -1: 
                case 34: {
                    return n;
                }
                case -6: 
                case -5: 
                case -4: {
                    this.bad_token(n);
                }
                case 92: {
                    n = this.read_char_escaped(n, bl);
                    break;
                }
                default: {
                    if (bl || IonTokenConstsX.is7bitValue(n)) break;
                    n = this.read_large_char_sequence(n);
                }
            }
            if (!bl && IonUTF8.needsSurrogateEncoding(n)) {
                stringBuilder.append(IonUTF8.highSurrogate(n));
                n = IonUTF8.lowSurrogate(n);
            }
            stringBuilder.append((char)n);
        }
    }

    protected int read_double_quoted_char(boolean bl) throws IOException {
        int n = this.read_char();
        switch (n) {
            case 34: {
                this.unread_char(n);
                n = -2;
                break;
            }
            case -1: {
                break;
            }
            case 92: {
                n = this.read_char_escaped(n, bl);
                break;
            }
            default: {
                if (bl || IonTokenConstsX.is7bitValue(n)) break;
                n = this.read_large_char_sequence(n);
            }
        }
        return n;
    }

    private void skip_triple_quoted_string(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        this.skip_triple_quoted_string(savePoint, CommentStrategy.IGNORE);
    }

    private void skip_triple_quoted_clob_string(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        this.skip_triple_quoted_string(savePoint, CommentStrategy.ERROR);
    }

    private void skip_triple_quoted_string(UnifiedSavePointManagerX.SavePoint savePoint, CommentStrategy commentStrategy) throws IOException {
        block5: while (true) {
            int n = this.read_char();
            switch (n) {
                case -1: {
                    this.unexpected_eof();
                }
                case 39: {
                    n = this.read_char();
                    if (n != 39) break;
                    n = this.read_char();
                    if (savePoint != null) {
                        savePoint.markEnd(-3);
                    }
                    if (n != 39 || (n = this.skip_over_whitespace(commentStrategy)) == 39 && this.is_2_single_quotes_helper()) continue block5;
                    this.unread_char(n);
                    return;
                }
                case 92: {
                    n = this.read_char();
                }
            }
        }
    }

    protected int load_triple_quoted_string(StringBuilder stringBuilder, boolean bl) throws IOException {
        block7: while (true) {
            int n = this.read_triple_quoted_char(bl);
            switch (n) {
                case -2: 
                case -1: {
                    return n;
                }
                case -4: {
                    n = 10;
                    break;
                }
                case -5: {
                    n = 10;
                    break;
                }
                case -6: {
                    n = 10;
                    break;
                }
                case -9: 
                case -8: 
                case -7: 
                case -3: {
                    continue block7;
                }
            }
            if (!bl && IonUTF8.needsSurrogateEncoding(n)) {
                stringBuilder.append(IonUTF8.highSurrogate(n));
                n = IonUTF8.lowSurrogate(n);
            }
            stringBuilder.append((char)n);
        }
    }

    protected int read_triple_quoted_char(boolean bl) throws IOException {
        int n = this.read_string_char(ProhibitedCharacters.LONG_CHAR);
        switch (n) {
            case 39: {
                if (!this.is_2_single_quotes_helper()) break;
                n = this.skip_over_whitespace();
                if (n == 39 && this.is_2_single_quotes_helper()) {
                    return -3;
                }
                this.unread_char(n);
                n = -2;
                break;
            }
            case 92: {
                n = this.read_char_escaped(n, bl);
                break;
            }
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (bl || IonTokenConstsX.is7bitValue(n)) break;
                n = this.read_large_char_sequence(n);
            }
        }
        return n;
    }

    protected void skip_over_lob(int n, UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        switch (n) {
            case 12: {
                this.skip_double_quoted_string(savePoint);
                this.skip_clob_close_punctuation();
                break;
            }
            case 13: {
                this.skip_triple_quoted_clob_string(savePoint);
                this.skip_clob_close_punctuation();
                break;
            }
            case 24: {
                this.skip_over_blob(savePoint);
                break;
            }
            default: {
                this.error("unexpected token " + IonTokenConstsX.getTokenName(n) + " encountered for lob content");
            }
        }
    }

    protected void load_clob(int n, StringBuilder stringBuilder) throws IOException {
        switch (n) {
            case 12: {
                this.load_double_quoted_string(stringBuilder, true);
                break;
            }
            case 13: {
                this.load_triple_quoted_string(stringBuilder, true);
                break;
            }
            case 24: {
                this.load_blob(stringBuilder);
                break;
            }
            default: {
                this.error("unexpected token " + IonTokenConstsX.getTokenName(n) + " encountered for lob content");
            }
        }
    }

    private final int read_char_escaped(int n, boolean bl) throws IOException {
        block4: while (true) {
            switch (n) {
                case -9: 
                case -8: 
                case -7: {
                    n = this.read_string_char(ProhibitedCharacters.NONE);
                    continue block4;
                }
                case 92: {
                    n = this.read_char();
                    if (n < 0) {
                        this.unexpected_eof();
                    }
                    if ((n = this.read_escaped_char_content_helper(n, bl)) == -7 || n == -8 || n == -9) {
                        n = this.read_string_char(ProhibitedCharacters.NONE);
                        continue block4;
                    }
                    if (n != -11) break block4;
                    this.bad_escape_sequence();
                    break block4;
                }
                default: {
                    if (bl || IonTokenConstsX.is7bitValue(n)) break block4;
                    n = this.read_large_char_sequence(n);
                    break block4;
                }
            }
            break;
        }
        if (n == -1) {
            return n;
        }
        if (bl && !IonTokenConstsX.is8bitValue(n)) {
            this.error("invalid character [" + IonTextUtils.printCodePointAsString(n) + "] in CLOB");
        }
        return n;
    }

    private final int read_large_char_sequence(int n) throws IOException {
        if (this._stream._is_byte_data) {
            return this.read_ut8_sequence(n);
        }
        if (PrivateIonConstants.isHighSurrogate(n)) {
            int n2 = this.read_char();
            if (PrivateIonConstants.isLowSurrogate(n2)) {
                n = PrivateIonConstants.makeUnicodeScalar(n, n2);
            } else {
                this.unread_char(n2);
            }
        }
        return n;
    }

    private final int read_ut8_sequence(int n) throws IOException {
        assert (!IonTokenConstsX.is7bitValue(n));
        int n2 = IonUTF8.getUTF8LengthFromFirstByte(n);
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                int n3 = this.read_char();
                n = IonUTF8.twoByteScalar(n, n3);
                break;
            }
            case 3: {
                int n4 = this.read_char();
                int n5 = this.read_char();
                n = IonUTF8.threeByteScalar(n, n4, n5);
                break;
            }
            case 4: {
                int n6 = this.read_char();
                int n7 = this.read_char();
                int n8 = this.read_char();
                n = IonUTF8.fourByteScalar(n, n6, n7, n8);
                break;
            }
            default: {
                this.error("invalid UTF8 starting byte");
            }
        }
        return n;
    }

    private void skip_over_blob(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        int n = this.skip_over_blob_whitespace();
        while (n != -1 && n != 125) {
            n = this.skip_over_blob_whitespace();
        }
        if (savePoint != null) {
            int n2 = n == 125 ? -1 : 0;
            savePoint.markEnd(n2);
        }
        if (n != 125) {
            this.unexpected_eof();
        }
        if ((n = this.read_char()) < 0) {
            this.unexpected_eof();
        }
        if (n != 125) {
            String string = "improperly closed BLOB, " + IonTextUtils.printCodePointAsString(n) + " encountered when '}' was expected";
            this.error(string);
        }
        if (savePoint != null) {
            savePoint.markEnd();
        }
    }

    protected void load_blob(StringBuilder stringBuilder) throws IOException {
        int n;
        while ((n = this.read_base64_byte()) != -1) {
            stringBuilder.append(n);
        }
        if (this._stream.isEOF()) {
            this.unexpected_eof();
        }
        if ((n = this.read_char()) < 0) {
            this.unexpected_eof();
        }
        if (n != 125) {
            String string = "improperly closed BLOB, " + IonTextUtils.printCodePointAsString(n) + " encountered when '}' was expected";
            this.error(string);
        }
    }

    private final int read_escaped_char_content_helper(int n, boolean bl) throws IOException {
        if (n < 0) {
            switch (n) {
                case -4: {
                    return -7;
                }
                case -5: {
                    return -8;
                }
                case -6: {
                    return -9;
                }
            }
            this.bad_escape_sequence(n);
        }
        if (!IonTokenConstsX.isValidEscapeStart(n)) {
            this.bad_escape_sequence(n);
        }
        int n2 = IonTokenConstsX.escapeReplacementCharacter(n);
        switch (n2) {
            case -11: {
                assert (false) : "invalid escape start characters (line " + (char)n + " should have been removed by isValid";
                break;
            }
            case -14: {
                if (bl) {
                    this.bad_escape_sequence(n2);
                }
                n2 = this.read_hex_escape_sequence_value(4);
                break;
            }
            case -15: {
                if (bl) {
                    this.bad_escape_sequence(n2);
                }
                n2 = this.read_hex_escape_sequence_value(8);
                break;
            }
            case -16: {
                n2 = this.read_hex_escape_sequence_value(2);
            }
        }
        return n2;
    }

    private final int read_hex_escape_sequence_value(int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3;
            --n;
            int n4 = this.read_char();
            if (n4 < 0) {
                this.unexpected_eof();
            }
            if ((n3 = IonTokenConstsX.hexDigitValue(n4)) < 0) {
                return -1;
            }
            n2 = (n2 << 4) + n3;
        }
        if (n > 0) {
            String string = "invalid hex digit [" + IonTextUtils.printCodePointAsString(n2) + "] in escape sequence";
            this.error(string);
        }
        return n2;
    }

    public final int read_base64_byte() throws IOException {
        int n;
        if (this._base64_prefetch_count < 1) {
            n = this.read_base64_byte_helper();
        } else {
            n = this._base64_prefetch_stack & 0xFF;
            this._base64_prefetch_stack >>= 8;
            --this._base64_prefetch_count;
        }
        return n;
    }

    private final int read_base64_byte_helper() throws IOException {
        int n = this.skip_over_blob_whitespace();
        if (n == -1 || n == 125) {
            return -1;
        }
        int n2 = this.read_base64_getchar_helper(n);
        int n3 = this.read_base64_getchar_helper();
        int n4 = this.read_base64_getchar_helper();
        int n5 = this.read_base64_getchar_helper();
        int n6 = IonReaderTextRawTokensX.decode_base64_length(n2, n3, n4, n5);
        this._base64_prefetch_stack = 0;
        this._base64_prefetch_count = n6 - 1;
        switch (n6) {
            default: {
                String string = "invalid binhex sequence encountered at offset" + this.input_position();
                throw new IonReaderTextTokenException(string);
            }
            case 3: {
                int n7 = IonReaderTextRawTokensX.decode_base64_byte3(n2, n3, n4, n5);
                this._base64_prefetch_stack = n7 << 8 & 0xFF00;
            }
            case 2: {
                int n8 = IonReaderTextRawTokensX.decode_base64_byte2(n2, n3, n4, n5);
                this._base64_prefetch_stack |= n8 & 0xFF;
            }
            case 1: 
        }
        int n9 = IonReaderTextRawTokensX.decode_base64_byte1(n2, n3, n4, n5);
        return n9;
    }

    private final int read_base64_getchar_helper(int n) throws IOException {
        assert (n != -1 && n != 125);
        if (n == -1 || n == 125) {
            return -1;
        }
        if (n == BASE64_TERMINATOR_CHAR) {
            this.error("invalid base64 image - excess terminator characters ['=']");
        }
        return this.read_base64_getchar_helper2(n);
    }

    private final int read_base64_getchar_helper() throws IOException {
        int n = this.skip_over_blob_whitespace();
        if (n == -1 || n == 125) {
            this.error("invalid base64 image - too short");
        }
        return this.read_base64_getchar_helper2(n);
    }

    private final int read_base64_getchar_helper2(int n) throws IOException {
        assert (n != -1 && n != 125);
        if (n == BASE64_TERMINATOR_CHAR) {
            return 128;
        }
        int n2 = BASE64_CHAR_TO_BIN[n & 0xFF];
        if (n2 == -1 || !IonTokenConstsX.is8bitValue(n)) {
            String string = "invalid character " + Character.toString((char)n) + " encountered in base64 value at " + this.input_position();
            throw new IonReaderTextTokenException(string);
        }
        return n2;
    }

    private static final int decode_base64_length(int n, int n2, int n3, int n4) {
        int n5 = 3;
        n5 = n4 != 128 ? 3 : (n3 != 128 ? 2 : 1);
        return n5;
    }

    private static final int decode_base64_byte1(int n, int n2, int n3, int n4) {
        int n5 = n << 2 & 0xFC | n2 >> 4 & 3;
        return n5;
    }

    private static final int decode_base64_byte2(int n, int n2, int n3, int n4) {
        int n5 = (n2 << 4 & 0xF0 | n3 >> 2 & 0xF) & 0xFF;
        return n5;
    }

    private static final int decode_base64_byte3(int n, int n2, int n3, int n4) {
        int n5 = ((n3 & 3) << 6 | n4 & 0x3F) & 0xFF;
        return n5;
    }

    protected void save_point_start(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        assert (savePoint != null && savePoint.isClear());
        long l = this._line_count;
        long l2 = this._line_starting_position;
        savePoint.start(l, l2);
    }

    protected void save_point_activate(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        assert (savePoint != null && savePoint.isDefined());
        long l = this._line_count;
        long l2 = this._line_starting_position;
        this._stream._save_points.savePointPushActive(savePoint, l, l2);
        this._line_count = savePoint.getStartLineNumber();
        this._line_starting_position = savePoint.getStartLineStart();
    }

    protected void save_point_deactivate(UnifiedSavePointManagerX.SavePoint savePoint) throws IOException {
        assert (savePoint != null && savePoint.isActive());
        this._stream._save_points.savePointPopActive(savePoint);
        this._line_count = savePoint.getPrevLineNumber();
        this._line_starting_position = savePoint.getPrevLineStart();
    }

    protected final void error(String string) {
        String string2 = string + this.input_position();
        throw new IonReaderTextTokenException(string2);
    }

    protected final void unexpected_eof() {
        String string = "unexpected EOF encountered " + this.input_position();
        throw new UnexpectedEofException(string);
    }

    protected final void bad_escape_sequence() {
        String string = "bad escape character encountered " + this.input_position();
        throw new IonReaderTextTokenException(string);
    }

    protected final void bad_escape_sequence(int n) {
        String string = "bad escape character '" + IonTextUtils.printCodePointAsString(n) + "' encountered " + this.input_position();
        throw new IonReaderTextTokenException(string);
    }

    protected final void bad_token_start(int n) {
        String string = "bad character [" + n + ", " + IonTextUtils.printCodePointAsString(n) + "] encountered where a token was supposed to start " + this.input_position();
        throw new IonReaderTextTokenException(string);
    }

    protected final void bad_token(int n) {
        String string = IonTextUtils.printCodePointAsString(n);
        String string2 = "a bad character " + string + " was encountered " + this.input_position();
        throw new IonReaderTextTokenException(string2);
    }

    protected final void expected_but_found(String string, int n) {
        String string2 = IonTextUtils.printCodePointAsString(n);
        String string3 = "Expected " + string + " but found " + string2 + this.input_position();
        throw new IonReaderTextTokenException(string3);
    }

    private int readNumeric(Appendable appendable, Radix radix) throws IOException {
        return this.readNumeric(appendable, radix, NumericState.START);
    }

    private int readNumeric(Appendable appendable, Radix radix, NumericState numericState) throws IOException {
        NumericState numericState2 = numericState;
        while (true) {
            int n = this.read_char();
            switch (numericState2) {
                case START: {
                    if (radix.isValidDigit(n)) {
                        appendable.append(radix.normalizeDigit((char)n));
                        numericState2 = NumericState.DIGIT;
                        break;
                    }
                    return n;
                }
                case DIGIT: {
                    if (radix.isValidDigit(n)) {
                        appendable.append(radix.normalizeDigit((char)n));
                        numericState2 = NumericState.DIGIT;
                        break;
                    }
                    if (n == 95) {
                        numericState2 = NumericState.UNDERSCORE;
                        break;
                    }
                    return n;
                }
                case UNDERSCORE: {
                    if (radix.isValidDigit(n)) {
                        appendable.append(radix.normalizeDigit((char)n));
                        numericState2 = NumericState.DIGIT;
                        break;
                    }
                    this.unread_char(n);
                    return 95;
                }
            }
        }
    }

    private static enum NumericState {
        START,
        UNDERSCORE,
        DIGIT;

    }

    private static abstract class Radix
    extends Enum<Radix> {
        public static final /* enum */ Radix BINARY = new Radix(){

            @Override
            boolean isPrefix(int n) {
                return n == 98 || n == 66;
            }

            @Override
            boolean isValidDigit(int n) {
                return IonTokenConstsX.isBinaryDigit(n);
            }

            @Override
            char normalizeDigit(char c) {
                return c;
            }
        };
        public static final /* enum */ Radix DECIMAL = new Radix(){

            @Override
            boolean isPrefix(int n) {
                return false;
            }

            @Override
            boolean isValidDigit(int n) {
                return IonTokenConstsX.isDigit(n);
            }

            @Override
            char normalizeDigit(char c) {
                return c;
            }
        };
        public static final /* enum */ Radix HEX = new Radix(){

            @Override
            boolean isPrefix(int n) {
                return n == 120 || n == 88;
            }

            @Override
            boolean isValidDigit(int n) {
                return IonTokenConstsX.isHexDigit(n);
            }

            @Override
            char normalizeDigit(char c) {
                return Character.toLowerCase(c);
            }
        };
        private static final /* synthetic */ Radix[] $VALUES;

        public static Radix[] values() {
            return (Radix[])$VALUES.clone();
        }

        public static Radix valueOf(String string) {
            return Enum.valueOf(Radix.class, string);
        }

        abstract boolean isPrefix(int var1);

        abstract boolean isValidDigit(int var1);

        abstract char normalizeDigit(char var1);

        void assertPrefix(int n) {
            assert (this.isPrefix(n));
        }

        static {
            $VALUES = new Radix[]{BINARY, DECIMAL, HEX};
        }
    }

    private static enum ProhibitedCharacters {
        SHORT_CHAR{

            @Override
            boolean includes(int n) {
                return ProhibitedCharacters.isControlCharacter(n) && !ProhibitedCharacters.isWhitespace(n);
            }
        }
        ,
        LONG_CHAR{

            @Override
            boolean includes(int n) {
                return ProhibitedCharacters.isControlCharacter(n) && !ProhibitedCharacters.isWhitespace(n) && !ProhibitedCharacters.isNewline(n);
            }
        }
        ,
        NONE{

            @Override
            boolean includes(int n) {
                return false;
            }
        };


        abstract boolean includes(int var1);

        private static boolean isControlCharacter(int n) {
            return n <= 31 && 0 <= n;
        }

        private static boolean isNewline(int n) {
            return n == 10 || n == 13;
        }

        private static boolean isWhitespace(int n) {
            return n == 9 || n == 11 || n == 12 || n == 32;
        }
    }

    public static class IonReaderTextTokenException
    extends IonException {
        private static final long serialVersionUID = 1L;

        IonReaderTextTokenException(String string) {
            super(string);
        }
    }

    private static enum CommentStrategy {
        IGNORE{

            @Override
            boolean onComment(IonReaderTextRawTokensX ionReaderTextRawTokensX) throws IOException {
                int n = ionReaderTextRawTokensX.read_char();
                switch (n) {
                    case 47: {
                        ionReaderTextRawTokensX.skip_single_line_comment();
                        return true;
                    }
                    case 42: {
                        ionReaderTextRawTokensX.skip_block_comment();
                        return true;
                    }
                }
                ionReaderTextRawTokensX.unread_char(n);
                return false;
            }
        }
        ,
        ERROR{

            @Override
            boolean onComment(IonReaderTextRawTokensX ionReaderTextRawTokensX) throws IOException {
                int n = ionReaderTextRawTokensX.read_char();
                if (n == 47 || n == 42) {
                    ionReaderTextRawTokensX.error("Illegal comment");
                } else {
                    ionReaderTextRawTokensX.unread_char(n);
                }
                return false;
            }
        }
        ,
        BREAK{

            @Override
            boolean onComment(IonReaderTextRawTokensX ionReaderTextRawTokensX) throws IOException {
                return false;
            }
        };


        abstract boolean onComment(IonReaderTextRawTokensX var1) throws IOException;
    }
}

