/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.PrivateIonValue;

final class IonIteratorImpl
implements Iterator<IonValue> {
    private final ValueFactory _valueFactory;
    private final IonReader _reader;
    private boolean _at_eof;
    private IonValue _curr;
    private IonValue _next;

    public IonIteratorImpl(ValueFactory valueFactory, IonReader ionReader) {
        if (valueFactory == null || ionReader == null) {
            throw new NullPointerException();
        }
        this._valueFactory = valueFactory;
        this._reader = ionReader;
    }

    @Override
    public boolean hasNext() {
        if (this._at_eof) {
            return false;
        }
        if (this._next != null) {
            return true;
        }
        return this.prefetch() != null;
    }

    private IonValue prefetch() {
        assert (!this._at_eof && this._next == null);
        IonType ionType = this._reader.next();
        if (ionType == null) {
            this._at_eof = true;
        } else {
            this._next = this.readValue();
        }
        return this._next;
    }

    private IonValue readValue() {
        Object object;
        Object object2;
        IonType ionType = this._reader.getType();
        SymbolToken[] symbolTokenArray = this._reader.getTypeAnnotationSymbols();
        if (this._reader.isNullValue()) {
            object2 = this._valueFactory.newNull(ionType);
        } else {
            switch (ionType) {
                case NULL: {
                    throw new IllegalStateException();
                }
                case BOOL: {
                    object2 = this._valueFactory.newBool(this._reader.booleanValue());
                    break;
                }
                case INT: {
                    object2 = this._valueFactory.newInt(this._reader.bigIntegerValue());
                    break;
                }
                case FLOAT: {
                    object2 = this._valueFactory.newFloat(this._reader.doubleValue());
                    break;
                }
                case DECIMAL: {
                    object2 = this._valueFactory.newDecimal(this._reader.decimalValue());
                    break;
                }
                case TIMESTAMP: {
                    object2 = this._valueFactory.newTimestamp(this._reader.timestampValue());
                    break;
                }
                case STRING: {
                    object2 = this._valueFactory.newString(this._reader.stringValue());
                    break;
                }
                case SYMBOL: {
                    object2 = this._valueFactory.newSymbol(this._reader.symbolValue());
                    break;
                }
                case BLOB: {
                    object = this._valueFactory.newNullBlob();
                    object.setBytes(this._reader.newBytes());
                    object2 = object;
                    break;
                }
                case CLOB: {
                    object = this._valueFactory.newNullClob();
                    object.setBytes(this._reader.newBytes());
                    object2 = object;
                    break;
                }
                case STRUCT: {
                    object = this._valueFactory.newEmptyStruct();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        SymbolToken symbolToken = this._reader.getFieldNameSymbol();
                        IonValue ionValue = this.readValue();
                        object.add(symbolToken, ionValue);
                    }
                    this._reader.stepOut();
                    object2 = object;
                    break;
                }
                case LIST: {
                    object = this._valueFactory.newEmptyList();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        IonValue ionValue = this.readValue();
                        object.add(ionValue);
                    }
                    this._reader.stepOut();
                    object2 = object;
                    break;
                }
                case SEXP: {
                    object = this._valueFactory.newEmptySexp();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        IonValue ionValue = this.readValue();
                        object.add(ionValue);
                    }
                    this._reader.stepOut();
                    object2 = object;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        object = this._reader.getSymbolTable();
        ((PrivateIonValue)object2).setSymbolTable((SymbolTable)object);
        if (symbolTokenArray.length != 0) {
            ((PrivateIonValue)object2).setTypeAnnotationSymbols(symbolTokenArray);
        }
        return object2;
    }

    @Override
    public IonValue next() {
        if (!this._at_eof) {
            this._curr = null;
            if (this._next == null) {
                this.prefetch();
            }
            if (this._next != null) {
                this._curr = this._next;
                this._next = null;
                return this._curr;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

