/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class Decimal
extends BigDecimal {
    private static final long serialVersionUID = 1L;
    public static final Decimal ZERO = new Decimal(0);
    public static final Decimal NEGATIVE_ZERO = new NegativeZero(0);

    public static boolean isNegativeZero(BigDecimal bigDecimal) {
        return bigDecimal.getClass() == NegativeZero.class;
    }

    public static BigDecimal bigDecimalValue(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.getClass() == BigDecimal.class) {
            return bigDecimal;
        }
        return new BigDecimal(bigDecimal.unscaledValue(), bigDecimal.scale());
    }

    public static boolean equals(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return Decimal.isNegativeZero(bigDecimal) == Decimal.isNegativeZero(bigDecimal2) && bigDecimal.equals(bigDecimal2);
    }

    public static Decimal negativeZero(int n) {
        return new NegativeZero(n);
    }

    public static Decimal negativeZero(int n, MathContext mathContext) {
        return new NegativeZero(n, mathContext);
    }

    public static Decimal valueOf(BigInteger bigInteger, int n) {
        return new Decimal(bigInteger, n);
    }

    public static Decimal valueOf(BigInteger bigInteger, int n, MathContext mathContext) {
        return new Decimal(bigInteger, n, mathContext);
    }

    public static Decimal valueOf(BigInteger bigInteger) {
        return new Decimal(bigInteger);
    }

    public static Decimal valueOf(BigInteger bigInteger, MathContext mathContext) {
        return new Decimal(bigInteger, mathContext);
    }

    public static Decimal valueOf(int n) {
        return new Decimal(n);
    }

    public static Decimal valueOf(int n, MathContext mathContext) {
        return new Decimal(n, mathContext);
    }

    public static Decimal valueOf(long l) {
        return new Decimal(l);
    }

    public static Decimal valueOf(long l, MathContext mathContext) {
        return new Decimal(l, mathContext);
    }

    public static Decimal valueOf(double d) {
        if (Double.compare(d, -0.0) == 0) {
            return new NegativeZero(1);
        }
        return new Decimal(Double.toString(d));
    }

    public static Decimal valueOf(double d, MathContext mathContext) {
        if (Double.compare(d, -0.0) == 0) {
            return new NegativeZero(1, mathContext);
        }
        return new Decimal(Double.toString(d), mathContext);
    }

    public static Decimal valueOf(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal instanceof Decimal) {
            return (Decimal)bigDecimal;
        }
        return new Decimal(bigDecimal.unscaledValue(), bigDecimal.scale());
    }

    public static Decimal valueOf(BigDecimal bigDecimal, MathContext mathContext) {
        return new Decimal(bigDecimal.unscaledValue(), bigDecimal.scale(), mathContext);
    }

    public static Decimal valueOf(String string) {
        boolean bl = string.startsWith("-");
        Decimal decimal = new Decimal(string);
        if (bl && decimal.signum() == 0) {
            decimal = new NegativeZero(decimal.scale());
        }
        return decimal;
    }

    public static Decimal valueOf(String string, MathContext mathContext) {
        boolean bl = string.startsWith("-");
        Decimal decimal = new Decimal(string, mathContext);
        if (bl && decimal.signum() == 0) {
            decimal = new NegativeZero(decimal.scale(), mathContext);
        }
        return decimal;
    }

    private Decimal(BigInteger bigInteger, int n) {
        super(bigInteger, n);
    }

    private Decimal(BigInteger bigInteger, int n, MathContext mathContext) {
        super(bigInteger, n, mathContext);
    }

    private Decimal(BigInteger bigInteger) {
        super(bigInteger);
    }

    private Decimal(BigInteger bigInteger, MathContext mathContext) {
        super(bigInteger, mathContext);
    }

    private Decimal(int n) {
        super(n);
    }

    private Decimal(int n, MathContext mathContext) {
        super(n, mathContext);
    }

    private Decimal(long l) {
        super(l);
    }

    private Decimal(long l, MathContext mathContext) {
        super(l, mathContext);
    }

    private Decimal(double d) {
        super(d);
    }

    private Decimal(double d, MathContext mathContext) {
        super(d, mathContext);
    }

    private Decimal(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    private Decimal(char[] cArray, int n, int n2, MathContext mathContext) {
        super(cArray, n, n2, mathContext);
    }

    private Decimal(char[] cArray) {
        super(cArray);
    }

    private Decimal(char[] cArray, MathContext mathContext) {
        super(cArray, mathContext);
    }

    private Decimal(String string) {
        super(string);
    }

    private Decimal(String string, MathContext mathContext) {
        super(string, mathContext);
    }

    public final boolean isNegativeZero() {
        return this.getClass() == NegativeZero.class;
    }

    public final BigDecimal bigDecimalValue() {
        return new BigDecimal(this.unscaledValue(), this.scale());
    }

    private static final class NegativeZero
    extends Decimal {
        private static final long serialVersionUID = 1L;

        private NegativeZero(int n) {
            super(BigInteger.ZERO, n);
        }

        private NegativeZero(int n, MathContext mathContext) {
            super(BigInteger.ZERO, n, mathContext);
        }

        @Override
        public float floatValue() {
            float f = super.floatValue();
            if (Float.compare(0.0f, f) <= 0) {
                f = -1.0f * f;
            }
            return f;
        }

        @Override
        public double doubleValue() {
            double d = super.doubleValue();
            if (Double.compare(0.0, d) <= 0) {
                d = -1.0 * d;
            }
            return d;
        }

        @Override
        public BigDecimal abs() {
            return new BigDecimal(this.unscaledValue(), this.scale());
        }

        @Override
        public BigDecimal abs(MathContext mathContext) {
            return new BigDecimal(this.unscaledValue(), this.scale(), mathContext);
        }

        @Override
        public String toString() {
            return '-' + super.toString();
        }

        @Override
        public String toEngineeringString() {
            return '-' + super.toEngineeringString();
        }

        @Override
        public String toPlainString() {
            return '-' + super.toPlainString();
        }
    }
}

