/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class XmlValidationModeDetector {
    public static final int VALIDATION_NONE = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DTD = 2;
    public static final int VALIDATION_XSD = 3;
    private static final String DOCTYPE = "DOCTYPE";
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";
    private boolean inComment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectValidationMode(InputStream inputStream2) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));){
            String string;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                string = this.consumeCommentTokens(string);
                if (this.inComment || !StringUtils.hasText(string)) continue;
                if (this.hasDoctype(string)) {
                    bl = true;
                    break;
                }
                if (!this.hasOpeningTag(string)) continue;
            }
            int n = bl ? 2 : 3;
            return n;
        }
    }

    private boolean hasDoctype(String string) {
        return string.contains(DOCTYPE);
    }

    private boolean hasOpeningTag(String string) {
        if (this.inComment) {
            return false;
        }
        int n = string.indexOf(60);
        return n > -1 && string.length() > n + 1 && Character.isLetter(string.charAt(n + 1));
    }

    @Nullable
    private String consumeCommentTokens(String string) {
        int n = string.indexOf(START_COMMENT);
        if (n == -1 && !string.contains(END_COMMENT)) {
            return string;
        }
        String string2 = "";
        String string3 = string;
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n);
        }
        while ((string3 = this.consume(string3)) != null) {
            if (this.inComment || string3.trim().startsWith(START_COMMENT)) continue;
            return string2 + string3;
        }
        return null;
    }

    @Nullable
    private String consume(String string) {
        int n = this.inComment ? this.endComment(string) : this.startComment(string);
        return n == -1 ? null : string.substring(n);
    }

    private int startComment(String string) {
        return this.commentToken(string, START_COMMENT, true);
    }

    private int endComment(String string) {
        return this.commentToken(string, END_COMMENT, false);
    }

    private int commentToken(String string, String string2, boolean bl) {
        int n = string.indexOf(string2);
        if (n > -1) {
            this.inComment = bl;
        }
        return n == -1 ? n : n + string2.length();
    }
}

