/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class XMLEventStreamWriter
implements XMLStreamWriter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final XMLEventWriter eventWriter;
    private final XMLEventFactory eventFactory;
    private final List<EndElement> endElements = new ArrayList<EndElement>();
    private boolean emptyElement = false;

    public XMLEventStreamWriter(XMLEventWriter xMLEventWriter, XMLEventFactory xMLEventFactory) {
        this.eventWriter = xMLEventWriter;
        this.eventFactory = xMLEventFactory;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.eventWriter.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.eventWriter.getNamespaceContext();
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.eventWriter.setPrefix(string, string2);
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.eventWriter.getPrefix(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.eventWriter.setDefaultNamespace(string);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createStartDocument());
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createStartDocument(DEFAULT_ENCODING, string));
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createStartDocument(string, string2));
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.doWriteStartElement(this.eventFactory.createStartElement(new QName(string), null, null));
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.doWriteStartElement(this.eventFactory.createStartElement(new QName(string, string2), null, null));
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.doWriteStartElement(this.eventFactory.createStartElement(new QName(string3, string2, string), null, null));
    }

    private void doWriteStartElement(StartElement startElement) throws XMLStreamException {
        this.eventWriter.add(startElement);
        this.endElements.add(this.eventFactory.createEndElement(startElement.getName(), startElement.getNamespaces()));
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.writeStartElement(string);
        this.emptyElement = true;
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.writeStartElement(string, string2);
        this.emptyElement = true;
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.writeStartElement(string, string2, string3);
        this.emptyElement = true;
    }

    private void closeEmptyElementIfNecessary() throws XMLStreamException {
        if (this.emptyElement) {
            this.emptyElement = false;
            this.writeEndElement();
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        int n = this.endElements.size() - 1;
        EndElement endElement = this.endElements.get(n);
        this.eventWriter.add(endElement);
        this.endElements.remove(n);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createAttribute(string, string2));
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createAttribute(new QName(string, string2), string3));
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createAttribute(string, string2, string3, string4));
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.doWriteNamespace(this.eventFactory.createNamespace(string, string2));
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.doWriteNamespace(this.eventFactory.createNamespace(string));
    }

    private void doWriteNamespace(Namespace namespace) throws XMLStreamException {
        XMLEvent xMLEvent;
        int n = this.endElements.size() - 1;
        EndElement endElement = this.endElements.get(n);
        Iterator<Namespace> iterator2 = endElement.getNamespaces();
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        while (iterator2.hasNext()) {
            xMLEvent = iterator2.next();
            arrayList.add((Namespace)xMLEvent);
        }
        arrayList.add(namespace);
        xMLEvent = this.eventFactory.createEndElement(endElement.getName(), arrayList.iterator());
        this.eventWriter.add(namespace);
        this.endElements.set(n, (EndElement)xMLEvent);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createCharacters(string));
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createCharacters(new String(cArray, n, n2)));
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createCData(string));
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createComment(string));
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createProcessingInstruction(string, ""));
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createProcessingInstruction(string, string2));
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createDTD(string));
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createEntityReference(string, null));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.add(this.eventFactory.createEndDocument());
    }

    @Override
    public void flush() throws XMLStreamException {
        this.eventWriter.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.closeEmptyElementIfNecessary();
        this.eventWriter.close();
    }
}

