/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.util.xml.AbstractStaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class StaxStreamHandler
extends AbstractStaxHandler {
    private final XMLStreamWriter streamWriter;

    public StaxStreamHandler(XMLStreamWriter xMLStreamWriter) {
        this.streamWriter = xMLStreamWriter;
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    @Override
    protected void startElementInternal(QName qName, Attributes attributes, Map<String, String> map) throws XMLStreamException {
        this.streamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string = object.getKey();
            String string2 = object.getValue();
            this.streamWriter.writeNamespace(string, string2);
            if ("".equals(string)) {
                this.streamWriter.setDefaultNamespace(string2);
                continue;
            }
            this.streamWriter.setPrefix(string, string2);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName qName2 = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if (this.isNamespaceDeclaration(qName2)) continue;
            this.streamWriter.writeAttribute(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart(), attributes.getValue(i));
        }
    }

    @Override
    protected void endElementInternal(QName qName, Map<String, String> map) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    @Override
    protected void charactersInternal(String string) throws XMLStreamException {
        this.streamWriter.writeCharacters(string);
    }

    @Override
    protected void cDataInternal(String string) throws XMLStreamException {
        this.streamWriter.writeCData(string);
    }

    @Override
    protected void ignorableWhitespaceInternal(String string) throws XMLStreamException {
        this.streamWriter.writeCharacters(string);
    }

    @Override
    protected void processingInstructionInternal(String string, String string2) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(string, string2);
    }

    @Override
    protected void dtdInternal(String string) throws XMLStreamException {
        this.streamWriter.writeDTD(string);
    }

    @Override
    protected void commentInternal(String string) throws XMLStreamException {
        this.streamWriter.writeComment(string);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    protected void skippedEntityInternal(String string) throws XMLStreamException {
    }
}

