/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

class StaxEventXMLReader
extends AbstractStaxXMLReader {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private final XMLEventReader reader;
    private String xmlVersion = "1.0";
    @Nullable
    private String encoding;

    StaxEventXMLReader(XMLEventReader xMLEventReader) {
        try {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent != null && !xMLEvent.isStartDocument() && !xMLEvent.isStartElement()) {
                throw new IllegalStateException("XMLEventReader not at start of document or element");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Could not read first element: " + xMLStreamException.getMessage());
        }
        this.reader = xMLEventReader;
    }

    @Override
    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (this.reader.hasNext() && n >= 0) {
            XMLEvent xMLEvent = this.reader.nextEvent();
            if (!(xMLEvent.isStartDocument() || xMLEvent.isEndDocument() || bl)) {
                this.handleStartDocument(xMLEvent);
                bl = true;
            }
            switch (xMLEvent.getEventType()) {
                case 7: {
                    this.handleStartDocument(xMLEvent);
                    bl = true;
                    break;
                }
                case 1: {
                    ++n;
                    this.handleStartElement(xMLEvent.asStartElement());
                    break;
                }
                case 2: {
                    if (--n < 0) break;
                    this.handleEndElement(xMLEvent.asEndElement());
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction((ProcessingInstruction)xMLEvent);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(xMLEvent.asCharacters());
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    bl2 = true;
                    break;
                }
                case 14: {
                    this.handleNotationDeclaration((NotationDeclaration)xMLEvent);
                    break;
                }
                case 15: {
                    this.handleEntityDeclaration((EntityDeclaration)xMLEvent);
                    break;
                }
                case 5: {
                    this.handleComment((Comment)xMLEvent);
                    break;
                }
                case 11: {
                    this.handleDtd((DTD)xMLEvent);
                    break;
                }
                case 9: {
                    this.handleEntityReference((EntityReference)xMLEvent);
                }
            }
        }
        if (bl && !bl2) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument(XMLEvent xMLEvent) throws SAXException {
        Object object;
        Object object2;
        if (xMLEvent.isStartDocument()) {
            object2 = (StartDocument)xMLEvent;
            object = object2.getVersion();
            if (StringUtils.hasLength((String)object)) {
                this.xmlVersion = object;
            }
            if (object2.encodingSet()) {
                this.encoding = object2.getCharacterEncodingScheme();
            }
        }
        if ((object2 = this.getContentHandler()) != null) {
            object = xMLEvent.getLocation();
            object2.setDocumentLocator(new Locator2((Location)object){
                final /* synthetic */ Location val$location;
                {
                    this.val$location = location;
                }

                @Override
                public int getColumnNumber() {
                    return this.val$location != null ? this.val$location.getColumnNumber() : -1;
                }

                @Override
                public int getLineNumber() {
                    return this.val$location != null ? this.val$location.getLineNumber() : -1;
                }

                @Override
                @Nullable
                public String getPublicId() {
                    return this.val$location != null ? this.val$location.getPublicId() : null;
                }

                @Override
                @Nullable
                public String getSystemId() {
                    return this.val$location != null ? this.val$location.getSystemId() : null;
                }

                @Override
                public String getXMLVersion() {
                    return StaxEventXMLReader.this.xmlVersion;
                }

                @Override
                @Nullable
                public String getEncoding() {
                    return StaxEventXMLReader.this.encoding;
                }
            });
            object2.startDocument();
        }
    }

    private void handleStartElement(StartElement startElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = startElement.getName();
            if (this.hasNamespacesFeature()) {
                Attribute attribute;
                Iterator<Attribute> iterator2 = startElement.getNamespaces();
                while (iterator2.hasNext()) {
                    attribute = iterator2.next();
                    this.startPrefixMapping(attribute.getPrefix(), attribute.getNamespaceURI());
                }
                iterator2 = startElement.getAttributes();
                while (iterator2.hasNext()) {
                    attribute = iterator2.next();
                    QName qName2 = attribute.getName();
                    this.startPrefixMapping(qName2.getPrefix(), qName2.getNamespaceURI());
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName), this.getAttributes(startElement));
            } else {
                this.getContentHandler().startElement("", "", this.toQualifiedName(qName), this.getAttributes(startElement));
            }
        }
    }

    private void handleCharacters(Characters characters) throws SAXException {
        char[] cArray = characters.getData().toCharArray();
        if (this.getContentHandler() != null && characters.isIgnorableWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(cArray, 0, cArray.length);
            return;
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(cArray, 0, cArray.length);
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleEndElement(EndElement endElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = endElement.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName));
                Iterator<Namespace> iterator2 = endElement.getNamespaces();
                while (iterator2.hasNext()) {
                    Namespace namespace = iterator2.next();
                    this.endPrefixMapping(namespace.getPrefix());
                }
            } else {
                this.getContentHandler().endElement("", "", this.toQualifiedName(qName));
            }
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleNotationDeclaration(NotationDeclaration notationDeclaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().notationDecl(notationDeclaration.getName(), notationDeclaration.getPublicId(), notationDeclaration.getSystemId());
        }
    }

    private void handleEntityDeclaration(EntityDeclaration entityDeclaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
        }
    }

    private void handleProcessingInstruction(ProcessingInstruction processingInstruction) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
        }
    }

    private void handleComment(Comment comment) throws SAXException {
        if (this.getLexicalHandler() != null) {
            char[] cArray = comment.getText().toCharArray();
            this.getLexicalHandler().comment(cArray, 0, cArray.length);
        }
    }

    private void handleDtd(DTD dTD) throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = dTD.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference(EntityReference entityReference) throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(entityReference.getName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(entityReference.getName());
        }
    }

    private Attributes getAttributes(StartElement startElement) {
        String string;
        String string2;
        Object object;
        Attribute attribute;
        AttributesImpl attributesImpl = new AttributesImpl();
        Iterator<Attribute> iterator2 = startElement.getAttributes();
        while (iterator2.hasNext()) {
            attribute = iterator2.next();
            object = attribute.getName();
            string2 = ((QName)object).getNamespaceURI();
            if (string2 == null || !this.hasNamespacesFeature()) {
                string2 = "";
            }
            if ((string = attribute.getDTDType()) == null) {
                string = "CDATA";
            }
            attributesImpl.addAttribute(string2, ((QName)object).getLocalPart(), this.toQualifiedName((QName)object), string, attribute.getValue());
        }
        if (this.hasNamespacePrefixesFeature()) {
            iterator2 = startElement.getNamespaces();
            while (iterator2.hasNext()) {
                attribute = (Namespace)iterator2.next();
                object = attribute.getPrefix();
                string2 = attribute.getNamespaceURI();
                string = StringUtils.hasLength((String)object) ? "xmlns:" + (String)object : "xmlns";
                attributesImpl.addAttribute("", "", string, "CDATA", string2);
            }
        }
        return attributesImpl;
    }
}

