/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.xml.AbstractXMLEventReader;

class ListBasedXMLEventReader
extends AbstractXMLEventReader {
    private final List<XMLEvent> events;
    @Nullable
    private XMLEvent currentEvent;
    private int cursor = 0;

    public ListBasedXMLEventReader(List<XMLEvent> list) {
        Assert.notNull(list, "XMLEvent List must not be null");
        this.events = new ArrayList<XMLEvent>(list);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.events.size();
    }

    @Override
    public XMLEvent nextEvent() {
        if (this.hasNext()) {
            this.currentEvent = this.events.get(this.cursor);
            ++this.cursor;
            return this.currentEvent;
        }
        throw new NoSuchElementException();
    }

    @Override
    @Nullable
    public XMLEvent peek() {
        if (this.hasNext()) {
            return this.events.get(this.cursor);
        }
        return null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XMLEvent xMLEvent;
        this.checkIfClosed();
        if (this.currentEvent == null || !this.currentEvent.isStartElement()) {
            throw new XMLStreamException("Not at START_ELEMENT: " + this.currentEvent);
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!(xMLEvent = this.nextEvent()).isEndElement()) {
            if (!xMLEvent.isCharacters()) {
                throw new XMLStreamException("Unexpected non-text event: " + xMLEvent);
            }
            Characters characters = xMLEvent.asCharacters();
            if (characters.isIgnorableWhiteSpace()) continue;
            stringBuilder.append(xMLEvent.asCharacters().getData());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent xMLEvent;
        this.checkIfClosed();
        block6: while (true) {
            xMLEvent = this.nextEvent();
            switch (xMLEvent.getEventType()) {
                case 1: 
                case 2: {
                    return xMLEvent;
                }
                case 8: {
                    return null;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block6;
                }
                case 4: 
                case 12: {
                    if (!xMLEvent.asCharacters().isWhiteSpace()) throw new XMLStreamException("Non-ignorable whitespace CDATA or CHARACTERS event: " + xMLEvent);
                    continue block6;
                }
            }
            break;
        }
        throw new XMLStreamException("Expected START_ELEMENT or END_ELEMENT: " + xMLEvent);
    }

    @Override
    public void close() {
        super.close();
        this.events.clear();
    }
}

