/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.springframework.lang.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

abstract class AbstractStaxHandler
implements ContentHandler,
LexicalHandler {
    private final List<Map<String, String>> namespaceMappings = new ArrayList<Map<String, String>>();
    private boolean inCData;

    AbstractStaxHandler() {
    }

    @Override
    public final void startDocument() throws SAXException {
        this.removeAllNamespaceMappings();
        this.newNamespaceMapping();
        try {
            this.startDocumentInternal();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle startDocument: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        this.removeAllNamespaceMappings();
        try {
            this.endDocumentInternal();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle endDocument: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void startPrefixMapping(String string, String string2) {
        this.currentNamespaceMapping().put(string, string2);
    }

    @Override
    public final void endPrefixMapping(String string) {
    }

    @Override
    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.startElementInternal(this.toQName(string, string3), attributes, this.currentNamespaceMapping());
            this.newNamespaceMapping();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle startElement: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementInternal(this.toQName(string, string3), this.currentNamespaceMapping());
            this.removeNamespaceMapping();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle endElement: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            String string = new String(cArray, n, n2);
            if (!this.inCData) {
                this.charactersInternal(string);
            } else {
                this.cDataInternal(string);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle characters: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.ignorableWhitespaceInternal(new String(cArray, n, n2));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle ignorableWhitespace:" + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.processingInstructionInternal(string, string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle processingInstruction: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void skippedEntity(String string) throws SAXException {
        try {
            this.skippedEntityInternal(string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle skippedEntity: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void startDTD(String string, @Nullable String string2, String string3) throws SAXException {
        try {
            StringBuilder stringBuilder = new StringBuilder("<!DOCTYPE ");
            stringBuilder.append(string);
            if (string2 != null) {
                stringBuilder.append(" PUBLIC \"");
                stringBuilder.append(string2);
                stringBuilder.append("\" \"");
            } else {
                stringBuilder.append(" SYSTEM \"");
            }
            stringBuilder.append(string3);
            stringBuilder.append("\">");
            this.dtdInternal(stringBuilder.toString());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle startDTD: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public final void endDTD() throws SAXException {
    }

    @Override
    public final void startCDATA() throws SAXException {
        this.inCData = true;
    }

    @Override
    public final void endCDATA() throws SAXException {
        this.inCData = false;
    }

    @Override
    public final void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.commentInternal(new String(cArray, n, n2));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException("Could not handle comment: " + xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    protected QName toQName(String string, String string2) {
        int n = string2.indexOf(58);
        if (n == -1) {
            return new QName(string, string2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        return new QName(string, string4, string3);
    }

    protected boolean isNamespaceDeclaration(QName qName) {
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        return "xmlns".equals(string2) && string.isEmpty() || "xmlns".equals(string) && !string2.isEmpty();
    }

    private Map<String, String> currentNamespaceMapping() {
        return this.namespaceMappings.get(this.namespaceMappings.size() - 1);
    }

    private void newNamespaceMapping() {
        this.namespaceMappings.add(new HashMap());
    }

    private void removeNamespaceMapping() {
        this.namespaceMappings.remove(this.namespaceMappings.size() - 1);
    }

    private void removeAllNamespaceMappings() {
        this.namespaceMappings.clear();
    }

    protected abstract void startDocumentInternal() throws XMLStreamException;

    protected abstract void endDocumentInternal() throws XMLStreamException;

    protected abstract void startElementInternal(QName var1, Attributes var2, Map<String, String> var3) throws XMLStreamException;

    protected abstract void endElementInternal(QName var1, Map<String, String> var2) throws XMLStreamException;

    protected abstract void charactersInternal(String var1) throws XMLStreamException;

    protected abstract void cDataInternal(String var1) throws XMLStreamException;

    protected abstract void ignorableWhitespaceInternal(String var1) throws XMLStreamException;

    protected abstract void processingInstructionInternal(String var1, String var2) throws XMLStreamException;

    protected abstract void skippedEntityInternal(String var1) throws XMLStreamException;

    protected abstract void dtdInternal(String var1) throws XMLStreamException;

    protected abstract void commentInternal(String var1) throws XMLStreamException;
}

