/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.function;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SingletonSupplier<T>
implements Supplier<T> {
    @Nullable
    private final Supplier<? extends T> instanceSupplier;
    @Nullable
    private final Supplier<? extends T> defaultSupplier;
    @Nullable
    private volatile T singletonInstance;

    public SingletonSupplier(@Nullable T t2, Supplier<? extends T> supplier) {
        this.instanceSupplier = null;
        this.defaultSupplier = supplier;
        this.singletonInstance = t2;
    }

    public SingletonSupplier(@Nullable Supplier<? extends T> supplier, Supplier<? extends T> supplier2) {
        this.instanceSupplier = supplier;
        this.defaultSupplier = supplier2;
    }

    private SingletonSupplier(Supplier<? extends T> supplier) {
        this.instanceSupplier = supplier;
        this.defaultSupplier = null;
    }

    private SingletonSupplier(T t2) {
        this.instanceSupplier = null;
        this.defaultSupplier = null;
        this.singletonInstance = t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T get() {
        T t2 = this.singletonInstance;
        if (t2 == null) {
            SingletonSupplier singletonSupplier = this;
            synchronized (singletonSupplier) {
                t2 = this.singletonInstance;
                if (t2 == null) {
                    if (this.instanceSupplier != null) {
                        t2 = this.instanceSupplier.get();
                    }
                    if (t2 == null && this.defaultSupplier != null) {
                        t2 = this.defaultSupplier.get();
                    }
                    this.singletonInstance = t2;
                }
            }
        }
        return t2;
    }

    public T obtain() {
        T t2 = this.get();
        Assert.state(t2 != null, "No instance from Supplier");
        return t2;
    }

    public static <T> SingletonSupplier<T> of(T t2) {
        return new SingletonSupplier<T>(t2);
    }

    @Nullable
    public static <T> SingletonSupplier<T> ofNullable(@Nullable T t2) {
        return t2 != null ? new SingletonSupplier<T>(t2) : null;
    }

    public static <T> SingletonSupplier<T> of(Supplier<T> supplier) {
        return new SingletonSupplier<Supplier<T>>(supplier);
    }

    @Nullable
    public static <T> SingletonSupplier<T> ofNullable(@Nullable Supplier<T> supplier) {
        return supplier != null ? new SingletonSupplier<Supplier<Supplier<Supplier<Supplier<T>>>>>(supplier) : null;
    }
}

