/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.DelegatingCompletableFuture;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;

public class ListenableFutureTask<T>
extends FutureTask<T>
implements ListenableFuture<T> {
    private final ListenableFutureCallbackRegistry<T> callbacks = new ListenableFutureCallbackRegistry();

    public ListenableFutureTask(Callable<T> callable) {
        super(callable);
    }

    public ListenableFutureTask(Runnable runnable2, @Nullable T t2) {
        super(runnable2, t2);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> listenableFutureCallback) {
        this.callbacks.addCallback(listenableFutureCallback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.callbacks.addSuccessCallback(successCallback);
        this.callbacks.addFailureCallback(failureCallback);
    }

    @Override
    public CompletableFuture<T> completable() {
        DelegatingCompletableFuture delegatingCompletableFuture = new DelegatingCompletableFuture(this);
        this.callbacks.addSuccessCallback(delegatingCompletableFuture::complete);
        this.callbacks.addFailureCallback(delegatingCompletableFuture::completeExceptionally);
        return delegatingCompletableFuture;
    }

    @Override
    protected void done() {
        Throwable throwable;
        try {
            Object v = this.get();
            this.callbacks.success(v);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
            if (throwable == null) {
                throwable = executionException;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        this.callbacks.failure(throwable);
    }
}

