/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.backoff;

import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class FixedBackOff
implements BackOff {
    public static final long DEFAULT_INTERVAL = 5000L;
    public static final long UNLIMITED_ATTEMPTS = Long.MAX_VALUE;
    private long interval = 5000L;
    private long maxAttempts = Long.MAX_VALUE;

    public FixedBackOff() {
    }

    public FixedBackOff(long l, long l2) {
        this.interval = l;
        this.maxAttempts = l2;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setMaxAttempts(long l) {
        this.maxAttempts = l;
    }

    public long getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public BackOffExecution start() {
        return new FixedBackOffExecution();
    }

    private class FixedBackOffExecution
    implements BackOffExecution {
        private long currentAttempts = 0L;

        private FixedBackOffExecution() {
        }

        @Override
        public long nextBackOff() {
            ++this.currentAttempts;
            if (this.currentAttempts <= FixedBackOff.this.getMaxAttempts()) {
                return FixedBackOff.this.getInterval();
            }
            return -1L;
        }

        public String toString() {
            String string = FixedBackOff.this.maxAttempts == Long.MAX_VALUE ? "unlimited" : String.valueOf(FixedBackOff.this.maxAttempts);
            return "FixedBackOff{interval=" + FixedBackOff.this.interval + ", currentAttempts=" + this.currentAttempts + ", maxAttempts=" + string + '}';
        }
    }
}

