/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.backoff;

import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class ExponentialBackOff
implements BackOff {
    public static final long DEFAULT_INITIAL_INTERVAL = 2000L;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final long DEFAULT_MAX_INTERVAL = 30000L;
    public static final long DEFAULT_MAX_ELAPSED_TIME = Long.MAX_VALUE;
    private long initialInterval = 2000L;
    private double multiplier = 1.5;
    private long maxInterval = 30000L;
    private long maxElapsedTime = Long.MAX_VALUE;

    public ExponentialBackOff() {
    }

    public ExponentialBackOff(long l, double d) {
        this.checkMultiplier(d);
        this.initialInterval = l;
        this.multiplier = d;
    }

    public void setInitialInterval(long l) {
        this.initialInterval = l;
    }

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public void setMultiplier(double d) {
        this.checkMultiplier(d);
        this.multiplier = d;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMaxInterval(long l) {
        this.maxInterval = l;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxElapsedTime(long l) {
        this.maxElapsedTime = l;
    }

    public long getMaxElapsedTime() {
        return this.maxElapsedTime;
    }

    @Override
    public BackOffExecution start() {
        return new ExponentialBackOffExecution();
    }

    private void checkMultiplier(double d) {
        Assert.isTrue(d >= 1.0, () -> "Invalid multiplier '" + d + "'. Should be greater than or equal to 1. A multiplier of 1 is equivalent to a fixed interval.");
    }

    private class ExponentialBackOffExecution
    implements BackOffExecution {
        private long currentInterval = -1L;
        private long currentElapsedTime = 0L;

        private ExponentialBackOffExecution() {
        }

        @Override
        public long nextBackOff() {
            if (this.currentElapsedTime >= ExponentialBackOff.this.maxElapsedTime) {
                return -1L;
            }
            long l = this.computeNextInterval();
            this.currentElapsedTime += l;
            return l;
        }

        private long computeNextInterval() {
            long l;
            long l2 = ExponentialBackOff.this.getMaxInterval();
            if (this.currentInterval >= l2) {
                return l2;
            }
            this.currentInterval = this.currentInterval < 0L ? ((l = ExponentialBackOff.this.getInitialInterval()) < l2 ? l : l2) : this.multiplyInterval(l2);
            return this.currentInterval;
        }

        private long multiplyInterval(long l) {
            long l2 = this.currentInterval;
            return (l2 = (long)((double)l2 * ExponentialBackOff.this.getMultiplier())) > l ? l : l2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ExponentialBackOff{");
            stringBuilder.append("currentInterval=").append(this.currentInterval < 0L ? "n/a" : this.currentInterval + "ms");
            stringBuilder.append(", multiplier=").append(ExponentialBackOff.this.getMultiplier());
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }
}

