/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TypeUtils {
    public static boolean isAssignable(Type type, Type type2) {
        Type type3;
        Type type4;
        Assert.notNull((Object)type, "Left-hand side type must not be null");
        Assert.notNull((Object)type2, "Right-hand side type must not be null");
        if (type.equals(type2) || Object.class == type) {
            return true;
        }
        if (type instanceof Class) {
            type4 = (Class)type;
            if (type2 instanceof Class) {
                return ClassUtils.isAssignable(type4, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                type3 = ((ParameterizedType)type2).getRawType();
                if (type3 instanceof Class) {
                    return ClassUtils.isAssignable(type4, (Class)type3);
                }
            } else if (((Class)type4).isArray() && type2 instanceof GenericArrayType) {
                Type type5 = ((GenericArrayType)type2).getGenericComponentType();
                return TypeUtils.isAssignable(((Class)type4).getComponentType(), type5);
            }
        }
        if (type instanceof ParameterizedType) {
            if (type2 instanceof Class) {
                type4 = ((ParameterizedType)type).getRawType();
                if (type4 instanceof Class) {
                    return ClassUtils.isAssignable(type4, (Class)type2);
                }
            } else if (type2 instanceof ParameterizedType) {
                return TypeUtils.isAssignable((ParameterizedType)type, (ParameterizedType)type2);
            }
        }
        if (type instanceof GenericArrayType) {
            type4 = ((GenericArrayType)type).getGenericComponentType();
            if (type2 instanceof Class) {
                type3 = (Class)type2;
                if (((Class)type3).isArray()) {
                    return TypeUtils.isAssignable(type4, ((Class)type3).getComponentType());
                }
            } else if (type2 instanceof GenericArrayType) {
                type3 = ((GenericArrayType)type2).getGenericComponentType();
                return TypeUtils.isAssignable(type4, type3);
            }
        }
        if (type instanceof WildcardType) {
            return TypeUtils.isAssignable((WildcardType)type, type2);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType parameterizedType, ParameterizedType parameterizedType2) {
        Type[] typeArray;
        if (parameterizedType.equals(parameterizedType2)) {
            return true;
        }
        Type[] typeArray2 = parameterizedType.getActualTypeArguments();
        if (typeArray2.length != (typeArray = parameterizedType2.getActualTypeArguments()).length) {
            return false;
        }
        int n = typeArray2.length;
        for (int i = 0; i < n; ++i) {
            Type type = typeArray2[i];
            Type type2 = typeArray[i];
            if (type.equals(type2) || type instanceof WildcardType && TypeUtils.isAssignable((WildcardType)type, type2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType wildcardType, Type type) {
        Type[] typeArray;
        Type[] typeArray2 = wildcardType.getUpperBounds();
        if (typeArray2.length == 0) {
            typeArray2 = new Type[]{Object.class};
        }
        if ((typeArray = wildcardType.getLowerBounds()).length == 0) {
            typeArray = new Type[]{null};
        }
        if (type instanceof WildcardType) {
            Type[] typeArray3;
            WildcardType wildcardType2 = (WildcardType)type;
            Type[] typeArray4 = wildcardType2.getUpperBounds();
            if (typeArray4.length == 0) {
                typeArray4 = new Type[]{Object.class};
            }
            if ((typeArray3 = wildcardType2.getLowerBounds()).length == 0) {
                typeArray3 = new Type[]{null};
            }
            for (Type type2 : typeArray2) {
                for (Type type3 : typeArray4) {
                    if (TypeUtils.isAssignableBound(type2, type3)) continue;
                    return false;
                }
                for (Type type3 : typeArray3) {
                    if (TypeUtils.isAssignableBound(type2, type3)) continue;
                    return false;
                }
            }
            for (Type type2 : typeArray) {
                for (Type type3 : typeArray4) {
                    if (TypeUtils.isAssignableBound(type3, type2)) continue;
                    return false;
                }
                for (Type type3 : typeArray3) {
                    if (TypeUtils.isAssignableBound(type3, type2)) continue;
                    return false;
                }
            }
        } else {
            for (Type type4 : typeArray2) {
                if (TypeUtils.isAssignableBound(type4, type)) continue;
                return false;
            }
            for (Type type4 : typeArray) {
                if (TypeUtils.isAssignableBound(type, type4)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAssignableBound(@Nullable Type type, @Nullable Type type2) {
        if (type2 == null) {
            return true;
        }
        if (type == null) {
            return false;
        }
        return TypeUtils.isAssignable(type, type2);
    }
}

