/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;

public abstract class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';

    public static boolean isEmpty(@Nullable Object object) {
        return object == null || "".equals(object);
    }

    public static boolean hasLength(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasLength(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasText(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0 && StringUtils.containsText(charSequence);
    }

    public static boolean hasText(@Nullable String string) {
        return string != null && !string.isEmpty() && StringUtils.containsText(string);
    }

    private static boolean containsText(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable CharSequence charSequence) {
        if (!StringUtils.hasLength(charSequence)) {
            return false;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(charSequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable String string) {
        return StringUtils.containsWhitespace((CharSequence)string);
    }

    public static String trimWhitespace(String string) {
        int n;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        int n2 = string.length() - 1;
        for (n = 0; n <= n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        while (n2 > n && Character.isWhitespace(string.charAt(n2))) {
            --n2;
        }
        return string.substring(n, n2 + 1);
    }

    public static String trimAllWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String trimLeadingWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() > 0 && Character.isWhitespace(stringBuilder.charAt(0))) {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public static String trimTrailingWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() > 0 && Character.isWhitespace(stringBuilder.charAt(stringBuilder.length() - 1))) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String trimLeadingCharacter(String string, char c) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() > 0 && stringBuilder.charAt(0) == c) {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public static String trimTrailingCharacter(String string, char c) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == c) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean matchesCharacter(@Nullable String string, char c) {
        return string != null && string.length() == 1 && string.charAt(0) == c;
    }

    public static boolean startsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() && string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean endsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() && string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static boolean substringMatch(CharSequence charSequence, int n, CharSequence charSequence2) {
        if (n + charSequence2.length() > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(n + i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String string, String string2) {
        int n;
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) != -1) {
            ++n2;
            n3 = n + string2.length();
        }
        return n2;
    }

    public static String replace(String string, String string2, @Nullable String string3) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2) || string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        if (string3.length() > string2.length()) {
            n2 += 16;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        int n4 = string2.length();
        while (n >= 0) {
            stringBuilder.append(string, n3, n);
            stringBuilder.append(string3);
            n3 = n + n4;
            n = string.indexOf(string2, n3);
        }
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    public static String delete(String string, String string2) {
        return StringUtils.replace(string, string2, "");
    }

    public static String deleteAny(String string, @Nullable String string2) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2)) {
            return string;
        }
        int n = 0;
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            cArray[n++] = c;
        }
        if (n == string.length()) {
            return string;
        }
        return new String(cArray, 0, n);
    }

    @Nullable
    public static String quote(@Nullable String string) {
        return string != null ? "'" + string + "'" : null;
    }

    @Nullable
    public static Object quoteIfString(@Nullable Object object) {
        return object instanceof String ? StringUtils.quote((String)object) : object;
    }

    public static String unqualify(String string) {
        return StringUtils.unqualify(string, '.');
    }

    public static String unqualify(String string, char c) {
        return string.substring(string.lastIndexOf(c) + 1);
    }

    public static String capitalize(String string) {
        return StringUtils.changeFirstCharacterCase(string, true);
    }

    public static String uncapitalize(String string) {
        return StringUtils.changeFirstCharacterCase(string, false);
    }

    private static String changeFirstCharacterCase(String string, boolean bl) {
        char c;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = bl ? Character.toUpperCase(c2) : Character.toLowerCase(c2))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = c;
        return new String(cArray);
    }

    @Nullable
    public static String getFilename(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(FOLDER_SEPARATOR);
        return n != -1 ? string.substring(n + 1) : string;
    }

    @Nullable
    public static String getFilenameExtension(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        int n2 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n2 > n) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String stripFilenameExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        int n2 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n2 > n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String applyRelativePath(String string, String string2) {
        int n = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n != -1) {
            String string3 = string.substring(0, n);
            if (!string2.startsWith(FOLDER_SEPARATOR)) {
                string3 = string3 + FOLDER_SEPARATOR;
            }
            return string3 + string2;
        }
        return string2;
    }

    public static String cleanPath(String string) {
        int n;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        String string2 = StringUtils.replace(string, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        if (string2.indexOf(46) == -1) {
            return string2;
        }
        int n2 = string2.indexOf(58);
        String string3 = "";
        if (n2 != -1) {
            string3 = string2.substring(0, n2 + 1);
            if (string3.contains(FOLDER_SEPARATOR)) {
                string3 = "";
            } else {
                string2 = string2.substring(n2 + 1);
            }
        }
        if (string2.startsWith(FOLDER_SEPARATOR)) {
            string3 = string3 + FOLDER_SEPARATOR;
            string2 = string2.substring(1);
        }
        String[] stringArray = StringUtils.delimitedListToStringArray(string2, FOLDER_SEPARATOR);
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        int n3 = 0;
        for (n = stringArray.length - 1; n >= 0; --n) {
            String string4 = stringArray[n];
            if (CURRENT_PATH.equals(string4)) continue;
            if (TOP_PATH.equals(string4)) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                --n3;
                continue;
            }
            arrayDeque.addFirst(string4);
        }
        if (stringArray.length == arrayDeque.size()) {
            return string3 + string2;
        }
        for (n = 0; n < n3; ++n) {
            arrayDeque.addFirst(TOP_PATH);
        }
        if (arrayDeque.size() == 1 && ((String)arrayDeque.getLast()).isEmpty() && !string3.endsWith(FOLDER_SEPARATOR)) {
            arrayDeque.addFirst(CURRENT_PATH);
        }
        return string3 + StringUtils.collectionToDelimitedString(arrayDeque, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String string, String string2) {
        return StringUtils.cleanPath(string).equals(StringUtils.cleanPath(string2));
    }

    public static String uriDecode(String string, Charset charset) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        Assert.notNull((Object)charset, "Charset must not be null");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (i + 2 < n) {
                    char c2 = string.charAt(i + 1);
                    char c3 = string.charAt(i + 2);
                    int n2 = Character.digit(c2, 16);
                    int n3 = Character.digit(c3, 16);
                    if (n2 == -1 || n3 == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + string.substring(i) + "\"");
                    }
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    i += 2;
                    bl = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + string.substring(i) + "\"");
            }
            byteArrayOutputStream.write(c);
        }
        return bl ? StreamUtils.copyToString(byteArrayOutputStream, charset) : string;
    }

    @Nullable
    public static Locale parseLocale(String string) {
        String[] stringArray = StringUtils.tokenizeLocaleSource(string);
        if (stringArray.length == 1) {
            StringUtils.validateLocalePart(string);
            Locale locale = Locale.forLanguageTag(string);
            if (locale.getLanguage().length() > 0) {
                return locale;
            }
        }
        return StringUtils.parseLocaleTokens(string, stringArray);
    }

    @Nullable
    public static Locale parseLocaleString(String string) {
        return StringUtils.parseLocaleTokens(string, StringUtils.tokenizeLocaleSource(string));
    }

    private static String[] tokenizeLocaleSource(String string) {
        return StringUtils.tokenizeToStringArray(string, "_ ", false, false);
    }

    @Nullable
    private static Locale parseLocaleTokens(String string, String[] stringArray) {
        int n;
        String string2 = stringArray.length > 0 ? stringArray[0] : "";
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        StringUtils.validateLocalePart(string2);
        StringUtils.validateLocalePart(string3);
        String string4 = "";
        if (stringArray.length > 2 && (string4 = StringUtils.trimLeadingWhitespace(string.substring(n = string.indexOf(string3, string2.length()) + string3.length()))).startsWith("_")) {
            string4 = StringUtils.trimLeadingCharacter(string4, '_');
        }
        if (string4.isEmpty() && string3.startsWith("#")) {
            string4 = string3;
            string3 = "";
        }
        return string2.length() > 0 ? new Locale(string2, string3, string4) : null;
    }

    private static void validateLocalePart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || c == '#' || Character.isLetterOrDigit(c)) continue;
            throw new IllegalArgumentException("Locale part \"" + string + "\" contains invalid characters");
        }
    }

    @Deprecated
    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static TimeZone parseTimeZoneString(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if ("GMT".equals(timeZone.getID()) && !string.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + string + "'");
        }
        return timeZone;
    }

    public static String[] toStringArray(@Nullable Collection<String> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String[] toStringArray(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? StringUtils.toStringArray(Collections.list(enumeration)) : EMPTY_STRING_ARRAY;
    }

    public static String[] addStringToArray(@Nullable String[] stringArray, String string) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    @Nullable
    public static String[] concatenateStringArrays(@Nullable String[] stringArray, @Nullable String[] stringArray2) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return stringArray2;
        }
        if (ObjectUtils.isEmpty(stringArray2)) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Deprecated
    @Nullable
    public static String[] mergeStringArrays(@Nullable String[] stringArray, @Nullable String[] stringArray2) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return stringArray2;
        }
        if (ObjectUtils.isEmpty(stringArray2)) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (String string : stringArray2) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] sortStringArray(String[] stringArray) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return stringArray;
        }
        Arrays.sort(stringArray);
        return stringArray;
    }

    public static String[] trimArrayElements(String[] stringArray) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringArray2[i] = string != null ? string.trim() : null;
        }
        return stringArray2;
    }

    public static String[] removeDuplicateStrings(String[] stringArray) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return stringArray;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        return StringUtils.toStringArray(linkedHashSet);
    }

    @Nullable
    public static String[] split(@Nullable String string, @Nullable String string2) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2)) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + string2.length());
        return new String[]{string3, string4};
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string) {
        return StringUtils.splitArrayElementsIntoProperties(stringArray, string, null);
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string, @Nullable String string2) {
        if (ObjectUtils.isEmpty(stringArray)) {
            return null;
        }
        Properties properties = new Properties();
        for (String string3 : stringArray) {
            String[] stringArray2;
            if (string2 != null) {
                string3 = StringUtils.deleteAny(string3, string2);
            }
            if ((stringArray2 = StringUtils.split(string3, string)) == null) continue;
            properties.setProperty(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return properties;
    }

    public static String[] tokenizeToStringArray(@Nullable String string, String string2) {
        return StringUtils.tokenizeToStringArray(string, string2, true, true);
    }

    public static String[] tokenizeToStringArray(@Nullable String string, String string2, boolean bl, boolean bl2) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (bl) {
                string3 = string3.trim();
            }
            if (bl2 && string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] delimitedListToStringArray(@Nullable String string, @Nullable String string2) {
        return StringUtils.delimitedListToStringArray(string, string2, null);
    }

    public static String[] delimitedListToStringArray(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (string2 == null) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.isEmpty()) {
            for (int i = 0; i < string.length(); ++i) {
                arrayList.add(StringUtils.deleteAny(string.substring(i, i + 1), string3));
            }
        } else {
            int n;
            int n2 = 0;
            while ((n = string.indexOf(string2, n2)) != -1) {
                arrayList.add(StringUtils.deleteAny(string.substring(n2, n), string3));
                n2 = n + string2.length();
            }
            if (string.length() > 0 && n2 <= string.length()) {
                arrayList.add(StringUtils.deleteAny(string.substring(n2), string3));
            }
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String string) {
        return StringUtils.delimitedListToStringArray(string, ",");
    }

    public static Set<String> commaDelimitedListToSet(@Nullable String string) {
        String[] stringArray = StringUtils.commaDelimitedListToStringArray(string);
        return new LinkedHashSet<String>(Arrays.asList(stringArray));
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> collection, String string, String string2, String string3) {
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append(string2).append(iterator2.next()).append(string3);
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> collection, String string) {
        return StringUtils.collectionToDelimitedString(collection, string, "", "");
    }

    public static String collectionToCommaDelimitedString(@Nullable Collection<?> collection) {
        return StringUtils.collectionToDelimitedString(collection, ",");
    }

    public static String arrayToDelimitedString(@Nullable Object[] objectArray, String string) {
        if (ObjectUtils.isEmpty(objectArray)) {
            return "";
        }
        if (objectArray.length == 1) {
            return ObjectUtils.nullSafeToString(objectArray[0]);
        }
        StringJoiner stringJoiner = new StringJoiner(string);
        for (Object object : objectArray) {
            stringJoiner.add(String.valueOf(object));
        }
        return stringJoiner.toString();
    }

    public static String arrayToCommaDelimitedString(@Nullable Object[] objectArray) {
        return StringUtils.arrayToDelimitedString(objectArray, ",");
    }
}

