/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;

public class StopWatch {
    private final String id;
    private boolean keepTaskList = true;
    private final List<TaskInfo> taskList = new LinkedList<TaskInfo>();
    private long startTimeNanos;
    @Nullable
    private String currentTaskName;
    @Nullable
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeNanos;

    public StopWatch() {
        this("");
    }

    public StopWatch(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean bl) {
        this.keepTaskList = bl;
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    public void start(String string) throws IllegalStateException {
        if (this.currentTaskName != null) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.currentTaskName = string;
        this.startTimeNanos = System.nanoTime();
    }

    public void stop() throws IllegalStateException {
        if (this.currentTaskName == null) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long l = System.nanoTime() - this.startTimeNanos;
        this.totalTimeNanos += l;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, l);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    @Nullable
    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeNanos() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeNanos();
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return StopWatch.nanosToMillis(this.totalTimeNanos);
    }

    public double getTotalTimeSeconds() {
        return StopWatch.nanosToSeconds(this.totalTimeNanos);
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.getId() + "': running time = " + this.getTotalTimeNanos() + " ns";
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder(this.shortSummary());
        stringBuilder.append('\n');
        if (!this.keepTaskList) {
            stringBuilder.append("No task info kept");
        } else {
            stringBuilder.append("---------------------------------------------\n");
            stringBuilder.append("ns         %     Task name\n");
            stringBuilder.append("---------------------------------------------\n");
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumIntegerDigits(9);
            numberFormat.setGroupingUsed(false);
            NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
            numberFormat2.setMinimumIntegerDigits(3);
            numberFormat2.setGroupingUsed(false);
            for (TaskInfo taskInfo : this.getTaskInfo()) {
                stringBuilder.append(numberFormat.format(taskInfo.getTimeNanos())).append("  ");
                stringBuilder.append(numberFormat2.format((double)taskInfo.getTimeNanos() / (double)this.getTotalTimeNanos())).append("  ");
                stringBuilder.append(taskInfo.getTaskName()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.shortSummary());
        if (this.keepTaskList) {
            for (TaskInfo taskInfo : this.getTaskInfo()) {
                stringBuilder.append("; [").append(taskInfo.getTaskName()).append("] took ").append(taskInfo.getTimeNanos()).append(" ns");
                long l = Math.round(100.0 * (double)taskInfo.getTimeNanos() / (double)this.getTotalTimeNanos());
                stringBuilder.append(" = ").append(l).append("%");
            }
        } else {
            stringBuilder.append("; no task info kept");
        }
        return stringBuilder.toString();
    }

    private static long nanosToMillis(long l) {
        return TimeUnit.NANOSECONDS.toMillis(l);
    }

    private static double nanosToSeconds(long l) {
        return (double)l / 1.0E9;
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeNanos;

        TaskInfo(String string, long l) {
            this.taskName = string;
            this.timeNanos = l;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeNanos() {
            return this.timeNanos;
        }

        public long getTimeMillis() {
            return StopWatch.nanosToMillis(this.timeNanos);
        }

        public double getTimeSeconds() {
            return StopWatch.nanosToSeconds(this.timeNanos);
        }
    }
}

