/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayOutputStream;
import org.springframework.util.Assert;

public class ResizableByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;

    public ResizableByteArrayOutputStream() {
        super(256);
    }

    public ResizableByteArrayOutputStream(int n) {
        super(n);
    }

    public synchronized void resize(int n) {
        Assert.isTrue(n >= this.count, "New capacity must not be smaller than current size");
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = byArray;
    }

    public synchronized void grow(int n) {
        Assert.isTrue(n >= 0, "Additional capacity must be 0 or higher");
        if (this.count + n > this.buf.length) {
            int n2 = Math.max(this.buf.length * 2, this.count + n);
            this.resize(n2);
        }
    }

    public synchronized int capacity() {
        return this.buf.length;
    }
}

