/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertyPlaceholderHelper {
    private static final Log logger = LogFactory.getLog(PropertyPlaceholderHelper.class);
    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    @Nullable
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    public PropertyPlaceholderHelper(String string, String string2) {
        this(string, string2, null, true);
    }

    public PropertyPlaceholderHelper(String string, String string2, @Nullable String string3, boolean bl) {
        Assert.notNull((Object)string, "'placeholderPrefix' must not be null");
        Assert.notNull((Object)string2, "'placeholderSuffix' must not be null");
        this.placeholderPrefix = string;
        this.placeholderSuffix = string2;
        String string4 = wellKnownSimplePrefixes.get(this.placeholderSuffix);
        this.simplePrefix = string4 != null && this.placeholderPrefix.endsWith(string4) ? string4 : this.placeholderPrefix;
        this.valueSeparator = string3;
        this.ignoreUnresolvablePlaceholders = bl;
    }

    public String replacePlaceholders(String string, Properties properties) {
        Assert.notNull((Object)properties, "'properties' must not be null");
        return this.replacePlaceholders(string, properties::getProperty);
    }

    public String replacePlaceholders(String string, PlaceholderResolver placeholderResolver) {
        Assert.notNull((Object)string, "'value' must not be null");
        return this.parseStringValue(string, placeholderResolver, null);
    }

    protected String parseStringValue(String string, PlaceholderResolver placeholderResolver, @Nullable Set<String> set) {
        int n = string.indexOf(this.placeholderPrefix);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (n != -1) {
            int n2 = this.findPlaceholderEndIndex(stringBuilder, n);
            if (n2 != -1) {
                int n3;
                String string2;
                String string3 = string2 = stringBuilder.substring(n + this.placeholderPrefix.length(), n2);
                if (set == null) {
                    set = new HashSet<String>(4);
                }
                if (!set.add(string3)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + string3 + "' in property definitions");
                }
                String string4 = placeholderResolver.resolvePlaceholder(string2 = this.parseStringValue(string2, placeholderResolver, set));
                if (string4 == null && this.valueSeparator != null && (n3 = string2.indexOf(this.valueSeparator)) != -1) {
                    String string5 = string2.substring(0, n3);
                    String string6 = string2.substring(n3 + this.valueSeparator.length());
                    string4 = placeholderResolver.resolvePlaceholder(string5);
                    if (string4 == null) {
                        string4 = string6;
                    }
                }
                if (string4 != null) {
                    string4 = this.parseStringValue(string4, placeholderResolver, set);
                    stringBuilder.replace(n, n2 + this.placeholderSuffix.length(), string4);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Resolved placeholder '" + string2 + "'");
                    }
                    n = stringBuilder.indexOf(this.placeholderPrefix, n + string4.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    n = stringBuilder.indexOf(this.placeholderPrefix, n2 + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + string2 + "' in value \"" + string + "\"");
                }
                set.remove(string3);
                continue;
            }
            n = -1;
        }
        return stringBuilder.toString();
    }

    private int findPlaceholderEndIndex(CharSequence charSequence, int n) {
        int n2 = n + this.placeholderPrefix.length();
        int n3 = 0;
        while (n2 < charSequence.length()) {
            if (StringUtils.substringMatch(charSequence, n2, this.placeholderSuffix)) {
                if (n3 > 0) {
                    --n3;
                    n2 += this.placeholderSuffix.length();
                    continue;
                }
                return n2;
            }
            if (StringUtils.substringMatch(charSequence, n2, this.simplePrefix)) {
                ++n3;
                n2 += this.simplePrefix.length();
                continue;
            }
            ++n2;
        }
        return -1;
    }

    static {
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
    }

    @FunctionalInterface
    public static interface PlaceholderResolver {
        @Nullable
        public String resolvePlaceholder(String var1);
    }
}

