/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File file, File file2) throws IOException {
        Assert.notNull((Object)file, "No input File specified");
        Assert.notNull((Object)file2, "No output File specified");
        return FileCopyUtils.copy(Files.newInputStream(file.toPath(), new OpenOption[0]), Files.newOutputStream(file2.toPath(), new OpenOption[0]));
    }

    public static void copy(byte[] byArray, File file) throws IOException {
        Assert.notNull((Object)byArray, "No input byte array specified");
        Assert.notNull((Object)file, "No output File specified");
        FileCopyUtils.copy(new ByteArrayInputStream(byArray), Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }

    public static byte[] copyToByteArray(File file) throws IOException {
        Assert.notNull((Object)file, "No input File specified");
        return FileCopyUtils.copyToByteArray(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static int copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        Assert.notNull((Object)inputStream2, "No InputStream specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        try {
            int n = StreamUtils.copy(inputStream2, outputStream2);
            return n;
        }
        finally {
            FileCopyUtils.close(inputStream2);
            FileCopyUtils.close(outputStream2);
        }
    }

    public static void copy(byte[] byArray, OutputStream outputStream2) throws IOException {
        Assert.notNull((Object)byArray, "No input byte array specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        try {
            outputStream2.write(byArray);
        }
        finally {
            FileCopyUtils.close(outputStream2);
        }
    }

    public static byte[] copyToByteArray(@Nullable InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(inputStream2, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        Assert.notNull((Object)reader, "No Reader specified");
        Assert.notNull((Object)writer, "No Writer specified");
        try {
            int n;
            int n2 = 0;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n);
                n2 += n;
            }
            writer.flush();
            int n3 = n2;
            return n3;
        }
        finally {
            FileCopyUtils.close(reader);
            FileCopyUtils.close(writer);
        }
    }

    public static void copy(String string, Writer writer) throws IOException {
        Assert.notNull((Object)string, "No input String specified");
        Assert.notNull((Object)writer, "No Writer specified");
        try {
            writer.write(string);
        }
        finally {
            FileCopyUtils.close(writer);
        }
    }

    public static String copyToString(@Nullable Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(4096);
        FileCopyUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

