/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.UpdateMessageDigestInputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 256;
    private final Deque<byte[]> buffers = new ArrayDeque<byte[]>();
    private final int initialBlockSize;
    private int nextBlockSize = 0;
    private int alreadyBufferedSize = 0;
    private int index = 0;
    private boolean closed = false;

    public FastByteArrayOutputStream() {
        this(256);
    }

    public FastByteArrayOutputStream(int n) {
        Assert.isTrue(n > 0, "Initial block size must be greater than 0");
        this.initialBlockSize = n;
        this.nextBlockSize = n;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(1);
        }
        this.buffers.getLast()[this.index++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n + n2 > byArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(n2);
        }
        if (this.index + n2 > this.buffers.getLast().length) {
            int n3;
            int n4 = n;
            do {
                if (this.index == this.buffers.getLast().length) {
                    this.addBuffer(n2);
                }
                if (n2 < (n3 = this.buffers.getLast().length - this.index)) {
                    n3 = n2;
                }
                System.arraycopy(byArray, n4, this.buffers.getLast(), this.index, n3);
                n4 += n3;
                this.index += n3;
            } while ((n2 -= n3) > 0);
        } else {
            System.arraycopy(byArray, n, this.buffers.getLast(), this.index, n2);
            this.index += n2;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return new String(this.toByteArrayUnsafe());
    }

    public int size() {
        return this.alreadyBufferedSize + this.index;
    }

    public byte[] toByteArrayUnsafe() {
        int n = this.size();
        if (n == 0) {
            return new byte[0];
        }
        this.resize(n);
        return this.buffers.getFirst();
    }

    public byte[] toByteArray() {
        byte[] byArray = this.toByteArrayUnsafe();
        return (byte[])byArray.clone();
    }

    public void reset() {
        this.buffers.clear();
        this.nextBlockSize = this.initialBlockSize;
        this.closed = false;
        this.index = 0;
        this.alreadyBufferedSize = 0;
    }

    public InputStream getInputStream() {
        return new FastByteArrayInputStream(this);
    }

    public void writeTo(OutputStream outputStream2) throws IOException {
        Iterator<byte[]> iterator2 = this.buffers.iterator();
        while (iterator2.hasNext()) {
            byte[] byArray = iterator2.next();
            if (iterator2.hasNext()) {
                outputStream2.write(byArray, 0, byArray.length);
                continue;
            }
            outputStream2.write(byArray, 0, this.index);
        }
    }

    public void resize(int n) {
        Assert.isTrue(n >= this.size(), "New capacity must not be smaller than current size");
        if (this.buffers.peekFirst() == null) {
            this.nextBlockSize = n - this.size();
        } else if (this.size() != n || this.buffers.getFirst().length != n) {
            int n2 = this.size();
            byte[] byArray = new byte[n];
            int n3 = 0;
            Iterator<byte[]> iterator2 = this.buffers.iterator();
            while (iterator2.hasNext()) {
                byte[] byArray2 = iterator2.next();
                if (iterator2.hasNext()) {
                    System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                    n3 += byArray2.length;
                    continue;
                }
                System.arraycopy(byArray2, 0, byArray, n3, this.index);
            }
            this.buffers.clear();
            this.buffers.add(byArray);
            this.index = n2;
            this.alreadyBufferedSize = 0;
        }
    }

    private void addBuffer(int n) {
        if (this.buffers.peekLast() != null) {
            this.alreadyBufferedSize += this.index;
            this.index = 0;
        }
        if (this.nextBlockSize < n) {
            this.nextBlockSize = FastByteArrayOutputStream.nextPowerOf2(n);
        }
        this.buffers.add(new byte[this.nextBlockSize]);
        this.nextBlockSize *= 2;
    }

    private static int nextPowerOf2(int n) {
        --n;
        n = n >> 1 | n;
        n = n >> 2 | n;
        n = n >> 4 | n;
        n = n >> 8 | n;
        n = n >> 16 | n;
        return ++n;
    }

    private static final class FastByteArrayInputStream
    extends UpdateMessageDigestInputStream {
        private final FastByteArrayOutputStream fastByteArrayOutputStream;
        private final Iterator<byte[]> buffersIterator;
        @Nullable
        private byte[] currentBuffer;
        private int currentBufferLength = 0;
        private int nextIndexInCurrentBuffer = 0;
        private int totalBytesRead = 0;

        public FastByteArrayInputStream(FastByteArrayOutputStream fastByteArrayOutputStream) {
            this.fastByteArrayOutputStream = fastByteArrayOutputStream;
            this.buffersIterator = fastByteArrayOutputStream.buffers.iterator();
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.currentBufferLength = this.currentBuffer == fastByteArrayOutputStream.buffers.getLast() ? fastByteArrayOutputStream.index : (this.currentBuffer != null ? this.currentBuffer.length : 0);
            }
        }

        @Override
        public int read() {
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                ++this.totalBytesRead;
                return this.currentBuffer[this.nextIndexInCurrentBuffer++] & 0xFF;
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.read();
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.currentBuffer == null) {
                return -1;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int n3 = Math.min(n2, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                System.arraycopy(this.currentBuffer, this.nextIndexInCurrentBuffer, byArray, n, n3);
                this.totalBytesRead += n3;
                this.nextIndexInCurrentBuffer += n3;
                int n4 = this.read(byArray, n + n3, n2 - n3);
                return n3 + Math.max(n4, 0);
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("n exceeds maximum (2147483647): " + l);
            }
            if (l == 0L) {
                return 0L;
            }
            if (l < 0L) {
                throw new IllegalArgumentException("n must be 0 or greater: " + l);
            }
            int n = (int)l;
            if (this.currentBuffer == null) {
                return 0L;
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int n2 = Math.min(n, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                this.totalBytesRead += n2;
                this.nextIndexInCurrentBuffer += n2;
                return (long)n2 + this.skip(n - n2);
            }
            if (this.buffersIterator.hasNext()) {
                this.currentBuffer = this.buffersIterator.next();
                this.updateCurrentBufferLength();
                this.nextIndexInCurrentBuffer = 0;
            } else {
                this.currentBuffer = null;
            }
            return this.skip(n);
        }

        @Override
        public int available() {
            return this.fastByteArrayOutputStream.size() - this.totalBytesRead;
        }

        @Override
        public void updateMessageDigest(MessageDigest messageDigest) {
            this.updateMessageDigest(messageDigest, this.available());
        }

        @Override
        public void updateMessageDigest(MessageDigest messageDigest, int n) {
            if (this.currentBuffer == null) {
                return;
            }
            if (n == 0) {
                return;
            }
            if (n < 0) {
                throw new IllegalArgumentException("len must be 0 or greater: " + n);
            }
            if (this.nextIndexInCurrentBuffer < this.currentBufferLength) {
                int n2 = Math.min(n, this.currentBufferLength - this.nextIndexInCurrentBuffer);
                messageDigest.update(this.currentBuffer, this.nextIndexInCurrentBuffer, n2);
                this.nextIndexInCurrentBuffer += n2;
                this.updateMessageDigest(messageDigest, n - n2);
            } else {
                if (this.buffersIterator.hasNext()) {
                    this.currentBuffer = this.buffersIterator.next();
                    this.updateCurrentBufferLength();
                    this.nextIndexInCurrentBuffer = 0;
                } else {
                    this.currentBuffer = null;
                }
                this.updateMessageDigest(messageDigest, n);
            }
        }

        private void updateCurrentBufferLength() {
            this.currentBufferLength = this.currentBuffer == this.fastByteArrayOutputStream.buffers.getLast() ? this.fastByteArrayOutputStream.index : (this.currentBuffer != null ? this.currentBuffer.length : 0);
        }
    }
}

