/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.util.UpdateMessageDigestInputStream;

public abstract class DigestUtils {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] md5Digest(byte[] byArray) {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, byArray);
    }

    public static byte[] md5Digest(InputStream inputStream2) throws IOException {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, inputStream2);
    }

    public static String md5DigestAsHex(byte[] byArray) {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, byArray);
    }

    public static String md5DigestAsHex(InputStream inputStream2) throws IOException {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, inputStream2);
    }

    public static StringBuilder appendMd5DigestAsHex(byte[] byArray, StringBuilder stringBuilder) {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, byArray, stringBuilder);
    }

    public static StringBuilder appendMd5DigestAsHex(InputStream inputStream2, StringBuilder stringBuilder) throws IOException {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, inputStream2, stringBuilder);
    }

    private static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + string + "\"", noSuchAlgorithmException);
        }
    }

    private static byte[] digest(String string, byte[] byArray) {
        return DigestUtils.getDigest(string).digest(byArray);
    }

    private static byte[] digest(String string, InputStream inputStream2) throws IOException {
        MessageDigest messageDigest = DigestUtils.getDigest(string);
        if (inputStream2 instanceof UpdateMessageDigestInputStream) {
            ((UpdateMessageDigestInputStream)inputStream2).updateMessageDigest(messageDigest);
            return messageDigest.digest();
        }
        byte[] byArray = new byte[4096];
        int n = -1;
        while ((n = inputStream2.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    private static String digestAsHexString(String string, byte[] byArray) {
        char[] cArray = DigestUtils.digestAsHexChars(string, byArray);
        return new String(cArray);
    }

    private static String digestAsHexString(String string, InputStream inputStream2) throws IOException {
        char[] cArray = DigestUtils.digestAsHexChars(string, inputStream2);
        return new String(cArray);
    }

    private static StringBuilder appendDigestAsHex(String string, byte[] byArray, StringBuilder stringBuilder) {
        char[] cArray = DigestUtils.digestAsHexChars(string, byArray);
        return stringBuilder.append(cArray);
    }

    private static StringBuilder appendDigestAsHex(String string, InputStream inputStream2, StringBuilder stringBuilder) throws IOException {
        char[] cArray = DigestUtils.digestAsHexChars(string, inputStream2);
        return stringBuilder.append(cArray);
    }

    private static char[] digestAsHexChars(String string, byte[] byArray) {
        byte[] byArray2 = DigestUtils.digest(string, byArray);
        return DigestUtils.encodeHex(byArray2);
    }

    private static char[] digestAsHexChars(String string, InputStream inputStream2) throws IOException {
        byte[] byArray = DigestUtils.digest(string, inputStream2);
        return DigestUtils.encodeHex(byArray);
    }

    private static char[] encodeHex(byte[] byArray) {
        char[] cArray = new char[32];
        for (int i = 0; i < cArray.length; i += 2) {
            byte by = byArray[i / 2];
            cArray[i] = HEX_CHARS[by >>> 4 & 0xF];
            cArray[i + 1] = HEX_CHARS[by & 0xF];
        }
        return cArray;
    }
}

