/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public abstract class Base64Utils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return Base64.getEncoder().encode(byArray);
    }

    public static byte[] decode(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return Base64.getDecoder().decode(byArray);
    }

    public static byte[] encodeUrlSafe(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return Base64.getUrlEncoder().encode(byArray);
    }

    public static byte[] decodeUrlSafe(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return Base64.getUrlDecoder().decode(byArray);
    }

    public static String encodeToString(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        return new String(Base64Utils.encode(byArray), DEFAULT_CHARSET);
    }

    public static byte[] decodeFromString(String string) {
        if (string.isEmpty()) {
            return new byte[0];
        }
        return Base64Utils.decode(string.getBytes(DEFAULT_CHARSET));
    }

    public static String encodeToUrlSafeString(byte[] byArray) {
        return new String(Base64Utils.encodeUrlSafe(byArray), DEFAULT_CHARSET);
    }

    public static byte[] decodeFromUrlSafeString(String string) {
        return Base64Utils.decodeUrlSafe(string.getBytes(DEFAULT_CHARSET));
    }
}

