/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.classreading.MergedAnnotationReadingVisitor;
import org.springframework.core.type.classreading.SimpleMethodMetadata;
import org.springframework.lang.Nullable;

final class SimpleMethodMetadataReadingVisitor
extends MethodVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private final String declaringClassName;
    private final int access;
    private final String name;
    private final String descriptor;
    private final List<MergedAnnotation<?>> annotations = new ArrayList(4);
    private final Consumer<SimpleMethodMetadata> consumer;
    @Nullable
    private Source source;

    SimpleMethodMetadataReadingVisitor(@Nullable ClassLoader classLoader, String string, int n, String string2, String string3, Consumer<SimpleMethodMetadata> consumer) {
        super(0x1080000);
        this.classLoader = classLoader;
        this.declaringClassName = string;
        this.access = n;
        this.name = string2;
        this.descriptor = string3;
        this.consumer = consumer;
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return MergedAnnotationReadingVisitor.get(this.classLoader, this::getSource, string, bl, this.annotations::add);
    }

    @Override
    public void visitEnd() {
        if (!this.annotations.isEmpty()) {
            String string = Type.getReturnType(this.descriptor).getClassName();
            MergedAnnotations mergedAnnotations = MergedAnnotations.of(this.annotations);
            SimpleMethodMetadata simpleMethodMetadata = new SimpleMethodMetadata(this.name, this.access, this.declaringClassName, string, mergedAnnotations);
            this.consumer.accept(simpleMethodMetadata);
        }
    }

    private Object getSource() {
        Source source2 = this.source;
        if (source2 == null) {
            this.source = source2 = new Source(this.declaringClassName, this.name, this.descriptor);
        }
        return source2;
    }

    static final class Source {
        private final String declaringClassName;
        private final String name;
        private final String descriptor;
        @Nullable
        private String toStringValue;

        Source(String string, String string2, String string3) {
            this.declaringClassName = string;
            this.name = string2;
            this.descriptor = string3;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.declaringClassName.hashCode();
            n = 31 * n + this.name.hashCode();
            n = 31 * n + this.descriptor.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Source source2 = (Source)object;
            return this.declaringClassName.equals(source2.declaringClassName) && this.name.equals(source2.name) && this.descriptor.equals(source2.descriptor);
        }

        public String toString() {
            String string = this.toStringValue;
            if (string == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.declaringClassName);
                stringBuilder.append('.');
                stringBuilder.append(this.name);
                Type[] typeArray = Type.getArgumentTypes(this.descriptor);
                stringBuilder.append('(');
                for (int i = 0; i < typeArray.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(typeArray[i].getClassName());
                }
                stringBuilder.append(')');
                this.toStringValue = string = stringBuilder.toString();
            }
            return string;
        }
    }
}

