/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MergedAnnotationReadingVisitor;
import org.springframework.core.type.classreading.SimpleAnnotationMetadata;
import org.springframework.core.type.classreading.SimpleMethodMetadata;
import org.springframework.core.type.classreading.SimpleMethodMetadataReadingVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class SimpleAnnotationMetadataReadingVisitor
extends ClassVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private String className = "";
    private int access;
    @Nullable
    private String superClassName;
    private String[] interfaceNames = new String[0];
    @Nullable
    private String enclosingClassName;
    private boolean independentInnerClass;
    private Set<String> memberClassNames = new LinkedHashSet<String>(4);
    private List<MergedAnnotation<?>> annotations = new ArrayList();
    private List<SimpleMethodMetadata> annotatedMethods = new ArrayList<SimpleMethodMetadata>();
    @Nullable
    private SimpleAnnotationMetadata metadata;
    @Nullable
    private Source source;

    SimpleAnnotationMetadataReadingVisitor(@Nullable ClassLoader classLoader) {
        super(0x1080000);
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, @Nullable String string3, String[] stringArray) {
        this.className = this.toClassName(string);
        this.access = n2;
        if (string3 != null && !this.isInterface(n2)) {
            this.superClassName = this.toClassName(string3);
        }
        this.interfaceNames = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.interfaceNames[i] = this.toClassName(stringArray[i]);
        }
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.enclosingClassName = this.toClassName(string);
    }

    @Override
    public void visitInnerClass(String string, @Nullable String string2, String string3, int n) {
        if (string2 != null) {
            String string4 = this.toClassName(string);
            String string5 = this.toClassName(string2);
            if (this.className.equals(string4)) {
                this.enclosingClassName = string5;
                this.independentInnerClass = (n & 8) != 0;
            } else if (this.className.equals(string5)) {
                this.memberClassNames.add(string4);
            }
        }
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return MergedAnnotationReadingVisitor.get(this.classLoader, this::getSource, string, bl, this.annotations::add);
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (this.isBridge(n)) {
            return null;
        }
        return new SimpleMethodMetadataReadingVisitor(this.classLoader, this.className, n, string, string2, this.annotatedMethods::add);
    }

    @Override
    public void visitEnd() {
        String[] stringArray = StringUtils.toStringArray(this.memberClassNames);
        MethodMetadata[] methodMetadataArray = this.annotatedMethods.toArray(new MethodMetadata[0]);
        MergedAnnotations mergedAnnotations = MergedAnnotations.of(this.annotations);
        this.metadata = new SimpleAnnotationMetadata(this.className, this.access, this.enclosingClassName, this.superClassName, this.independentInnerClass, this.interfaceNames, stringArray, methodMetadataArray, mergedAnnotations);
    }

    public SimpleAnnotationMetadata getMetadata() {
        Assert.state(this.metadata != null, "AnnotationMetadata not initialized");
        return this.metadata;
    }

    private Source getSource() {
        Source source2 = this.source;
        if (source2 == null) {
            this.source = source2 = new Source(this.className);
        }
        return source2;
    }

    private String toClassName(String string) {
        return ClassUtils.convertResourcePathToClassName(string);
    }

    private boolean isBridge(int n) {
        return (n & 0x40) != 0;
    }

    private boolean isInterface(int n) {
        return (n & 0x200) != 0;
    }

    private static final class Source {
        private final String className;

        Source(String string) {
            this.className = string;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.className.equals(((Source)object).className);
        }

        public String toString() {
            return this.className;
        }
    }
}

