/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;

final class SimpleAnnotationMetadata
implements AnnotationMetadata {
    private final String className;
    private final int access;
    @Nullable
    private final String enclosingClassName;
    @Nullable
    private final String superClassName;
    private final boolean independentInnerClass;
    private final String[] interfaceNames;
    private final String[] memberClassNames;
    private final MethodMetadata[] annotatedMethods;
    private final MergedAnnotations annotations;
    @Nullable
    private Set<String> annotationTypes;

    SimpleAnnotationMetadata(String string, int n, @Nullable String string2, @Nullable String string3, boolean bl, String[] stringArray, String[] stringArray2, MethodMetadata[] methodMetadataArray, MergedAnnotations mergedAnnotations) {
        this.className = string;
        this.access = n;
        this.enclosingClassName = string2;
        this.superClassName = string3;
        this.independentInnerClass = bl;
        this.interfaceNames = stringArray;
        this.memberClassNames = stringArray2;
        this.annotatedMethods = methodMetadataArray;
        this.annotations = mergedAnnotations;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    @Nullable
    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    @Nullable
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return (String[])this.interfaceNames.clone();
    }

    @Override
    public String[] getMemberClassNames() {
        return (String[])this.memberClassNames.clone();
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> set = this.annotationTypes;
        if (set == null) {
            this.annotationTypes = set = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return set;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String string) {
        Set<MethodMetadata> set = null;
        for (MethodMetadata methodMetadata : this.annotatedMethods) {
            if (!methodMetadata.isAnnotated(string)) continue;
            if (set == null) {
                set = new LinkedHashSet<MethodMetadata>(4);
            }
            set.add(methodMetadata);
        }
        return set != null ? set : Collections.emptySet();
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }
}

