/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import org.springframework.core.type.ClassMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StandardClassMetadata
implements ClassMetadata {
    private final Class<?> introspectedClass;

    @Deprecated
    public StandardClassMetadata(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        this.introspectedClass = clazz;
    }

    public final Class<?> getIntrospectedClass() {
        return this.introspectedClass;
    }

    @Override
    public String getClassName() {
        return this.introspectedClass.getName();
    }

    @Override
    public boolean isInterface() {
        return this.introspectedClass.isInterface();
    }

    @Override
    public boolean isAnnotation() {
        return this.introspectedClass.isAnnotation();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.introspectedClass.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedClass.getModifiers());
    }

    @Override
    public boolean isIndependent() {
        return !this.hasEnclosingClass() || this.introspectedClass.getDeclaringClass() != null && Modifier.isStatic(this.introspectedClass.getModifiers());
    }

    @Override
    @Nullable
    public String getEnclosingClassName() {
        Class<?> clazz = this.introspectedClass.getEnclosingClass();
        return clazz != null ? clazz.getName() : null;
    }

    @Override
    @Nullable
    public String getSuperClassName() {
        Class<?> clazz = this.introspectedClass.getSuperclass();
        return clazz != null ? clazz.getName() : null;
    }

    @Override
    public String[] getInterfaceNames() {
        Class<?>[] classArray = this.introspectedClass.getInterfaces();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    @Override
    public String[] getMemberClassNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(4);
        for (Class<?> clazz : this.introspectedClass.getDeclaredClasses()) {
            linkedHashSet.add(clazz.getName());
        }
        return StringUtils.toStringArray(linkedHashSet);
    }
}

