/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final MergedAnnotations mergedAnnotations;
    private final boolean nestedAnnotationsAsMap;
    @Nullable
    private Set<String> annotationTypes;

    @Deprecated
    public StandardAnnotationMetadata(Class<?> clazz) {
        this(clazz, false);
    }

    @Deprecated
    public StandardAnnotationMetadata(Class<?> clazz, boolean bl) {
        super(clazz);
        this.mergedAnnotations = MergedAnnotations.from(clazz, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none());
        this.nestedAnnotationsAsMap = bl;
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> set = this.annotationTypes;
        if (set == null) {
            this.annotationTypes = set = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return set;
    }

    @Override
    @Nullable
    public Map<String, Object> getAnnotationAttributes(String string, boolean bl) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAnnotationAttributes(string, bl);
        }
        return AnnotatedElementUtils.getMergedAnnotationAttributes(this.getIntrospectedClass(), string, bl, false);
    }

    @Override
    @Nullable
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String string, boolean bl) {
        if (this.nestedAnnotationsAsMap) {
            return AnnotationMetadata.super.getAllAnnotationAttributes(string, bl);
        }
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.getIntrospectedClass(), string, bl, false);
    }

    @Override
    public boolean hasAnnotatedMethods(String string) {
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), string)) {
            try {
                Method[] methodArray;
                for (Method method : methodArray = ReflectionUtils.getDeclaredMethods(this.getIntrospectedClass())) {
                    if (!this.isAnnotatedMethod(method, string)) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect annotated methods on " + this.getIntrospectedClass(), throwable);
            }
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String string) {
        Set<MethodMetadata> set = null;
        if (AnnotationUtils.isCandidateClass(this.getIntrospectedClass(), string)) {
            try {
                Method[] methodArray;
                for (Method method : methodArray = ReflectionUtils.getDeclaredMethods(this.getIntrospectedClass())) {
                    if (!this.isAnnotatedMethod(method, string)) continue;
                    if (set == null) {
                        set = new LinkedHashSet<MethodMetadata>(4);
                    }
                    set.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
                }
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect annotated methods on " + this.getIntrospectedClass(), throwable);
            }
        }
        return set != null ? set : Collections.emptySet();
    }

    private boolean isAnnotatedMethod(Method method, String string) {
        return !method.isBridge() && method.getAnnotations().length > 0 && AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, string);
    }

    static AnnotationMetadata from(Class<?> clazz) {
        return new StandardAnnotationMetadata(clazz, true);
    }
}

