/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[[empty]]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String EMPTY_MAP = "map[[empty]]";
    private static final String ARRAY = "array";

    @Override
    public String style(@Nullable Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof Class) {
            return ClassUtils.getShortName((Class)object);
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
        }
        if (object instanceof Map) {
            return this.style((Map)object);
        }
        if (object instanceof Map.Entry) {
            return this.style((Map.Entry)object);
        }
        if (object instanceof Collection) {
            return this.style((Collection)object);
        }
        if (object.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(object));
        }
        return String.valueOf(object);
    }

    private <K, V> String style(Map<K, V> map) {
        if (map.isEmpty()) {
            return EMPTY_MAP;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            stringJoiner.add(this.style(entry));
        }
        return MAP + stringJoiner;
    }

    private String style(Map.Entry<?, ?> entry) {
        return this.style(entry.getKey()) + " -> " + this.style(entry.getValue());
    }

    private String style(Collection<?> collection) {
        String string = this.getCollectionTypeString(collection);
        if (collection.isEmpty()) {
            return string + EMPTY;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (Object obj : collection) {
            stringJoiner.add(this.style(obj));
        }
        return string + stringJoiner;
    }

    private String getCollectionTypeString(Collection<?> collection) {
        if (collection instanceof List) {
            return LIST;
        }
        if (collection instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    private String styleArray(Object[] objectArray) {
        if (objectArray.length == 0) {
            return "array<" + ClassUtils.getShortName(objectArray.getClass().getComponentType()) + '>' + EMPTY;
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (Object object : objectArray) {
            stringJoiner.add(this.style(object));
        }
        return "array<" + ClassUtils.getShortName(objectArray.getClass().getComponentType()) + '>' + stringJoiner;
    }
}

