/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.nio.ByteBuffer;
import java.util.List;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.util.Assert;

public class DefaultDataBufferFactory
implements DataBufferFactory {
    public static final int DEFAULT_INITIAL_CAPACITY = 256;
    private final boolean preferDirect;
    private final int defaultInitialCapacity;

    public DefaultDataBufferFactory() {
        this(false);
    }

    public DefaultDataBufferFactory(boolean bl) {
        this(bl, 256);
    }

    public DefaultDataBufferFactory(boolean bl, int n) {
        Assert.isTrue(n > 0, "'defaultInitialCapacity' should be larger than 0");
        this.preferDirect = bl;
        this.defaultInitialCapacity = n;
    }

    @Override
    public DefaultDataBuffer allocateBuffer() {
        return this.allocateBuffer(this.defaultInitialCapacity);
    }

    @Override
    public DefaultDataBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = this.preferDirect ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        return DefaultDataBuffer.fromEmptyByteBuffer(this, byteBuffer);
    }

    @Override
    public DefaultDataBuffer wrap(ByteBuffer byteBuffer) {
        return DefaultDataBuffer.fromFilledByteBuffer(this, byteBuffer.slice());
    }

    @Override
    public DefaultDataBuffer wrap(byte[] byArray) {
        return DefaultDataBuffer.fromFilledByteBuffer(this, ByteBuffer.wrap(byArray));
    }

    @Override
    public DefaultDataBuffer join(List<? extends DataBuffer> list) {
        Assert.notEmpty(list, "DataBuffer List must not be empty");
        int n = list.stream().mapToInt(DataBuffer::readableByteCount).sum();
        DefaultDataBuffer defaultDataBuffer = this.allocateBuffer(n);
        list.forEach(dataBuffer -> defaultDataBuffer.write((DataBuffer)dataBuffer));
        list.forEach(DataBufferUtils::release);
        return defaultDataBuffer;
    }

    public String toString() {
        return "DefaultDataBufferFactory (preferDirect=" + this.preferDirect + ")";
    }
}

