/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.IntPredicate;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DefaultDataBuffer
implements DataBuffer {
    private static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int CAPACITY_THRESHOLD = 0x400000;
    private final DefaultDataBufferFactory dataBufferFactory;
    private ByteBuffer byteBuffer;
    private int capacity;
    private int readPosition;
    private int writePosition;

    private DefaultDataBuffer(DefaultDataBufferFactory defaultDataBufferFactory, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        Assert.notNull((Object)defaultDataBufferFactory, "DefaultDataBufferFactory must not be null");
        Assert.notNull((Object)byteBuffer, "ByteBuffer must not be null");
        this.dataBufferFactory = defaultDataBufferFactory;
        this.byteBuffer = byteBuffer2 = byteBuffer.slice();
        this.capacity = byteBuffer2.remaining();
    }

    static DefaultDataBuffer fromFilledByteBuffer(DefaultDataBufferFactory defaultDataBufferFactory, ByteBuffer byteBuffer) {
        DefaultDataBuffer defaultDataBuffer = new DefaultDataBuffer(defaultDataBufferFactory, byteBuffer);
        defaultDataBuffer.writePosition(byteBuffer.remaining());
        return defaultDataBuffer;
    }

    static DefaultDataBuffer fromEmptyByteBuffer(DefaultDataBufferFactory defaultDataBufferFactory, ByteBuffer byteBuffer) {
        return new DefaultDataBuffer(defaultDataBufferFactory, byteBuffer);
    }

    public ByteBuffer getNativeBuffer() {
        this.byteBuffer.position(this.readPosition);
        this.byteBuffer.limit(this.readableByteCount());
        return this.byteBuffer;
    }

    private void setNativeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public DefaultDataBufferFactory factory() {
        return this.dataBufferFactory;
    }

    @Override
    public int indexOf(IntPredicate intPredicate, int n) {
        Assert.notNull((Object)intPredicate, "IntPredicate must not be null");
        if (n < 0) {
            n = 0;
        } else if (n >= this.writePosition) {
            return -1;
        }
        for (int i = n; i < this.writePosition; ++i) {
            byte by = this.byteBuffer.get(i);
            if (!intPredicate.test(by)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(IntPredicate intPredicate, int n) {
        Assert.notNull((Object)intPredicate, "IntPredicate must not be null");
        for (int i = Math.min(n, this.writePosition - 1); i >= 0; --i) {
            byte by = this.byteBuffer.get(i);
            if (!intPredicate.test(by)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int readableByteCount() {
        return this.writePosition - this.readPosition;
    }

    @Override
    public int writableByteCount() {
        return this.capacity - this.writePosition;
    }

    @Override
    public int readPosition() {
        return this.readPosition;
    }

    @Override
    public DefaultDataBuffer readPosition(int n) {
        this.assertIndex(n >= 0, "'readPosition' %d must be >= 0", n);
        this.assertIndex(n <= this.writePosition, "'readPosition' %d must be <= %d", n, this.writePosition);
        this.readPosition = n;
        return this;
    }

    @Override
    public int writePosition() {
        return this.writePosition;
    }

    @Override
    public DefaultDataBuffer writePosition(int n) {
        this.assertIndex(n >= this.readPosition, "'writePosition' %d must be >= %d", n, this.readPosition);
        this.assertIndex(n <= this.capacity, "'writePosition' %d must be <= %d", n, this.capacity);
        this.writePosition = n;
        return this;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public DefaultDataBuffer capacity(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.format("'newCapacity' %d must be higher than 0", n));
        }
        int n2 = this.readPosition();
        int n3 = this.writePosition();
        int n4 = this.capacity();
        if (n > n4) {
            ByteBuffer byteBuffer = this.byteBuffer;
            ByteBuffer byteBuffer2 = DefaultDataBuffer.allocate(n, byteBuffer.isDirect());
            byteBuffer.position(0).limit(byteBuffer.capacity());
            byteBuffer2.position(0).limit(byteBuffer.capacity());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.clear();
            this.setNativeBuffer(byteBuffer2);
        } else if (n < n4) {
            ByteBuffer byteBuffer = this.byteBuffer;
            ByteBuffer byteBuffer3 = DefaultDataBuffer.allocate(n, byteBuffer.isDirect());
            if (n2 < n) {
                if (n3 > n) {
                    n3 = n;
                    this.writePosition(n3);
                }
                byteBuffer.position(n2).limit(n3);
                byteBuffer3.position(n2).limit(n3);
                byteBuffer3.put(byteBuffer);
                byteBuffer3.clear();
            } else {
                this.readPosition(n);
                this.writePosition(n);
            }
            this.setNativeBuffer(byteBuffer3);
        }
        return this;
    }

    @Override
    public DataBuffer ensureCapacity(int n) {
        if (n > this.writableByteCount()) {
            int n2 = this.calculateCapacity(this.writePosition + n);
            this.capacity(n2);
        }
        return this;
    }

    private static ByteBuffer allocate(int n, boolean bl) {
        return bl ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
    }

    @Override
    public byte getByte(int n) {
        this.assertIndex(n >= 0, "index %d must be >= 0", n);
        this.assertIndex(n <= this.writePosition - 1, "index %d must be <= %d", n, this.writePosition - 1);
        return this.byteBuffer.get(n);
    }

    @Override
    public byte read() {
        this.assertIndex(this.readPosition <= this.writePosition - 1, "readPosition %d must be <= %d", this.readPosition, this.writePosition - 1);
        int n = this.readPosition;
        byte by = this.byteBuffer.get(n);
        this.readPosition = n + 1;
        return by;
    }

    @Override
    public DefaultDataBuffer read(byte[] byArray) {
        Assert.notNull((Object)byArray, "Byte array must not be null");
        this.read(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public DefaultDataBuffer read(byte[] byArray, int n, int n2) {
        Assert.notNull((Object)byArray, "Byte array must not be null");
        this.assertIndex(this.readPosition <= this.writePosition - n2, "readPosition %d and length %d should be smaller than writePosition %d", this.readPosition, n2, this.writePosition);
        ByteBuffer byteBuffer = this.byteBuffer.duplicate();
        int n3 = this.readPosition + n2;
        byteBuffer.clear().position(this.readPosition).limit(n3);
        byteBuffer.get(byArray, n, n2);
        this.readPosition += n2;
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte by) {
        this.ensureCapacity(1);
        int n = this.writePosition;
        this.byteBuffer.put(n, by);
        this.writePosition = n + 1;
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] byArray) {
        Assert.notNull((Object)byArray, "Byte array must not be null");
        this.write(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public DefaultDataBuffer write(byte[] byArray, int n, int n2) {
        Assert.notNull((Object)byArray, "Byte array must not be null");
        this.ensureCapacity(n2);
        ByteBuffer byteBuffer = this.byteBuffer.duplicate();
        int n3 = this.writePosition + n2;
        byteBuffer.clear().position(this.writePosition).limit(n3);
        byteBuffer.put(byArray, n, n2);
        this.writePosition += n2;
        return this;
    }

    @Override
    public DefaultDataBuffer write(DataBuffer ... dataBufferArray) {
        if (!ObjectUtils.isEmpty(dataBufferArray)) {
            this.write((ByteBuffer[])Arrays.stream(dataBufferArray).map(DataBuffer::asByteBuffer).toArray(ByteBuffer[]::new));
        }
        return this;
    }

    @Override
    public DefaultDataBuffer write(ByteBuffer ... byteBufferArray) {
        if (!ObjectUtils.isEmpty(byteBufferArray)) {
            int n = Arrays.stream(byteBufferArray).mapToInt(Buffer::remaining).sum();
            this.ensureCapacity(n);
            Arrays.stream(byteBufferArray).forEach(this::write);
        }
        return this;
    }

    private void write(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        ByteBuffer byteBuffer2 = this.byteBuffer.duplicate();
        int n2 = this.writePosition + byteBuffer.remaining();
        byteBuffer2.clear().position(this.writePosition).limit(n2);
        byteBuffer2.put(byteBuffer);
        this.writePosition += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultDataBuffer slice(int n, int n2) {
        this.checkIndex(n, n2);
        int n3 = this.byteBuffer.position();
        ByteBuffer byteBuffer = this.byteBuffer;
        try {
            ((Buffer)byteBuffer).position(n);
            ByteBuffer byteBuffer2 = this.byteBuffer.slice();
            byteBuffer2.limit(n2);
            SlicedDefaultDataBuffer slicedDefaultDataBuffer = new SlicedDefaultDataBuffer(byteBuffer2, this.dataBufferFactory, n2);
            return slicedDefaultDataBuffer;
        }
        finally {
            ((Buffer)byteBuffer).position(n3);
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.asByteBuffer(this.readPosition, this.readableByteCount());
    }

    @Override
    public ByteBuffer asByteBuffer(int n, int n2) {
        ByteBuffer byteBuffer;
        this.checkIndex(n, n2);
        ByteBuffer byteBuffer2 = byteBuffer = this.byteBuffer.duplicate();
        ((Buffer)byteBuffer2).position(n);
        ((Buffer)byteBuffer2).limit(n + n2);
        return byteBuffer.slice();
    }

    @Override
    public InputStream asInputStream() {
        return new DefaultDataBufferInputStream();
    }

    @Override
    public InputStream asInputStream(boolean bl) {
        return new DefaultDataBufferInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return new DefaultDataBufferOutputStream();
    }

    @Override
    public String toString(int n, int n2, Charset charset) {
        int n3;
        byte[] byArray;
        this.checkIndex(n, n2);
        Assert.notNull((Object)charset, "Charset must not be null");
        if (this.byteBuffer.hasArray()) {
            byArray = this.byteBuffer.array();
            n3 = this.byteBuffer.arrayOffset() + n;
        } else {
            byArray = new byte[n2];
            n3 = 0;
            ByteBuffer byteBuffer = this.byteBuffer.duplicate();
            byteBuffer.clear().position(n).limit(n + n2);
            byteBuffer.get(byArray, 0, n2);
        }
        return new String(byArray, n3, n2, charset);
    }

    private int calculateCapacity(int n) {
        int n2;
        Assert.isTrue(n >= 0, "'neededCapacity' must >= 0");
        if (n == 0x400000) {
            return 0x400000;
        }
        if (n > 0x400000) {
            int n3 = n / 0x400000 * 0x400000;
            n3 = n3 > 0x7FBFFFFF ? Integer.MAX_VALUE : (n3 += 0x400000);
            return n3;
        }
        for (n2 = 64; n2 < n; n2 <<= 1) {
        }
        return Math.min(n2, Integer.MAX_VALUE);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultDataBuffer)) {
            return false;
        }
        DefaultDataBuffer defaultDataBuffer = (DefaultDataBuffer)object;
        return this.readPosition == defaultDataBuffer.readPosition && this.writePosition == defaultDataBuffer.writePosition && this.byteBuffer.equals(defaultDataBuffer.byteBuffer);
    }

    public int hashCode() {
        return this.byteBuffer.hashCode();
    }

    public String toString() {
        return String.format("DefaultDataBuffer (r: %d, w: %d, c: %d)", this.readPosition, this.writePosition, this.capacity);
    }

    private void checkIndex(int n, int n2) {
        this.assertIndex(n >= 0, "index %d must be >= 0", n);
        this.assertIndex(n2 >= 0, "length %d must be >= 0", n2);
        this.assertIndex(n <= this.capacity, "index %d must be <= %d", n, this.capacity);
        this.assertIndex(n2 <= this.capacity, "length %d must be <= %d", n2, this.capacity);
    }

    private void assertIndex(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            String string2 = String.format(string, objectArray);
            throw new IndexOutOfBoundsException(string2);
        }
    }

    private static class SlicedDefaultDataBuffer
    extends DefaultDataBuffer {
        SlicedDefaultDataBuffer(ByteBuffer byteBuffer, DefaultDataBufferFactory defaultDataBufferFactory, int n) {
            super(defaultDataBufferFactory, byteBuffer);
            this.writePosition(n);
        }

        @Override
        public DefaultDataBuffer capacity(int n) {
            throw new UnsupportedOperationException("Changing the capacity of a sliced buffer is not supported");
        }
    }

    private class DefaultDataBufferOutputStream
    extends OutputStream {
        private DefaultDataBufferOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            DefaultDataBuffer.this.write((byte)n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            DefaultDataBuffer.this.write(byArray, n, n2);
        }
    }

    private class DefaultDataBufferInputStream
    extends InputStream {
        private DefaultDataBufferInputStream() {
        }

        @Override
        public int available() {
            return DefaultDataBuffer.this.readableByteCount();
        }

        @Override
        public int read() {
            return this.available() > 0 ? DefaultDataBuffer.this.read() & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.available();
            if (n3 > 0) {
                n2 = Math.min(n2, n3);
                DefaultDataBuffer.this.read(byArray, n, n2);
                return n2;
            }
            return -1;
        }
    }
}

