/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    @Nullable
    private ClassLoader classLoader;
    @Nullable
    private Class<?> clazz;

    public ClassPathResource(String string) {
        this(string, (ClassLoader)null);
    }

    public ClassPathResource(String string, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)string, "Path must not be null");
        String string2 = StringUtils.cleanPath(string);
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        this.path = string2;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String string, @Nullable Class<?> clazz) {
        Assert.notNull((Object)string, "Path must not be null");
        this.path = StringUtils.cleanPath(string);
        this.clazz = clazz;
    }

    @Deprecated
    protected ClassPathResource(String string, @Nullable ClassLoader classLoader, @Nullable Class<?> clazz) {
        this.path = StringUtils.cleanPath(string);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return this.clazz != null ? this.clazz.getClassLoader() : this.classLoader;
    }

    @Override
    public boolean exists() {
        return this.resolveURL() != null;
    }

    @Override
    public boolean isReadable() {
        URL uRL = this.resolveURL();
        return uRL != null && this.checkReadable(uRL);
    }

    @Nullable
    protected URL resolveURL() {
        try {
            if (this.clazz != null) {
                return this.clazz.getResource(this.path);
            }
            if (this.classLoader != null) {
                return this.classLoader.getResource(this.path);
            }
            return ClassLoader.getSystemResource(this.path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream2 = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.path) : ClassLoader.getSystemResourceAsStream(this.path));
        if (inputStream2 == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return inputStream2;
    }

    @Override
    public URL getURL() throws IOException {
        URL uRL = this.resolveURL();
        if (uRL == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    @Override
    public Resource createRelative(String string) {
        String string2 = StringUtils.applyRelativePath(this.path, string);
        return this.clazz != null ? new ClassPathResource(string2, this.clazz) : new ClassPathResource(string2, this.classLoader);
    }

    @Override
    @Nullable
    public String getFilename() {
        return StringUtils.getFilename(this.path);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("class path resource [");
        String string = this.path;
        if (this.clazz != null && !string.startsWith("/")) {
            stringBuilder.append(ClassUtils.classPackageAsResourcePath(this.clazz));
            stringBuilder.append('/');
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        stringBuilder.append(string);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource classPathResource = (ClassPathResource)object;
        return this.path.equals(classPathResource.path) && ObjectUtils.nullSafeEquals(this.classLoader, classPathResource.classLoader) && ObjectUtils.nullSafeEquals(this.clazz, classPathResource.clazz);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

