/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.VfsUtils;
import org.springframework.util.ResourceUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    @Override
    public boolean exists() {
        try {
            HttpURLConnection httpURLConnection;
            URL uRL = this.getURL();
            if (ResourceUtils.isFileURL(uRL)) {
                return this.getFile().exists();
            }
            URLConnection uRLConnection = uRL.openConnection();
            this.customizeConnection(uRLConnection);
            HttpURLConnection httpURLConnection2 = httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
            if (httpURLConnection != null) {
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    return true;
                }
                if (n == 404) {
                    return false;
                }
            }
            if (uRLConnection.getContentLengthLong() > 0L) {
                return true;
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            return this.checkReadable(this.getURL());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    boolean checkReadable(URL uRL) {
        try {
            HttpURLConnection httpURLConnection;
            int n;
            if (ResourceUtils.isFileURL(uRL)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            URLConnection uRLConnection = uRL.openConnection();
            this.customizeConnection(uRLConnection);
            if (uRLConnection instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) != 200) {
                httpURLConnection.disconnect();
                return false;
            }
            long l = uRLConnection.getContentLengthLong();
            if (l > 0L) {
                return true;
            }
            if (l == 0L) {
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            URL uRL = this.getURL();
            if (uRL.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(uRL).isFile();
            }
            return "file".equals(uRL.getProtocol());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public File getFile() throws IOException {
        URL uRL = this.getURL();
        if (uRL.getProtocol().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uRL).getFile();
        }
        return ResourceUtils.getFile(uRL, this.getDescription());
    }

    @Override
    protected File getFileForLastModifiedCheck() throws IOException {
        URL uRL = this.getURL();
        if (ResourceUtils.isJarURL(uRL)) {
            URL uRL2 = ResourceUtils.extractArchiveURL(uRL);
            if (uRL2.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(uRL2).getFile();
            }
            return ResourceUtils.getFile(uRL2, "Jar URL");
        }
        return this.getFile();
    }

    protected boolean isFile(URI uRI) {
        try {
            if (uRI.getScheme().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(uRI).isFile();
            }
            return "file".equals(uRI.getScheme());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected File getFile(URI uRI) throws IOException {
        if (uRI.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uRI).getFile();
        }
        return ResourceUtils.getFile(uRI, this.getDescription());
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        try {
            return FileChannel.open(this.getFile().toPath(), StandardOpenOption.READ);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return super.readableChannel();
        }
    }

    @Override
    public long contentLength() throws IOException {
        URL uRL = this.getURL();
        if (ResourceUtils.isFileURL(uRL)) {
            File file = this.getFile();
            long l = file.length();
            if (l == 0L && !file.exists()) {
                throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its content length");
            }
            return l;
        }
        URLConnection uRLConnection = uRL.openConnection();
        this.customizeConnection(uRLConnection);
        return uRLConnection.getContentLengthLong();
    }

    @Override
    public long lastModified() throws IOException {
        long l;
        Object object;
        URL uRL = this.getURL();
        boolean bl = false;
        if (ResourceUtils.isFileURL(uRL) || ResourceUtils.isJarURL(uRL)) {
            bl = true;
            try {
                object = this.getFileForLastModifiedCheck();
                l = ((File)object).lastModified();
                if (l > 0L || ((File)object).exists()) {
                    return l;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        object = uRL.openConnection();
        this.customizeConnection((URLConnection)object);
        l = ((URLConnection)object).getLastModified();
        if (bl && l == 0L && ((URLConnection)object).getContentLengthLong() <= 0L) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return l;
    }

    protected void customizeConnection(URLConnection uRLConnection) throws IOException {
        ResourceUtils.useCachesIfNecessary(uRLConnection);
        if (uRLConnection instanceof HttpURLConnection) {
            this.customizeConnection((HttpURLConnection)uRLConnection);
        }
    }

    protected void customizeConnection(HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setRequestMethod("HEAD");
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL uRL) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uRL));
        }

        public static Resource getResource(URI uRI) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uRI));
        }
    }
}

