/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CompositePropertySource
extends EnumerablePropertySource<Object> {
    private final Set<PropertySource<?>> propertySources = new LinkedHashSet();

    public CompositePropertySource(String string) {
        super(string);
    }

    @Override
    @Nullable
    public Object getProperty(String string) {
        for (PropertySource<?> propertySource : this.propertySources) {
            Object object = propertySource.getProperty(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public boolean containsProperty(String string) {
        for (PropertySource<?> propertySource : this.propertySources) {
            if (!propertySource.containsProperty(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (PropertySource<?> propertySource : this.propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) {
                throw new IllegalStateException("Failed to enumerate property names due to non-enumerable property source: " + propertySource);
            }
            linkedHashSet.addAll(Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames()));
        }
        return StringUtils.toStringArray(linkedHashSet);
    }

    public void addPropertySource(PropertySource<?> propertySource) {
        this.propertySources.add(propertySource);
    }

    public void addFirstPropertySource(PropertySource<?> propertySource) {
        ArrayList arrayList = new ArrayList(this.propertySources);
        this.propertySources.clear();
        this.propertySources.add(propertySource);
        this.propertySources.addAll(arrayList);
    }

    public Collection<PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {name='" + this.name + "', propertySources=" + this.propertySources + "}";
    }
}

