/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class GenericConversionService
implements ConfigurableConversionService {
    private static final GenericConverter NO_OP_CONVERTER = new NoOpConverter("NO_OP");
    private static final GenericConverter NO_MATCH = new NoOpConverter("NO_MATCH");
    private final Converters converters = new Converters();
    private final Map<ConverterCacheKey, GenericConverter> converterCache = new ConcurrentReferenceHashMap<ConverterCacheKey, GenericConverter>(64);

    @Override
    public void addConverter(Converter<?, ?> converter) {
        ResolvableType[] resolvableTypeArray = this.getRequiredTypeInfo(converter.getClass(), Converter.class);
        if (resolvableTypeArray == null && converter instanceof DecoratingProxy) {
            resolvableTypeArray = this.getRequiredTypeInfo(((DecoratingProxy)((Object)converter)).getDecoratedClass(), Converter.class);
        }
        if (resolvableTypeArray == null) {
            throw new IllegalArgumentException("Unable to determine source type <S> and target type <T> for your Converter [" + converter.getClass().getName() + "]; does the class parameterize those types?");
        }
        this.addConverter(new ConverterAdapter(converter, resolvableTypeArray[0], resolvableTypeArray[1]));
    }

    @Override
    public <S, T> void addConverter(Class<S> clazz, Class<T> clazz2, Converter<? super S, ? extends T> converter) {
        this.addConverter(new ConverterAdapter(converter, ResolvableType.forClass(clazz), ResolvableType.forClass(clazz2)));
    }

    @Override
    public void addConverter(GenericConverter genericConverter) {
        this.converters.add(genericConverter);
        this.invalidateCache();
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> converterFactory) {
        ResolvableType[] resolvableTypeArray = this.getRequiredTypeInfo(converterFactory.getClass(), ConverterFactory.class);
        if (resolvableTypeArray == null && converterFactory instanceof DecoratingProxy) {
            resolvableTypeArray = this.getRequiredTypeInfo(((DecoratingProxy)((Object)converterFactory)).getDecoratedClass(), ConverterFactory.class);
        }
        if (resolvableTypeArray == null) {
            throw new IllegalArgumentException("Unable to determine source type <S> and target type <T> for your ConverterFactory [" + converterFactory.getClass().getName() + "]; does the class parameterize those types?");
        }
        this.addConverter(new ConverterFactoryAdapter(converterFactory, new GenericConverter.ConvertiblePair(resolvableTypeArray[0].toClass(), resolvableTypeArray[1].toClass())));
    }

    @Override
    public void removeConvertible(Class<?> clazz, Class<?> clazz2) {
        this.converters.remove(clazz, clazz2);
        this.invalidateCache();
    }

    @Override
    public boolean canConvert(@Nullable Class<?> clazz, Class<?> clazz2) {
        Assert.notNull(clazz2, "Target type to convert to cannot be null");
        return this.canConvert(clazz != null ? TypeDescriptor.valueOf(clazz) : null, TypeDescriptor.valueOf(clazz2));
    }

    @Override
    public boolean canConvert(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Assert.notNull((Object)typeDescriptor2, "Target type to convert to cannot be null");
        if (typeDescriptor == null) {
            return true;
        }
        GenericConverter genericConverter = this.getConverter(typeDescriptor, typeDescriptor2);
        return genericConverter != null;
    }

    public boolean canBypassConvert(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Assert.notNull((Object)typeDescriptor2, "Target type to convert to cannot be null");
        if (typeDescriptor == null) {
            return true;
        }
        GenericConverter genericConverter = this.getConverter(typeDescriptor, typeDescriptor2);
        return genericConverter == NO_OP_CONVERTER;
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object object, Class<T> clazz) {
        Assert.notNull(clazz, "Target type to convert to cannot be null");
        return (T)this.convert(object, TypeDescriptor.forObject(object), TypeDescriptor.valueOf(clazz));
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, @Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Assert.notNull((Object)typeDescriptor2, "Target type to convert to cannot be null");
        if (typeDescriptor == null) {
            Assert.isTrue(object == null, "Source must be [null] if source type == [null]");
            return this.handleResult(null, typeDescriptor2, this.convertNullSource(null, typeDescriptor2));
        }
        if (object != null && !typeDescriptor.getObjectType().isInstance(object)) {
            throw new IllegalArgumentException("Source to convert from must be an instance of [" + typeDescriptor + "]; instead it was a [" + object.getClass().getName() + "]");
        }
        GenericConverter genericConverter = this.getConverter(typeDescriptor, typeDescriptor2);
        if (genericConverter != null) {
            Object object2 = ConversionUtils.invokeConverter(genericConverter, object, typeDescriptor, typeDescriptor2);
            return this.handleResult(typeDescriptor, typeDescriptor2, object2);
        }
        return this.handleConverterNotFound(object, typeDescriptor, typeDescriptor2);
    }

    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor) {
        return this.convert(object, TypeDescriptor.forObject(object), typeDescriptor);
    }

    public String toString() {
        return this.converters.toString();
    }

    @Nullable
    protected Object convertNullSource(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2.getObjectType() == Optional.class) {
            return Optional.empty();
        }
        return null;
    }

    @Nullable
    protected GenericConverter getConverter(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        ConverterCacheKey converterCacheKey = new ConverterCacheKey(typeDescriptor, typeDescriptor2);
        GenericConverter genericConverter = this.converterCache.get(converterCacheKey);
        if (genericConverter != null) {
            return genericConverter != NO_MATCH ? genericConverter : null;
        }
        genericConverter = this.converters.find(typeDescriptor, typeDescriptor2);
        if (genericConverter == null) {
            genericConverter = this.getDefaultConverter(typeDescriptor, typeDescriptor2);
        }
        if (genericConverter != null) {
            this.converterCache.put(converterCacheKey, genericConverter);
            return genericConverter;
        }
        this.converterCache.put(converterCacheKey, NO_MATCH);
        return null;
    }

    @Nullable
    protected GenericConverter getDefaultConverter(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return typeDescriptor.isAssignableTo(typeDescriptor2) ? NO_OP_CONVERTER : null;
    }

    @Nullable
    private ResolvableType[] getRequiredTypeInfo(Class<?> clazz, Class<?> clazz2) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz).as(clazz2);
        ResolvableType[] resolvableTypeArray = resolvableType.getGenerics();
        if (resolvableTypeArray.length < 2) {
            return null;
        }
        Class<?> clazz3 = resolvableTypeArray[0].resolve();
        Class<?> clazz4 = resolvableTypeArray[1].resolve();
        if (clazz3 == null || clazz4 == null) {
            return null;
        }
        return resolvableTypeArray;
    }

    private void invalidateCache() {
        this.converterCache.clear();
    }

    @Nullable
    private Object handleConverterNotFound(@Nullable Object object, @Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            this.assertNotPrimitiveTargetType(typeDescriptor, typeDescriptor2);
            return null;
        }
        if ((typeDescriptor == null || typeDescriptor.isAssignableTo(typeDescriptor2)) && typeDescriptor2.getObjectType().isInstance(object)) {
            return object;
        }
        throw new ConverterNotFoundException(typeDescriptor, typeDescriptor2);
    }

    @Nullable
    private Object handleResult(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2, @Nullable Object object) {
        if (object == null) {
            this.assertNotPrimitiveTargetType(typeDescriptor, typeDescriptor2);
        }
        return object;
    }

    private void assertNotPrimitiveTargetType(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2.isPrimitive()) {
            throw new ConversionFailedException(typeDescriptor, typeDescriptor2, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
    }

    private static class NoOpConverter
    implements GenericConverter {
        private final String name;

        public NoOpConverter(String string) {
            this.name = string;
        }

        @Override
        @Nullable
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            return object;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ConvertersForPair {
        private final Deque<GenericConverter> converters = new ConcurrentLinkedDeque<GenericConverter>();

        private ConvertersForPair() {
        }

        public void add(GenericConverter genericConverter) {
            this.converters.addFirst(genericConverter);
        }

        @Nullable
        public GenericConverter getConverter(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            for (GenericConverter genericConverter : this.converters) {
                if (genericConverter instanceof ConditionalGenericConverter && !((ConditionalGenericConverter)genericConverter).matches(typeDescriptor, typeDescriptor2)) continue;
                return genericConverter;
            }
            return null;
        }

        public String toString() {
            return StringUtils.collectionToCommaDelimitedString(this.converters);
        }
    }

    private static class Converters {
        private final Set<GenericConverter> globalConverters = new CopyOnWriteArraySet<GenericConverter>();
        private final Map<GenericConverter.ConvertiblePair, ConvertersForPair> converters = new ConcurrentHashMap<GenericConverter.ConvertiblePair, ConvertersForPair>(256);

        private Converters() {
        }

        public void add(GenericConverter genericConverter) {
            Set<GenericConverter.ConvertiblePair> set = genericConverter.getConvertibleTypes();
            if (set == null) {
                Assert.state(genericConverter instanceof ConditionalConverter, "Only conditional converters may return null convertible types");
                this.globalConverters.add(genericConverter);
            } else {
                for (GenericConverter.ConvertiblePair convertiblePair : set) {
                    this.getMatchableConverters(convertiblePair).add(genericConverter);
                }
            }
        }

        private ConvertersForPair getMatchableConverters(GenericConverter.ConvertiblePair convertiblePair2) {
            return this.converters.computeIfAbsent(convertiblePair2, convertiblePair -> new ConvertersForPair());
        }

        public void remove(Class<?> clazz, Class<?> clazz2) {
            this.converters.remove(new GenericConverter.ConvertiblePair(clazz, clazz2));
        }

        @Nullable
        public GenericConverter find(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            List<Class<?>> list = this.getClassHierarchy(typeDescriptor.getType());
            List<Class<?>> list2 = this.getClassHierarchy(typeDescriptor2.getType());
            for (Class<?> clazz : list) {
                for (Class<?> clazz2 : list2) {
                    GenericConverter.ConvertiblePair convertiblePair = new GenericConverter.ConvertiblePair(clazz, clazz2);
                    GenericConverter genericConverter = this.getRegisteredConverter(typeDescriptor, typeDescriptor2, convertiblePair);
                    if (genericConverter == null) continue;
                    return genericConverter;
                }
            }
            return null;
        }

        @Nullable
        private GenericConverter getRegisteredConverter(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2, GenericConverter.ConvertiblePair convertiblePair) {
            Object object;
            ConvertersForPair convertersForPair = this.converters.get(convertiblePair);
            if (convertersForPair != null && (object = convertersForPair.getConverter(typeDescriptor, typeDescriptor2)) != null) {
                return object;
            }
            for (GenericConverter genericConverter : this.globalConverters) {
                if (!((ConditionalConverter)((Object)genericConverter)).matches(typeDescriptor, typeDescriptor2)) continue;
                return genericConverter;
            }
            return null;
        }

        private List<Class<?>> getClassHierarchy(Class<?> clazz) {
            ArrayList arrayList = new ArrayList(20);
            HashSet hashSet = new HashSet(20);
            this.addToClassHierarchy(0, ClassUtils.resolvePrimitiveIfNecessary(clazz), false, arrayList, hashSet);
            boolean bl = clazz.isArray();
            for (int i = 0; i < arrayList.size(); ++i) {
                Class<?> clazz2 = (Class<?>)arrayList.get(i);
                clazz2 = bl ? clazz2.getComponentType() : ClassUtils.resolvePrimitiveIfNecessary(clazz2);
                Class<?> clazz3 = clazz2.getSuperclass();
                if (clazz3 != null && clazz3 != Object.class && clazz3 != Enum.class) {
                    this.addToClassHierarchy(i + 1, clazz2.getSuperclass(), bl, arrayList, hashSet);
                }
                this.addInterfacesToClassHierarchy(clazz2, bl, arrayList, hashSet);
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                this.addToClassHierarchy(arrayList.size(), Enum.class, bl, arrayList, hashSet);
                this.addToClassHierarchy(arrayList.size(), Enum.class, false, arrayList, hashSet);
                this.addInterfacesToClassHierarchy(Enum.class, bl, arrayList, hashSet);
            }
            this.addToClassHierarchy(arrayList.size(), Object.class, bl, arrayList, hashSet);
            this.addToClassHierarchy(arrayList.size(), Object.class, false, arrayList, hashSet);
            return arrayList;
        }

        private void addInterfacesToClassHierarchy(Class<?> clazz, boolean bl, List<Class<?>> list, Set<Class<?>> set) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                this.addToClassHierarchy(list.size(), clazz2, bl, list, set);
            }
        }

        private void addToClassHierarchy(int n, Class<?> clazz, boolean bl, List<Class<?>> list, Set<Class<?>> set) {
            if (bl) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            if (set.add(clazz)) {
                list.add(n, clazz);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ConversionService converters =\n");
            for (String string : this.getConverterStrings()) {
                stringBuilder.append('\t').append(string).append('\n');
            }
            return stringBuilder.toString();
        }

        private List<String> getConverterStrings() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ConvertersForPair convertersForPair : this.converters.values()) {
                arrayList.add(convertersForPair.toString());
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    private static final class ConverterCacheKey
    implements Comparable<ConverterCacheKey> {
        private final TypeDescriptor sourceType;
        private final TypeDescriptor targetType;

        public ConverterCacheKey(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            this.sourceType = typeDescriptor;
            this.targetType = typeDescriptor2;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ConverterCacheKey)) {
                return false;
            }
            ConverterCacheKey converterCacheKey = (ConverterCacheKey)object;
            return this.sourceType.equals(converterCacheKey.sourceType) && this.targetType.equals(converterCacheKey.targetType);
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 29 + this.targetType.hashCode();
        }

        public String toString() {
            return "ConverterCacheKey [sourceType = " + this.sourceType + ", targetType = " + this.targetType + "]";
        }

        @Override
        public int compareTo(ConverterCacheKey converterCacheKey) {
            int n = this.sourceType.getResolvableType().toString().compareTo(converterCacheKey.sourceType.getResolvableType().toString());
            if (n == 0) {
                n = this.targetType.getResolvableType().toString().compareTo(converterCacheKey.targetType.getResolvableType().toString());
            }
            return n;
        }
    }

    private final class ConverterFactoryAdapter
    implements ConditionalGenericConverter {
        private final ConverterFactory<Object, Object> converterFactory;
        private final GenericConverter.ConvertiblePair typeInfo;

        public ConverterFactoryAdapter(ConverterFactory<?, ?> converterFactory, GenericConverter.ConvertiblePair convertiblePair) {
            this.converterFactory = converterFactory;
            this.typeInfo = convertiblePair;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            Converter<Object, ?> converter;
            boolean bl = true;
            if (this.converterFactory instanceof ConditionalConverter) {
                bl = ((ConditionalConverter)((Object)this.converterFactory)).matches(typeDescriptor, typeDescriptor2);
            }
            if (bl && (converter = this.converterFactory.getConverter(typeDescriptor2.getType())) instanceof ConditionalConverter) {
                bl = ((ConditionalConverter)((Object)converter)).matches(typeDescriptor, typeDescriptor2);
            }
            return bl;
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            if (object == null) {
                return GenericConversionService.this.convertNullSource(typeDescriptor, typeDescriptor2);
            }
            return this.converterFactory.getConverter(typeDescriptor2.getObjectType()).convert(object);
        }

        public String toString() {
            return this.typeInfo + " : " + this.converterFactory;
        }
    }

    private final class ConverterAdapter
    implements ConditionalGenericConverter {
        private final Converter<Object, Object> converter;
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ResolvableType targetType;

        public ConverterAdapter(Converter<?, ?> converter, ResolvableType resolvableType, ResolvableType resolvableType2) {
            this.converter = converter;
            this.typeInfo = new GenericConverter.ConvertiblePair(resolvableType.toClass(), resolvableType2.toClass());
            this.targetType = resolvableType2;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            if (this.typeInfo.getTargetType() != typeDescriptor2.getObjectType()) {
                return false;
            }
            ResolvableType resolvableType = typeDescriptor2.getResolvableType();
            if (!(resolvableType.getType() instanceof Class || resolvableType.isAssignableFrom(this.targetType) || this.targetType.hasUnresolvableGenerics())) {
                return false;
            }
            return !(this.converter instanceof ConditionalConverter) || ((ConditionalConverter)((Object)this.converter)).matches(typeDescriptor, typeDescriptor2);
        }

        @Override
        @Nullable
        public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            if (object == null) {
                return GenericConversionService.this.convertNullSource(typeDescriptor, typeDescriptor2);
            }
            return this.converter.convert(object);
        }

        public String toString() {
            return this.typeInfo + " : " + this.converter;
        }
    }
}

