/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;

public final class ConversionServiceFactory {
    private ConversionServiceFactory() {
    }

    public static void registerConverters(@Nullable Set<?> set, ConverterRegistry converterRegistry) {
        if (set != null) {
            for (Object obj : set) {
                if (obj instanceof GenericConverter) {
                    converterRegistry.addConverter((GenericConverter)obj);
                    continue;
                }
                if (obj instanceof Converter) {
                    converterRegistry.addConverter((Converter)obj);
                    continue;
                }
                if (obj instanceof ConverterFactory) {
                    converterRegistry.addConverterFactory((ConverterFactory)obj);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

