/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.CollectionToStringConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

final class ArrayToStringConverter
implements ConditionalGenericConverter {
    private final CollectionToStringConverter helperConverter;

    public ArrayToStringConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToStringConverter(conversionService);
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return this.helperConverter.matches(typeDescriptor, typeDescriptor2);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return this.helperConverter.convert(Arrays.asList(ObjectUtils.toObjectArray(object)), typeDescriptor, typeDescriptor2);
    }
}

