/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class ArrayToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ArrayToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        int n = Array.getLength(object);
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Collection<Object> collection = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, n);
        if (typeDescriptor3 == null) {
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                collection.add(object2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                Object object4 = this.conversionService.convert(object3, typeDescriptor.elementTypeDescriptor(object3), typeDescriptor3);
                collection.add(object4);
            }
        }
        return collection;
    }
}

