/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.converter;

import java.util.Comparator;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.comparator.Comparators;

public class ConvertingComparator<S, T>
implements Comparator<S> {
    private final Comparator<T> comparator;
    private final Converter<S, T> converter;

    public ConvertingComparator(Converter<S, T> converter) {
        this(Comparators.comparable(), converter);
    }

    public ConvertingComparator(Comparator<T> comparator, Converter<S, T> converter) {
        Assert.notNull(comparator, "Comparator must not be null");
        Assert.notNull(converter, "Converter must not be null");
        this.comparator = comparator;
        this.converter = converter;
    }

    public ConvertingComparator(Comparator<T> comparator, ConversionService conversionService, Class<? extends T> clazz) {
        this(comparator, new ConversionServiceConverter(conversionService, clazz));
    }

    @Override
    public int compare(S s2, S s3) {
        T t2 = this.converter.convert(s2);
        T t3 = this.converter.convert(s3);
        return this.comparator.compare(t2, t3);
    }

    public static <K, V> ConvertingComparator<Map.Entry<K, V>, K> mapEntryKeys(Comparator<K> comparator) {
        return new ConvertingComparator<Map.Entry, Object>(comparator, Map.Entry::getKey);
    }

    public static <K, V> ConvertingComparator<Map.Entry<K, V>, V> mapEntryValues(Comparator<V> comparator) {
        return new ConvertingComparator<Map.Entry, Object>(comparator, Map.Entry::getValue);
    }

    private static class ConversionServiceConverter<S, T>
    implements Converter<S, T> {
        private final ConversionService conversionService;
        private final Class<? extends T> targetType;

        public ConversionServiceConverter(ConversionService conversionService, Class<? extends T> clazz) {
            Assert.notNull((Object)conversionService, "ConversionService must not be null");
            Assert.notNull(clazz, "TargetType must not be null");
            this.conversionService = conversionService;
            this.targetType = clazz;
        }

        @Override
        @Nullable
        public T convert(S s2) {
            return this.conversionService.convert(s2, this.targetType);
        }
    }
}

