/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractSingleValueEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class ResourceEncoder
extends AbstractSingleValueEncoder<Resource> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final int bufferSize;

    public ResourceEncoder() {
        this(4096);
    }

    public ResourceEncoder(int n) {
        super(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.ALL);
        Assert.isTrue(n > 0, "'bufferSize' must be larger than 0");
        this.bufferSize = n;
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        Class<?> clazz = resolvableType.toClass();
        return super.canEncode(resolvableType, mimeType) && Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Flux<DataBuffer> encode(Resource resource, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            String string = Hints.getLogPrefix(map);
            this.logger.debug(string + "Writing [" + resource + "]");
        }
        return DataBufferUtils.read(resource, dataBufferFactory, this.bufferSize);
    }
}

