/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractDataBufferDecoder<T>
extends AbstractDecoder<T> {
    private int maxInMemorySize = 262144;

    protected AbstractDataBufferDecoder(MimeType ... mimeTypeArray) {
        super(mimeTypeArray);
    }

    public void setMaxInMemorySize(int n) {
        this.maxInMemorySize = n;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public Flux<T> decode(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(publisher).map(dataBuffer -> this.decodeDataBuffer((DataBuffer)dataBuffer, resolvableType, mimeType, map));
    }

    @Override
    public Mono<T> decodeToMono(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return DataBufferUtils.join(publisher, this.maxInMemorySize).map(dataBuffer -> this.decodeDataBuffer((DataBuffer)dataBuffer, resolvableType, mimeType, map));
    }

    @Deprecated
    @Nullable
    protected T decodeDataBuffer(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return this.decode(dataBuffer, resolvableType, mimeType, map);
    }
}

