/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    @Nullable
    private volatile Integer hashCode;
    @Nullable
    private volatile String string;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> mergedAnnotation, Class<A> clazz) {
        Assert.notNull(mergedAnnotation, "MergedAnnotation must not be null");
        Assert.notNull(clazz, "Type must not be null");
        Assert.isTrue(clazz.isAnnotation(), "Type must be an annotation");
        this.annotation = mergedAnnotation;
        this.type = clazz;
        this.attributes = AttributeMethods.forAnnotationType(clazz);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.annotationEquals(objectArray[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod(method)) {
            return this.annotationToString();
        }
        if (this.isAnnotationTypeMethod(method)) {
            return this.type;
        }
        if (this.attributes.indexOf(method.getName()) != -1) {
            return this.getAttributeValue(method);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean isAnnotationTypeMethod(Method method) {
        return method.getName().equals("annotationType") && method.getParameterCount() == 0;
    }

    private boolean annotationEquals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.type.isInstance(object)) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object object2;
            Method method = this.attributes.get(i);
            Object object3 = this.getAttributeValue(method);
            if (ObjectUtils.nullSafeEquals(object3, object2 = ReflectionUtils.invokeMethod(method, object))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer n = this.hashCode;
        if (n == null) {
            this.hashCode = n = this.computeHashCode();
        }
        return n;
    }

    private Integer computeHashCode() {
        int n = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method method = this.attributes.get(i);
            Object object = this.getAttributeValue(method);
            n += 127 * method.getName().hashCode() ^ this.getValueHashCode(object);
        }
        return n;
    }

    private int getValueHashCode(Object object) {
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.hashCode((Object[])object);
        }
        return object.hashCode();
    }

    private String annotationToString() {
        String string = this.string;
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder("@").append(this.type.getName()).append("(");
            for (int i = 0; i < this.attributes.size(); ++i) {
                Method method = this.attributes.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(method.getName());
                stringBuilder.append("=");
                stringBuilder.append(this.toString(this.getAttributeValue(method)));
            }
            stringBuilder.append(")");
            this.string = string = stringBuilder.toString();
        }
        return string;
    }

    private String toString(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object.getClass().isArray()) {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.toString(Array.get(object, i)));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    private Object getAttributeValue(Method method) {
        Object object = this.valueCache.computeIfAbsent(method.getName(), string -> {
            Class<?> clazz = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
            return this.annotation.getValue((String)string, clazz).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + string + "' in merged annotation " + this.annotation.getType().getName()));
        });
        if (object.getClass().isArray() && Array.getLength(object) > 0) {
            object = this.cloneArray(object);
        }
        return object;
    }

    private Object cloneArray(Object object) {
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        return ((Object[])object).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> mergedAnnotation, Class<A> clazz) {
        Class[] classArray;
        ClassLoader classLoader = clazz.getClassLoader();
        SynthesizedMergedAnnotationInvocationHandler<A> synthesizedMergedAnnotationInvocationHandler = new SynthesizedMergedAnnotationInvocationHandler<A>(mergedAnnotation, clazz);
        if (SynthesizedMergedAnnotationInvocationHandler.isVisible(classLoader, SynthesizedAnnotation.class)) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = clazz;
            classArray = classArray2;
            classArray2[1] = SynthesizedAnnotation.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = clazz;
        }
        Class[] classArray4 = classArray;
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, classArray4, synthesizedMergedAnnotationInvocationHandler));
    }

    private static boolean isVisible(ClassLoader classLoader, Class<?> clazz) {
        if (classLoader == clazz.getClassLoader()) {
            return true;
        }
        try {
            return Class.forName(clazz.getName(), false, classLoader) == clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

