/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public abstract class RepeatableContainers {
    @Nullable
    private final RepeatableContainers parent;

    private RepeatableContainers(@Nullable RepeatableContainers repeatableContainers) {
        this.parent = repeatableContainers;
    }

    public RepeatableContainers and(Class<? extends Annotation> clazz, Class<? extends Annotation> clazz2) {
        return new ExplicitRepeatableContainer(this, clazz2, clazz);
    }

    @Nullable
    Annotation[] findRepeatedAnnotations(Annotation annotation) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.findRepeatedAnnotations(annotation);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.parent, ((RepeatableContainers)object).parent);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.parent);
    }

    public static RepeatableContainers standardRepeatables() {
        return StandardRepeatableContainers.INSTANCE;
    }

    public static RepeatableContainers of(Class<? extends Annotation> clazz, @Nullable Class<? extends Annotation> clazz2) {
        return new ExplicitRepeatableContainer(null, clazz, clazz2);
    }

    public static RepeatableContainers none() {
        return NoRepeatableContainers.INSTANCE;
    }

    private static class NoRepeatableContainers
    extends RepeatableContainers {
        private static NoRepeatableContainers INSTANCE = new NoRepeatableContainers();

        NoRepeatableContainers() {
            super(null);
        }
    }

    private static class ExplicitRepeatableContainer
    extends RepeatableContainers {
        private final Class<? extends Annotation> repeatable;
        private final Class<? extends Annotation> container;
        private final Method valueMethod;

        ExplicitRepeatableContainer(@Nullable RepeatableContainers repeatableContainers, Class<? extends Annotation> clazz, @Nullable Class<? extends Annotation> clazz2) {
            super(repeatableContainers);
            Assert.notNull(clazz, "Repeatable must not be null");
            if (clazz2 == null) {
                clazz2 = this.deduceContainer(clazz);
            }
            Method method = AttributeMethods.forAnnotationType(clazz2).get("value");
            try {
                if (method == null) {
                    throw new NoSuchMethodException("No value method found");
                }
                Class<?> clazz3 = method.getReturnType();
                if (!clazz3.isArray() || clazz3.getComponentType() != clazz) {
                    throw new AnnotationConfigurationException("Container type [" + clazz2.getName() + "] must declare a 'value' attribute for an array of type [" + clazz.getName() + "]");
                }
            }
            catch (AnnotationConfigurationException annotationConfigurationException) {
                throw annotationConfigurationException;
            }
            catch (Throwable throwable) {
                throw new AnnotationConfigurationException("Invalid declaration of container type [" + clazz2.getName() + "] for repeatable annotation [" + clazz.getName() + "]", throwable);
            }
            this.repeatable = clazz;
            this.container = clazz2;
            this.valueMethod = method;
        }

        private Class<? extends Annotation> deduceContainer(Class<? extends Annotation> clazz) {
            Repeatable repeatable = clazz.getAnnotation(Repeatable.class);
            Assert.notNull((Object)repeatable, () -> "Annotation type must be a repeatable annotation: failed to resolve container type for " + clazz.getName());
            return repeatable.value();
        }

        @Override
        @Nullable
        Annotation[] findRepeatedAnnotations(Annotation annotation) {
            if (this.container.isAssignableFrom(annotation.annotationType())) {
                return (Annotation[])ReflectionUtils.invokeMethod(this.valueMethod, annotation);
            }
            return super.findRepeatedAnnotations(annotation);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (!super.equals(object)) {
                return false;
            }
            ExplicitRepeatableContainer explicitRepeatableContainer = (ExplicitRepeatableContainer)object;
            return this.container.equals(explicitRepeatableContainer.container) && this.repeatable.equals(explicitRepeatableContainer.repeatable);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.container.hashCode();
            n = 31 * n + this.repeatable.hashCode();
            return n;
        }
    }

    private static class StandardRepeatableContainers
    extends RepeatableContainers {
        private static final Map<Class<? extends Annotation>, Object> cache = new ConcurrentReferenceHashMap<Class<? extends Annotation>, Object>();
        private static final Object NONE = new Object();
        private static StandardRepeatableContainers INSTANCE = new StandardRepeatableContainers();

        StandardRepeatableContainers() {
            super(null);
        }

        @Override
        @Nullable
        Annotation[] findRepeatedAnnotations(Annotation annotation) {
            Method method = StandardRepeatableContainers.getRepeatedAnnotationsMethod(annotation.annotationType());
            if (method != null) {
                return (Annotation[])ReflectionUtils.invokeMethod(method, annotation);
            }
            return super.findRepeatedAnnotations(annotation);
        }

        @Nullable
        private static Method getRepeatedAnnotationsMethod(Class<? extends Annotation> clazz) {
            Object object = cache.computeIfAbsent(clazz, StandardRepeatableContainers::computeRepeatedAnnotationsMethod);
            return object != NONE ? (Method)object : null;
        }

        private static Object computeRepeatedAnnotationsMethod(Class<? extends Annotation> clazz) {
            Class<?> clazz2;
            Method method;
            Class<?> clazz3;
            AttributeMethods attributeMethods = AttributeMethods.forAnnotationType(clazz);
            if (attributeMethods.hasOnlyValueAttribute() && (clazz3 = (method = attributeMethods.get(0)).getReturnType()).isArray() && Annotation.class.isAssignableFrom(clazz2 = clazz3.getComponentType()) && clazz2.isAnnotationPresent(Repeatable.class)) {
                return method;
            }
            return NONE;
        }
    }
}

