/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.util.Arrays;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class PackagesAnnotationFilter
implements AnnotationFilter {
    private final String[] prefixes;
    private final int hashCode;

    PackagesAnnotationFilter(String ... stringArray) {
        Assert.notNull((Object)stringArray, "Packages array must not be null");
        this.prefixes = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Assert.hasText(string, "Packages array must not have empty elements");
            this.prefixes[i] = string + ".";
        }
        Arrays.sort(this.prefixes);
        this.hashCode = Arrays.hashCode(this.prefixes);
    }

    @Override
    public boolean matches(String string) {
        for (String string2 : this.prefixes) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.prefixes, ((PackagesAnnotationFilter)object).prefixes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Packages annotation filter: " + StringUtils.arrayToCommaDelimitedString(this.prefixes);
    }
}

