/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

final class AnnotationTypeMappings {
    private static final IntrospectionFailureLogger failureLogger = IntrospectionFailureLogger.DEBUG;
    private static final Map<AnnotationFilter, Cache> standardRepeatablesCache = new ConcurrentReferenceHashMap<AnnotationFilter, Cache>();
    private static final Map<AnnotationFilter, Cache> noRepeatablesCache = new ConcurrentReferenceHashMap<AnnotationFilter, Cache>();
    private final RepeatableContainers repeatableContainers;
    private final AnnotationFilter filter;
    private final List<AnnotationTypeMapping> mappings;

    private AnnotationTypeMappings(RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter, Class<? extends Annotation> clazz) {
        this.repeatableContainers = repeatableContainers;
        this.filter = annotationFilter;
        this.mappings = new ArrayList<AnnotationTypeMapping>();
        this.addAllMappings(clazz);
        this.mappings.forEach(AnnotationTypeMapping::afterAllMappingsSet);
    }

    private void addAllMappings(Class<? extends Annotation> clazz) {
        ArrayDeque<AnnotationTypeMapping> arrayDeque = new ArrayDeque<AnnotationTypeMapping>();
        this.addIfPossible(arrayDeque, null, clazz, null);
        while (!arrayDeque.isEmpty()) {
            AnnotationTypeMapping annotationTypeMapping = (AnnotationTypeMapping)arrayDeque.removeFirst();
            this.mappings.add(annotationTypeMapping);
            this.addMetaAnnotationsToQueue(arrayDeque, annotationTypeMapping);
        }
    }

    private void addMetaAnnotationsToQueue(Deque<AnnotationTypeMapping> deque, AnnotationTypeMapping annotationTypeMapping) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = AnnotationsScanner.getDeclaredAnnotations(annotationTypeMapping.getAnnotationType(), false)) {
            if (!this.isMappable(annotationTypeMapping, annotation)) continue;
            Annotation[] annotationArray2 = this.repeatableContainers.findRepeatedAnnotations(annotation);
            if (annotationArray2 != null) {
                for (Annotation annotation2 : annotationArray2) {
                    if (!this.isMappable(annotationTypeMapping, annotation2)) continue;
                    this.addIfPossible(deque, annotationTypeMapping, annotation2);
                }
                continue;
            }
            this.addIfPossible(deque, annotationTypeMapping, annotation);
        }
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> deque, AnnotationTypeMapping annotationTypeMapping, Annotation annotation) {
        this.addIfPossible(deque, annotationTypeMapping, annotation.annotationType(), annotation);
    }

    private void addIfPossible(Deque<AnnotationTypeMapping> deque, @Nullable AnnotationTypeMapping annotationTypeMapping, Class<? extends Annotation> clazz, @Nullable Annotation annotation) {
        block2: {
            try {
                deque.addLast(new AnnotationTypeMapping(annotationTypeMapping, clazz, annotation));
            }
            catch (Exception exception) {
                AnnotationUtils.rethrowAnnotationConfigurationException(exception);
                if (!failureLogger.isEnabled()) break block2;
                failureLogger.log("Failed to introspect meta-annotation " + clazz.getName(), annotationTypeMapping != null ? annotationTypeMapping.getAnnotationType() : null, exception);
            }
        }
    }

    private boolean isMappable(AnnotationTypeMapping annotationTypeMapping, @Nullable Annotation annotation) {
        return annotation != null && !this.filter.matches(annotation) && !AnnotationFilter.PLAIN.matches(annotationTypeMapping.getAnnotationType()) && !this.isAlreadyMapped(annotationTypeMapping, annotation);
    }

    private boolean isAlreadyMapped(AnnotationTypeMapping annotationTypeMapping, Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        for (AnnotationTypeMapping annotationTypeMapping2 = annotationTypeMapping; annotationTypeMapping2 != null; annotationTypeMapping2 = annotationTypeMapping2.getSource()) {
            if (annotationTypeMapping2.getAnnotationType() != clazz) continue;
            return true;
        }
        return false;
    }

    int size() {
        return this.mappings.size();
    }

    AnnotationTypeMapping get(int n) {
        return this.mappings.get(n);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> clazz) {
        return AnnotationTypeMappings.forAnnotationType(clazz, AnnotationFilter.PLAIN);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> clazz, AnnotationFilter annotationFilter) {
        return AnnotationTypeMappings.forAnnotationType(clazz, RepeatableContainers.standardRepeatables(), annotationFilter);
    }

    static AnnotationTypeMappings forAnnotationType(Class<? extends Annotation> clazz, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter2) {
        if (repeatableContainers == RepeatableContainers.standardRepeatables()) {
            return standardRepeatablesCache.computeIfAbsent(annotationFilter2, annotationFilter -> new Cache(repeatableContainers, (AnnotationFilter)annotationFilter)).get(clazz);
        }
        if (repeatableContainers == RepeatableContainers.none()) {
            return noRepeatablesCache.computeIfAbsent(annotationFilter2, annotationFilter -> new Cache(repeatableContainers, (AnnotationFilter)annotationFilter)).get(clazz);
        }
        return new AnnotationTypeMappings(repeatableContainers, annotationFilter2, clazz);
    }

    static void clearCache() {
        standardRepeatablesCache.clear();
        noRepeatablesCache.clear();
    }

    private static class Cache {
        private final RepeatableContainers repeatableContainers;
        private final AnnotationFilter filter;
        private final Map<Class<? extends Annotation>, AnnotationTypeMappings> mappings;

        Cache(RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
            this.repeatableContainers = repeatableContainers;
            this.filter = annotationFilter;
            this.mappings = new ConcurrentReferenceHashMap<Class<? extends Annotation>, AnnotationTypeMappings>();
        }

        AnnotationTypeMappings get(Class<? extends Annotation> clazz) {
            return this.mappings.computeIfAbsent(clazz, this::createMappings);
        }

        AnnotationTypeMappings createMappings(Class<? extends Annotation> clazz) {
            return new AnnotationTypeMappings(this.repeatableContainers, this.filter, clazz);
        }
    }
}

