/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.TypeMappedAnnotation;
import org.springframework.core.annotation.ValueExtractor;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

final class AnnotationTypeMapping {
    private static final MirrorSets.MirrorSet[] EMPTY_MIRROR_SETS = new MirrorSets.MirrorSet[0];
    @Nullable
    private final AnnotationTypeMapping source;
    private final AnnotationTypeMapping root;
    private final int distance;
    private final Class<? extends Annotation> annotationType;
    private final List<Class<? extends Annotation>> metaTypes;
    @Nullable
    private final Annotation annotation;
    private final AttributeMethods attributes;
    private final MirrorSets mirrorSets;
    private final int[] aliasMappings;
    private final int[] conventionMappings;
    private final int[] annotationValueMappings;
    private final AnnotationTypeMapping[] annotationValueSource;
    private final Map<Method, List<Method>> aliasedBy;
    private final boolean synthesizable;
    private final Set<Method> claimedAliases = new HashSet<Method>();

    AnnotationTypeMapping(@Nullable AnnotationTypeMapping annotationTypeMapping, Class<? extends Annotation> clazz, @Nullable Annotation annotation) {
        this.source = annotationTypeMapping;
        this.root = annotationTypeMapping != null ? annotationTypeMapping.getRoot() : this;
        this.distance = annotationTypeMapping == null ? 0 : annotationTypeMapping.getDistance() + 1;
        this.annotationType = clazz;
        this.metaTypes = AnnotationTypeMapping.merge(annotationTypeMapping != null ? annotationTypeMapping.getMetaTypes() : null, clazz);
        this.annotation = annotation;
        this.attributes = AttributeMethods.forAnnotationType(clazz);
        this.mirrorSets = new MirrorSets();
        this.aliasMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.conventionMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.annotationValueMappings = AnnotationTypeMapping.filledIntArray(this.attributes.size());
        this.annotationValueSource = new AnnotationTypeMapping[this.attributes.size()];
        this.aliasedBy = this.resolveAliasedForTargets();
        this.processAliases();
        this.addConventionMappings();
        this.addConventionAnnotationValues();
        this.synthesizable = this.computeSynthesizableFlag();
    }

    private static <T> List<T> merge(@Nullable List<T> list, T t2) {
        if (list == null) {
            return Collections.singletonList(t2);
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(t2);
        return Collections.unmodifiableList(arrayList);
    }

    private Map<Method, List<Method>> resolveAliasedForTargets() {
        HashMap<Method, List> hashMap = new HashMap<Method, List>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method method2 = this.attributes.get(i);
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(method2, AliasFor.class);
            if (aliasFor == null) continue;
            Method method3 = this.resolveAliasTarget(method2, aliasFor);
            hashMap.computeIfAbsent(method3, method -> new ArrayList()).add(method2);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Method resolveAliasTarget(Method method, AliasFor aliasFor) {
        return this.resolveAliasTarget(method, aliasFor, true);
    }

    private Method resolveAliasTarget(Method method, AliasFor aliasFor, boolean bl) {
        Method method2;
        AliasFor aliasFor2;
        Method method3;
        String string;
        if (StringUtils.hasText(aliasFor.value()) && StringUtils.hasText(aliasFor.attribute())) {
            throw new AnnotationConfigurationException(String.format("In @AliasFor declared on %s, attribute 'attribute' and its alias 'value' are present with values of '%s' and '%s', but only one is permitted.", AttributeMethods.describe(method), aliasFor.attribute(), aliasFor.value()));
        }
        Class<? extends Annotation> clazz = aliasFor.annotation();
        if (clazz == Annotation.class) {
            clazz = this.annotationType;
        }
        if (!StringUtils.hasLength(string = aliasFor.attribute())) {
            string = aliasFor.value();
        }
        if (!StringUtils.hasLength(string)) {
            string = method.getName();
        }
        if ((method3 = AttributeMethods.forAnnotationType(clazz).get(string)) == null) {
            if (clazz == this.annotationType) {
                throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for '%s' which is not present.", AttributeMethods.describe(method), string));
            }
            throw new AnnotationConfigurationException(String.format("%s is declared as an @AliasFor nonexistent %s.", StringUtils.capitalize(AttributeMethods.describe(method)), AttributeMethods.describe(clazz, string)));
        }
        if (method3.equals(method)) {
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s points to itself. Specify 'annotation' to point to a same-named attribute on a meta-annotation.", AttributeMethods.describe(method)));
        }
        if (!this.isCompatibleReturnType(method.getReturnType(), method3.getReturnType())) {
            throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare the same return type.", AttributeMethods.describe(method), AttributeMethods.describe(method3)));
        }
        if (this.isAliasPair(method3) && bl && (aliasFor2 = method3.getAnnotation(AliasFor.class)) != null && !(method2 = this.resolveAliasTarget(method3, aliasFor2, false)).equals(method)) {
            throw new AnnotationConfigurationException(String.format("%s must be declared as an @AliasFor %s, not %s.", StringUtils.capitalize(AttributeMethods.describe(method3)), AttributeMethods.describe(method), AttributeMethods.describe(method2)));
        }
        return method3;
    }

    private boolean isAliasPair(Method method) {
        return this.annotationType == method.getDeclaringClass();
    }

    private boolean isCompatibleReturnType(Class<?> clazz, Class<?> clazz2) {
        return clazz == clazz2 || clazz == clazz2.getComponentType();
    }

    private void processAliases() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            arrayList.clear();
            arrayList.add(this.attributes.get(i));
            this.collectAliases(arrayList);
            if (arrayList.size() <= 1) continue;
            this.processAliases(i, arrayList);
        }
    }

    private void collectAliases(List<Method> list) {
        AnnotationTypeMapping annotationTypeMapping = this;
        while (annotationTypeMapping != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                List<Method> list2 = annotationTypeMapping.aliasedBy.get(list.get(i));
                if (list2 == null) continue;
                list.addAll(list2);
            }
            annotationTypeMapping = annotationTypeMapping.source;
        }
    }

    private void processAliases(int n, List<Method> list) {
        int n2 = this.getFirstRootAttributeIndex(list);
        AnnotationTypeMapping annotationTypeMapping = this;
        while (annotationTypeMapping != null) {
            if (n2 != -1 && annotationTypeMapping != this.root) {
                for (int i = 0; i < annotationTypeMapping.attributes.size(); ++i) {
                    if (!list.contains(annotationTypeMapping.attributes.get(i))) continue;
                    annotationTypeMapping.aliasMappings[i] = n2;
                }
            }
            annotationTypeMapping.mirrorSets.updateFrom(list);
            annotationTypeMapping.claimedAliases.addAll(list);
            if (annotationTypeMapping.annotation != null) {
                int[] nArray = annotationTypeMapping.mirrorSets.resolve(null, annotationTypeMapping.annotation, ReflectionUtils::invokeMethod);
                for (int i = 0; i < annotationTypeMapping.attributes.size(); ++i) {
                    if (!list.contains(annotationTypeMapping.attributes.get(i))) continue;
                    this.annotationValueMappings[n] = nArray[i];
                    this.annotationValueSource[n] = annotationTypeMapping;
                }
            }
            annotationTypeMapping = annotationTypeMapping.source;
        }
    }

    private int getFirstRootAttributeIndex(Collection<Method> collection) {
        AttributeMethods attributeMethods = this.root.getAttributes();
        for (int i = 0; i < attributeMethods.size(); ++i) {
            if (!collection.contains(attributeMethods.get(i))) continue;
            return i;
        }
        return -1;
    }

    private void addConventionMappings() {
        if (this.distance == 0) {
            return;
        }
        AttributeMethods attributeMethods = this.root.getAttributes();
        int[] nArray = this.conventionMappings;
        for (int i = 0; i < nArray.length; ++i) {
            String string = this.attributes.get(i).getName();
            MirrorSets.MirrorSet mirrorSet = this.getMirrorSets().getAssigned(i);
            int n = attributeMethods.indexOf(string);
            if ("value".equals(string) || n == -1) continue;
            nArray[i] = n;
            if (mirrorSet == null) continue;
            for (int j = 0; j < mirrorSet.size(); ++j) {
                nArray[mirrorSet.getAttributeIndex((int)j)] = n;
            }
        }
    }

    private void addConventionAnnotationValues() {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method method = this.attributes.get(i);
            boolean bl = "value".equals(method.getName());
            AnnotationTypeMapping annotationTypeMapping = this;
            while (annotationTypeMapping != null && annotationTypeMapping.distance > 0) {
                int n = annotationTypeMapping.getAttributes().indexOf(method.getName());
                if (n != -1 && this.isBetterConventionAnnotationValue(i, bl, annotationTypeMapping)) {
                    this.annotationValueMappings[i] = n;
                    this.annotationValueSource[i] = annotationTypeMapping;
                }
                annotationTypeMapping = annotationTypeMapping.source;
            }
        }
    }

    private boolean isBetterConventionAnnotationValue(int n, boolean bl, AnnotationTypeMapping annotationTypeMapping) {
        if (this.annotationValueMappings[n] == -1) {
            return true;
        }
        int n2 = this.annotationValueSource[n].distance;
        return !bl && n2 > annotationTypeMapping.distance;
    }

    private boolean computeSynthesizableFlag() {
        for (int n : this.aliasMappings) {
            if (n == -1) continue;
            return true;
        }
        if (!this.aliasedBy.isEmpty()) {
            return true;
        }
        for (int n : this.conventionMappings) {
            if (n == -1) continue;
            return true;
        }
        if (this.getAttributes().hasNestedAnnotation()) {
            Object object = this.getAttributes();
            for (int i = 0; i < ((AttributeMethods)object).size(); ++i) {
                Class<?> clazz;
                AnnotationTypeMapping annotationTypeMapping;
                Method method = ((AttributeMethods)object).get(i);
                Class<?> clazz2 = method.getReturnType();
                if (!clazz2.isAnnotation() && (!clazz2.isArray() || !clazz2.getComponentType().isAnnotation()) || !(annotationTypeMapping = AnnotationTypeMappings.forAnnotationType(clazz = clazz2.isAnnotation() ? clazz2 : clazz2.getComponentType()).get(0)).isSynthesizable()) continue;
                return true;
            }
        }
        return false;
    }

    void afterAllMappingsSet() {
        this.validateAllAliasesClaimed();
        for (int i = 0; i < this.mirrorSets.size(); ++i) {
            this.validateMirrorSet(this.mirrorSets.get(i));
        }
        this.claimedAliases.clear();
    }

    private void validateAllAliasesClaimed() {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method method = this.attributes.get(i);
            AliasFor aliasFor = AnnotationsScanner.getDeclaredAnnotation(method, AliasFor.class);
            if (aliasFor == null || this.claimedAliases.contains(method)) continue;
            Method method2 = this.resolveAliasTarget(method, aliasFor);
            throw new AnnotationConfigurationException(String.format("@AliasFor declaration on %s declares an alias for %s which is not meta-present.", AttributeMethods.describe(method), AttributeMethods.describe(method2)));
        }
    }

    private void validateMirrorSet(MirrorSets.MirrorSet mirrorSet) {
        Method method = mirrorSet.get(0);
        Object object = method.getDefaultValue();
        for (int i = 1; i <= mirrorSet.size() - 1; ++i) {
            Method method2 = mirrorSet.get(i);
            Object object2 = method2.getDefaultValue();
            if (object == null || object2 == null) {
                throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare default values.", AttributeMethods.describe(method), AttributeMethods.describe(method2)));
            }
            if (ObjectUtils.nullSafeEquals(object, object2)) continue;
            throw new AnnotationConfigurationException(String.format("Misconfigured aliases: %s and %s must declare the same default value.", AttributeMethods.describe(method), AttributeMethods.describe(method2)));
        }
    }

    AnnotationTypeMapping getRoot() {
        return this.root;
    }

    @Nullable
    AnnotationTypeMapping getSource() {
        return this.source;
    }

    int getDistance() {
        return this.distance;
    }

    Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    List<Class<? extends Annotation>> getMetaTypes() {
        return this.metaTypes;
    }

    @Nullable
    Annotation getAnnotation() {
        return this.annotation;
    }

    AttributeMethods getAttributes() {
        return this.attributes;
    }

    int getAliasMapping(int n) {
        return this.aliasMappings[n];
    }

    int getConventionMapping(int n) {
        return this.conventionMappings[n];
    }

    @Nullable
    Object getMappedAnnotationValue(int n, boolean bl) {
        int n2 = this.annotationValueMappings[n];
        if (n2 == -1) {
            return null;
        }
        AnnotationTypeMapping annotationTypeMapping = this.annotationValueSource[n];
        if (annotationTypeMapping == this && bl) {
            return null;
        }
        return ReflectionUtils.invokeMethod(annotationTypeMapping.attributes.get(n2), annotationTypeMapping.annotation);
    }

    boolean isEquivalentToDefaultValue(int n, Object object, ValueExtractor valueExtractor) {
        Method method = this.attributes.get(n);
        return AnnotationTypeMapping.isEquivalentToDefaultValue(method, object, valueExtractor);
    }

    MirrorSets getMirrorSets() {
        return this.mirrorSets;
    }

    boolean isSynthesizable() {
        return this.synthesizable;
    }

    private static int[] filledIntArray(int n) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private static boolean isEquivalentToDefaultValue(Method method, Object object, ValueExtractor valueExtractor) {
        return AnnotationTypeMapping.areEquivalent(method.getDefaultValue(), object, valueExtractor);
    }

    private static boolean areEquivalent(@Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor) {
        if (ObjectUtils.nullSafeEquals(object, object2)) {
            return true;
        }
        if (object instanceof Class && object2 instanceof String) {
            return AnnotationTypeMapping.areEquivalent((Class)object, (String)object2);
        }
        if (object instanceof Class[] && object2 instanceof String[]) {
            return AnnotationTypeMapping.areEquivalent((Class[])object, (String[])object2);
        }
        if (object instanceof Annotation) {
            return AnnotationTypeMapping.areEquivalent((Annotation)object, object2, valueExtractor);
        }
        return false;
    }

    private static boolean areEquivalent(Class<?>[] classArray, String[] stringArray) {
        if (classArray.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (AnnotationTypeMapping.areEquivalent(classArray[i], stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquivalent(Class<?> clazz, String string) {
        return clazz.getName().equals(string);
    }

    private static boolean areEquivalent(Annotation annotation, @Nullable Object object, ValueExtractor valueExtractor) {
        AttributeMethods attributeMethods = AttributeMethods.forAnnotationType(annotation.annotationType());
        for (int i = 0; i < attributeMethods.size(); ++i) {
            Object object2;
            Method method = attributeMethods.get(i);
            Object object3 = ReflectionUtils.invokeMethod(method, annotation);
            if (AnnotationTypeMapping.areEquivalent(object3, object2 = object instanceof TypeMappedAnnotation ? ((TypeMappedAnnotation)object).getValue(method.getName()).orElse(null) : valueExtractor.extract(method, object), valueExtractor)) continue;
            return false;
        }
        return true;
    }

    class MirrorSets {
        private MirrorSet[] mirrorSets;
        private final MirrorSet[] assigned;

        MirrorSets() {
            this.assigned = new MirrorSet[AnnotationTypeMapping.this.attributes.size()];
            this.mirrorSets = EMPTY_MIRROR_SETS;
        }

        void updateFrom(Collection<Method> collection) {
            MirrorSet mirrorSet = null;
            int n = 0;
            int n2 = -1;
            for (int i = 0; i < AnnotationTypeMapping.this.attributes.size(); ++i) {
                Method method = AnnotationTypeMapping.this.attributes.get(i);
                if (!collection.contains(method)) continue;
                if (++n > 1) {
                    if (mirrorSet == null) {
                        this.assigned[n2] = mirrorSet = new MirrorSet();
                    }
                    this.assigned[i] = mirrorSet;
                }
                n2 = i;
            }
            if (mirrorSet != null) {
                mirrorSet.update();
                LinkedHashSet<MirrorSet> linkedHashSet = new LinkedHashSet<MirrorSet>(Arrays.asList(this.assigned));
                linkedHashSet.remove(null);
                this.mirrorSets = linkedHashSet.toArray(EMPTY_MIRROR_SETS);
            }
        }

        int size() {
            return this.mirrorSets.length;
        }

        MirrorSet get(int n) {
            return this.mirrorSets[n];
        }

        @Nullable
        MirrorSet getAssigned(int n) {
            return this.assigned[n];
        }

        int[] resolve(@Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor) {
            int n;
            int[] nArray = new int[AnnotationTypeMapping.this.attributes.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
            for (n = 0; n < this.size(); ++n) {
                MirrorSet mirrorSet = this.get(n);
                int n2 = mirrorSet.resolve(object, object2, valueExtractor);
                for (int i = 0; i < mirrorSet.size; ++i) {
                    nArray[((MirrorSet)mirrorSet).indexes[i]] = n2;
                }
            }
            return nArray;
        }

        class MirrorSet {
            private int size;
            private final int[] indexes;

            MirrorSet() {
                this.indexes = new int[AnnotationTypeMapping.this.attributes.size()];
            }

            void update() {
                this.size = 0;
                Arrays.fill(this.indexes, -1);
                for (int i = 0; i < MirrorSets.this.assigned.length; ++i) {
                    if (MirrorSets.this.assigned[i] != this) continue;
                    this.indexes[this.size] = i;
                    ++this.size;
                }
            }

            <A> int resolve(@Nullable Object object, @Nullable A a, ValueExtractor valueExtractor) {
                int n = -1;
                Object object2 = null;
                for (int i = 0; i < this.size; ++i) {
                    boolean bl;
                    Method method = AnnotationTypeMapping.this.attributes.get(this.indexes[i]);
                    Object object3 = valueExtractor.extract(method, a);
                    boolean bl2 = bl = object3 == null || AnnotationTypeMapping.isEquivalentToDefaultValue(method, object3, valueExtractor);
                    if (bl || ObjectUtils.nullSafeEquals(object2, object3)) {
                        if (n != -1) continue;
                        n = this.indexes[i];
                        continue;
                    }
                    if (object2 != null && !ObjectUtils.nullSafeEquals(object2, object3)) {
                        String string = object != null ? " declared on " + object : "";
                        throw new AnnotationConfigurationException(String.format("Different @AliasFor mirror values for annotation [%s]%s; attribute '%s' and its alias '%s' are declared with values of [%s] and [%s].", AnnotationTypeMapping.this.getAnnotationType().getName(), string, AnnotationTypeMapping.this.attributes.get(n).getName(), method.getName(), ObjectUtils.nullSafeToString(object2), ObjectUtils.nullSafeToString(object3)));
                    }
                    n = this.indexes[i];
                    object2 = object3;
                }
                return n;
            }

            int size() {
                return this.size;
            }

            Method get(int n) {
                int n2 = this.indexes[n];
                return AnnotationTypeMapping.this.attributes.get(n2);
            }

            int getAttributeIndex(int n) {
                return this.indexes[n];
            }
        }
    }
}

