/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private static final String UNKNOWN = "unknown";
    @Nullable
    private final Class<? extends Annotation> annotationType;
    final String displayName;
    boolean validated = false;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(int n) {
        super(n);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(Map<String, Object> map) {
        super(map);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(AnnotationAttributes annotationAttributes) {
        super(annotationAttributes);
        this.annotationType = annotationAttributes.annotationType;
        this.displayName = annotationAttributes.displayName;
        this.validated = annotationAttributes.validated;
    }

    public AnnotationAttributes(Class<? extends Annotation> clazz) {
        Assert.notNull(clazz, "'annotationType' must not be null");
        this.annotationType = clazz;
        this.displayName = clazz.getName();
    }

    AnnotationAttributes(Class<? extends Annotation> clazz, boolean bl) {
        Assert.notNull(clazz, "'annotationType' must not be null");
        this.annotationType = clazz;
        this.displayName = clazz.getName();
        this.validated = bl;
    }

    public AnnotationAttributes(String string, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)string, "'annotationType' must not be null");
        this.annotationType = AnnotationAttributes.getAnnotationType(string, classLoader);
        this.displayName = string;
    }

    @Nullable
    private static Class<? extends Annotation> getAnnotationType(String string, @Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String string) {
        return this.getRequiredAttribute(string, String.class);
    }

    public String[] getStringArray(String string) {
        return this.getRequiredAttribute(string, String[].class);
    }

    public boolean getBoolean(String string) {
        return this.getRequiredAttribute(string, Boolean.class);
    }

    public <N extends Number> N getNumber(String string) {
        return (N)this.getRequiredAttribute(string, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String string) {
        return (E)this.getRequiredAttribute(string, Enum.class);
    }

    public <T> Class<? extends T> getClass(String string) {
        return this.getRequiredAttribute(string, Class.class);
    }

    public Class<?>[] getClassArray(String string) {
        return this.getRequiredAttribute(string, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String string) {
        return this.getRequiredAttribute(string, AnnotationAttributes.class);
    }

    public <A extends Annotation> A getAnnotation(String string, Class<A> clazz) {
        return (A)((Annotation)this.getRequiredAttribute(string, clazz));
    }

    public AnnotationAttributes[] getAnnotationArray(String string) {
        return this.getRequiredAttribute(string, AnnotationAttributes[].class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String string, Class<A> clazz) {
        Object object = Array.newInstance(clazz, 0);
        return (Annotation[])this.getRequiredAttribute(string, object.getClass());
    }

    private <T> T getRequiredAttribute(String string, Class<T> clazz) {
        Assert.hasText(string, "'attributeName' must not be null or empty");
        Object object = this.get(string);
        this.assertAttributePresence(string, object);
        this.assertNotException(string, object);
        if (!clazz.isInstance(object) && clazz.isArray() && clazz.getComponentType().isInstance(object)) {
            Object object2 = Array.newInstance(clazz.getComponentType(), 1);
            Array.set(object2, 0, object);
            object = object2;
        }
        this.assertAttributeType(string, object, clazz);
        return (T)object;
    }

    private void assertAttributePresence(String string, Object object) {
        Assert.notNull(object, () -> String.format("Attribute '%s' not found in attributes for annotation [%s]", string, this.displayName));
    }

    private void assertNotException(String string, Object object) {
        if (object instanceof Throwable) {
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", string, this.displayName, object), (Throwable)object);
        }
    }

    private void assertAttributeType(String string, Object object, Class<?> clazz) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type %s, but %s was expected in attributes for annotation [%s]", string, object.getClass().getSimpleName(), clazz.getSimpleName(), this.displayName));
        }
    }

    @Override
    public String toString() {
        Iterator iterator2 = this.entrySet().iterator();
        StringBuilder stringBuilder = new StringBuilder("{");
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(this.valueToString(entry.getValue()));
            stringBuilder.append(iterator2.hasNext() ? ", " : "");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String valueToString(Object object) {
        if (object == this) {
            return "(this Map)";
        }
        if (object instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])object, ", ") + "]";
        }
        return String.valueOf(object);
    }

    @Nullable
    public static AnnotationAttributes fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map;
        }
        return new AnnotationAttributes(map);
    }
}

