/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;

public final class SpringProperties {
    private static final String PROPERTIES_RESOURCE_LOCATION = "spring.properties";
    private static final Log logger;
    private static final Properties localProperties;

    private SpringProperties() {
    }

    public static void setProperty(String string, @Nullable String string2) {
        if (string2 != null) {
            localProperties.setProperty(string, string2);
        } else {
            localProperties.remove(string);
        }
    }

    @Nullable
    public static String getProperty(String string) {
        String string2;
        block3: {
            string2 = localProperties.getProperty(string);
            if (string2 == null) {
                try {
                    string2 = System.getProperty(string);
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Could not retrieve system property '" + string + "': " + throwable);
                }
            }
        }
        return string2;
    }

    public static void setFlag(String string) {
        localProperties.put(string, Boolean.TRUE.toString());
    }

    public static boolean getFlag(String string) {
        return Boolean.parseBoolean(SpringProperties.getProperty(string));
    }

    static {
        block5: {
            logger = LogFactory.getLog(SpringProperties.class);
            localProperties = new Properties();
            try {
                URL uRL;
                ClassLoader classLoader = SpringProperties.class.getClassLoader();
                URL uRL2 = uRL = classLoader != null ? classLoader.getResource(PROPERTIES_RESOURCE_LOCATION) : ClassLoader.getSystemResource(PROPERTIES_RESOURCE_LOCATION);
                if (uRL == null) break block5;
                logger.debug("Found 'spring.properties' file in local classpath");
                try (InputStream inputStream2 = uRL.openStream();){
                    localProperties.load(inputStream2);
                }
            }
            catch (IOException iOException) {
                if (!logger.isInfoEnabled()) break block5;
                logger.info("Could not load 'spring.properties' file from local classpath: " + iOException);
            }
        }
    }
}

